/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.addon.Addon;
import net.fexcraft.mod.uni.IDL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class TexUtil {
    public static final HashMap<ResourceLocation, Object> litex = new HashMap();
    public static final Minecraft mc = Minecraft.func_71410_x();

    public static void bindTexture(IDL idl) {
        TexUtil.bindTexture((ResourceLocation)idl);
    }

    public static void bindTexture(ResourceLocation loc) {
        Object obj = mc.func_110434_K().func_110581_b(loc);
        if (obj == null) {
            Object res = litex.get(loc);
            boolean success = false;
            if (res != null) {
                obj = new SimplerTexture(loc);
                success = mc.func_110434_K().func_110579_a(loc, obj);
            }
            if (!success) {
                obj = new SimpleTexture(loc);
                mc.func_110434_K().func_110579_a(loc, obj);
            }
        }
        GlStateManager.func_179144_i((int)obj.func_110552_b());
    }

    public static void searchIn(Addon addon, File texfolder, String sub) {
        if (!texfolder.exists()) {
            return;
        }
        sub = sub == null ? "textures/" : sub;
        for (File file : texfolder.listFiles()) {
            if (file.isDirectory()) {
                TexUtil.searchIn(addon, file, sub + file.getName() + "/");
                continue;
            }
            if (!file.getName().endsWith(".png")) continue;
            litex.put(new ResourceLocation(addon.getID().id(), sub + file.getName()), file);
        }
    }

    public static void searchInZip(Addon addon) {
        String path = "assets/" + addon.getID().id() + "/textures/";
        String suffix = ".png";
        try {
            ZipEntry entry;
            ZipInputStream stream = new ZipInputStream(new FileInputStream(addon.getFile()));
            while ((entry = stream.getNextEntry()) != null) {
                if (!entry.getName().startsWith(path) || !entry.getName().endsWith(suffix)) continue;
                String name = entry.getName();
                litex.put(new ResourceLocation(addon.getID().id(), name.substring(name.indexOf("textures/"))), name);
            }
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object[] getZipIS(String addonid, String path) {
        try {
            ZipEntry entry;
            Addon addon = FvtmRegistry.getAddon(addonid);
            ZipFile zip = new ZipFile(addon.getFile());
            ZipInputStream stream = new ZipInputStream(new FileInputStream(addon.getFile()));
            InputStream is = null;
            while ((entry = stream.getNextEntry()) != null) {
                if (!entry.getName().equals(path)) continue;
                is = zip.getInputStream(entry);
                break;
            }
            stream.close();
            if (is != null) {
                return new Object[]{is, zip};
            }
            zip.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isMissing(ResourceLocation resloc) {
        if (litex.containsKey(resloc)) {
            return false;
        }
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resloc);
            return res == null;
        }
        catch (IOException e) {
            return true;
        }
    }

    public static class SimplerTexture
    extends AbstractTexture {
        private final ResourceLocation resloc;

        public SimplerTexture(ResourceLocation textureResourceLocation) {
            this.resloc = textureResourceLocation;
        }

        public void func_110551_a(IResourceManager resman) {
            this.func_147631_c();
            Closeable iresource = null;
            Object obj = litex.get(this.resloc);
            try {
                Object[] objectArray;
                if (obj instanceof File) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = new FileInputStream((File)obj);
                } else {
                    objectArray = TexUtil.getZipIS(this.resloc.func_110624_b(), (String)obj);
                }
                Object[] is = objectArray;
                BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)((InputStream)is[0]));
                if (is.length > 1) {
                    ((Closeable)is[1]).close();
                }
                TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)bufferedimage, (boolean)false, (boolean)false);
                IOUtils.closeQuietly(iresource);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

