/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import java.util.TreeMap;
import net.fexcraft.lib.common.math.Vec3f;

public class TransformMap
extends TreeMap<String, Vec3f> {
    public static String[] TYPES = new String[]{"null"};

    public TransformMap(int gltype) {
        for (String type : TYPES) {
            Vec3f vector = new Vec3f();
            if (gltype == 0) {
                vector.z = 0.125f;
                vector.y = 0.125f;
                vector.x = 0.125f;
            } else if (gltype == 1 && type.equals("GROUND")) {
                vector.x = -0.45f;
                vector.y = -0.05f;
            } else if (gltype == 2 && (type.equals("FIRST_PERSON_LEFT_HAND") || type.equals("FIRST_PERSON_RIGHT_HAND"))) {
                vector.y = type.equals("FIRST_PERSON_LEFT_HAND") ? 60.0f : 120.0f;
            } else if (gltype == 2 && type.equals("GUI")) {
                vector.x = -30.0f;
                vector.y = -135.0f;
                vector.z = -30.0f;
            }
            this.put(type, vector);
        }
    }

    public void set(String type, Vec3f vector) {
        this.put(type, vector);
    }

    public void set(String type, float x, float y, float z) {
        ((Vec3f)this.get((Object)type)).x = x;
        ((Vec3f)this.get((Object)type)).y = y;
        ((Vec3f)this.get((Object)type)).z = z;
    }

    public void setAll(float x, float y, float z) {
        for (String type : TYPES) {
            this.set(type, x, y, z);
        }
    }

    public void setAll(float xyz) {
        this.setAll(xyz, xyz, xyz);
    }

    public void add(String type, float x, float y, float z) {
        ((Vec3f)this.get((Object)type)).x += x;
        ((Vec3f)this.get((Object)type)).y += y;
        ((Vec3f)this.get((Object)type)).z += z;
    }

    public void addAll(float x, float y, float z) {
        for (String type : TYPES) {
            this.add(type, x, y, z);
        }
    }

    public void sub(String type, float x, float y, float z) {
        ((Vec3f)this.get((Object)type)).x -= x;
        ((Vec3f)this.get((Object)type)).y -= y;
        ((Vec3f)this.get((Object)type)).z -= z;
    }

    public void subAll(float x, float y, float z) {
        for (String type : TYPES) {
            this.sub(type, x, y, z);
        }
    }
}

