/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util.script;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.block.ContainerBlock;
import net.fexcraft.mod.fvtm.block.ContainerEntity;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.attribute.AttrVector;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.container.Container;
import net.fexcraft.mod.fvtm.data.container.ContainerData;
import net.fexcraft.mod.fvtm.data.container.ContainerHolder;
import net.fexcraft.mod.fvtm.data.container.ContainerSlot;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleEntity;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleScript;
import net.fexcraft.mod.fvtm.item.ContainerItem;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class ContainerScript
extends VehicleScript {
    @Override
    public String getId() {
        return "fvtm:container_script";
    }

    @Override
    public String getName() {
        return "Container Base/Basic Script";
    }

    @Override
    public void onAttributeToggle(Entity entity, Attribute<?> attr, Object oldvalue, EntityPlayer player) {
        Vec3d offset;
        boolean bool;
        if (entity.field_70170_p.field_72995_K || attr == null) {
            return;
        }
        if (!attr.id.startsWith("container_script:break")) {
            if (!attr.id.startsWith("container_script:place")) {
                return;
            }
            bool = false;
        } else {
            bool = true;
        }
        VehicleEntity ent = (VehicleEntity)entity;
        if (ent.getVehicleData().getThrottle() > 0.0) {
            Print.chat((ICommandSender)player, (String)"&6Please stop the vehicle first!");
            return;
        }
        if ((int)ent.getRotPoint().getPivot().deg_yaw() % 90 != 0) {
            Print.chat((ICommandSender)player, (String)"&6Please make sure the crane is in a valid 90\u00b0 rotation!");
            return;
        }
        String holderid = ent.getVehicleData().getAttributeString("container_script:holder", "holder");
        String rotpoint = ent.getVehicleData().getAttributeString("container_script:rotpoint", "lcc_holder");
        AttrVector vecattr = (AttrVector)ent.getVehicleData().getAttribute("container_script:offset");
        Vec3d vec3d = offset = vecattr == null ? Vec3d.field_186680_a : new Vec3d((double)((Vec3f)vecattr.value).x, (double)((Vec3f)vecattr.value).y, (double)((Vec3f)vecattr.value).z);
        if (bool) {
            ContainerScript.tryBreak(ent, player, holderid, rotpoint, offset, attr.id.endsWith("_single"));
        } else {
            ContainerScript.tryPlace(ent, player, holderid, rotpoint, offset, attr.id.endsWith("_single"));
        }
    }

    public static void tryBreak(VehicleEntity ent, EntityPlayer player, String holderid, String rotpoint, Vec3d offset, boolean single) {
        ContainerHolder ch = (ContainerHolder)ent.getEntity().getCapability(Capabilities.CONTAINER, null);
        if (ch == null) {
            Print.bar((EntityPlayer)player, (String)"&cERROR: Could not find ContainerHolder Capability in Entity!");
            return;
        }
        ContainerSlot holder = ch.getContainerSlot(holderid);
        if (holder == null) {
            Print.bar((EntityPlayer)player, (String)("&cERROR: Could not find '" + holderid + "' ContainerSlot in Entity!"));
            return;
        }
        for (ContainerData data : holder.getContainers()) {
            if (data == null) continue;
            Print.bar((EntityPlayer)player, (String)"&cPlease unload all containers first.");
            return;
        }
        V3D os = new V3D(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        os = ent.getVehicleData().getRotationPoint(rotpoint).getRelativeVector(os.add(-0.4, 0.1, 0.0));
        BlockPos vec0 = new BlockPos(ent.getEntity().func_174791_d().func_72441_c(os.x, os.y, os.z));
        os = ent.getVehicleData().getRotationPoint(rotpoint).getRelativeVector(os.add(0.4, 0.1, 0.0));
        BlockPos vec1 = new BlockPos(ent.getEntity().func_174791_d().func_72441_c(os.x, os.y, os.z));
        Block block0 = player.field_70170_p.func_180495_p(vec0).func_177230_c();
        Block block1 = player.field_70170_p.func_180495_p(vec1).func_177230_c();
        boolean first = false;
        ContainerEntity tile = null;
        if (block0 instanceof ContainerBlock) {
            tile = (ContainerEntity)player.field_70170_p.func_175625_s(vec0);
            first = tile.isCore();
        }
        if (!first && block1 instanceof ContainerBlock && !(tile = (ContainerEntity)player.field_70170_p.func_175625_s(vec1)).isCore()) {
            tile = null;
        }
        if (tile == null) {
            V3D ofs = ent.getVehicleData().getRotationPoint(rotpoint).getRelativeVector(offset.field_72450_a, offset.field_72448_b + 0.1, offset.field_72449_c);
            Vec3d vec2 = ent.getEntity().func_174791_d().func_72441_c(ofs.x, ofs.y, ofs.z);
            ContainerHolder cap = null;
            String slotid = null;
            Entity capent = null;
            Integer index = null;
            block21: for (Entity entity : player.field_70170_p.field_72996_f) {
                if (capent != null) break;
                if (entity == ent || (cap = (ContainerHolder)entity.getCapability(Capabilities.CONTAINER, null)) == null || cap.getWrapper() == null) continue;
                for (String str : cap.getContainerSlotIds()) {
                    if (capent != null) continue block21;
                    if (single) {
                        ContainerSlot slot = cap.getContainerSlot(str);
                        if (slot == null) continue;
                        for (int i = 0; i < slot.length; ++i) {
                            if (slot.getContainers()[i] == null) continue;
                            ContainerData data = slot.getContainers()[i];
                            Vec3d capos = cap.getWrapper().getContainerInSlotPosition(str, cap, data.getContainerType(), i);
                            AxisAlignedBB bb = new AxisAlignedBB(capos.func_72441_c(-0.49, 0.0, -0.49), capos.func_72441_c(0.49, 1.0, 0.49));
                            if (!bb.func_72318_a(vec2)) continue;
                            slotid = str;
                            capent = entity;
                            index = i;
                            break;
                        }
                        if (index != null) continue;
                        capent = null;
                        continue;
                    }
                    Vec3d capos = cap.getWrapper().getContainerSlotPosition(str, cap);
                    AxisAlignedBB bb = new AxisAlignedBB(capos.func_72441_c(-0.5, 0.0, -0.5), capos.func_72441_c(0.5, 1.0, 0.5));
                    if (bb.func_72318_a(vec2)) {
                        slotid = str;
                        capent = entity;
                        continue;
                    }
                    capent = null;
                }
            }
            if (cap != null && slotid != null) {
                ContainerSlot slot = cap.getContainerSlot(slotid);
                boolean empty = true;
                for (ContainerData con : slot.getContainers()) {
                    if (con == null) continue;
                    empty = false;
                    break;
                }
                if (empty) {
                    Print.bar((EntityPlayer)player, (String)("&6No Containers in Vehicle: &3" + capent.func_70005_c_()));
                    return;
                }
                if (index != null) {
                    ContainerData data = slot.getContainers()[index];
                    slot.setContainer(index, null);
                    int off = 0;
                    switch (data.getContainerType().length()) {
                        case 12: {
                            off = 0;
                            break;
                        }
                        case 6: {
                            off = 3;
                            break;
                        }
                        case 3: {
                            off = 5;
                            break;
                        }
                        case 2: {
                            off = 5;
                            break;
                        }
                        case 1: {
                            off = 6;
                        }
                    }
                    holder.setContainer(off, data);
                } else {
                    int off = 0;
                    switch (slot.length) {
                        case 12: {
                            off = 0;
                            break;
                        }
                        case 6: {
                            off = 3;
                            break;
                        }
                        case 3: {
                            off = 5;
                            break;
                        }
                        case 1: 
                        case 2: {
                            off = 6;
                        }
                    }
                    for (int i = 0; i < slot.getContainers().length; ++i) {
                        if (slot.getContainers()[i] == null) continue;
                        holder.setContainer(i + off, slot.getContainers()[i]);
                        slot.setContainer(i, null);
                    }
                }
                cap.sync(false);
                ch.sync(false);
                Print.bar((EntityPlayer)player, (String)("&6Loaded from: &3" + capent.func_70005_c_()));
                return;
            }
            Print.bar((EntityPlayer)player, (String)"&cNo Container found at position.");
            return;
        }
        ContainerData data = tile.getContainerData();
        IBlockState state = player.field_70170_p.func_180495_p(first ? vec0 : vec1);
        tile.notifyBreak(ent.getEntity().field_70170_p, first ? vec0 : vec1, state, false);
        switch (data.getContainerType()) {
            case LARGE: {
                holder.setContainer(0, data);
                break;
            }
            case MEDIUM: {
                holder.setContainer(3, data);
                break;
            }
            case SMALL: {
                holder.setContainer(5, data);
                break;
            }
            case TINY: {
                holder.setContainer(6, data);
                break;
            }
            case MICRO: {
                holder.setContainer(6, data);
                break;
            }
        }
        Print.bar((EntityPlayer)player, (String)("&6Loaded: &3" + ((Container)data.getType()).getName()));
        ch.sync(player.field_70170_p.field_72995_K);
    }

    public static void tryPlace(VehicleEntity ent, EntityPlayer player, String holderid, String rotpoint, Vec3d offset, boolean single) {
        Vec3d vec1;
        ContainerHolder ch = (ContainerHolder)ent.getEntity().getCapability(Capabilities.CONTAINER, null);
        if (ch == null) {
            Print.bar((EntityPlayer)player, (String)"&cERROR: Could not find ContainerHolder Capability in Entity!");
            return;
        }
        ContainerSlot holder = ch.getContainerSlot(holderid);
        if (holder == null) {
            Print.bar((EntityPlayer)player, (String)("&cERROR: Could not find '" + holderid + "' ContainerSlot in Entity!"));
            return;
        }
        boolean found = false;
        for (ContainerData data : holder.getContainers()) {
            if (data == null) continue;
            found = true;
            break;
        }
        if (!found) {
            Print.bar((EntityPlayer)player, (String)"&cThere are no containers loaded!");
            return;
        }
        ContainerData firstcon = null;
        int hlength = 0;
        int firstid = 0;
        for (int i = 0; i < holder.length; ++i) {
            if (holder.getContainers()[i] == null) continue;
            firstcon = holder.getContainers()[i];
            firstid = i;
            break;
        }
        if (!single) {
            for (ContainerData data : holder.getContainers()) {
                if (data == null) continue;
                hlength += data.getContainerType().length();
            }
            V3D ofs = ent.getVehicleData().getRotationPoint(rotpoint).getRelativeVector(offset.field_72450_a, offset.field_72448_b + 0.1, offset.field_72449_c);
            vec1 = ent.getEntity().func_174791_d().func_72441_c(ofs.x, ofs.y, ofs.z);
        } else {
            float off = firstid - holder.getContainers().length / 2 + firstcon.getContainerType().length() / 2;
            V3D ofs = ent.getVehicleData().getRotationPoint(rotpoint).getRelativeVector(offset.field_72450_a, offset.field_72448_b + 0.1, offset.field_72449_c);
            vec1 = ent.getEntity().func_174791_d().func_72441_c(ofs.x, ofs.y, ofs.z);
        }
        ContainerHolder cap = null;
        String slotid = null;
        Entity capent = null;
        Integer index = null;
        block3: for (Entity entity : player.field_70170_p.field_72996_f) {
            if (capent != null) break;
            if (entity == ent || (cap = (ContainerHolder)entity.getCapability(Capabilities.CONTAINER, null)) == null || cap.getWrapper() == null) continue;
            for (String str : cap.getContainerSlotIds()) {
                if (capent != null) continue block3;
                if (single) {
                    ContainerSlot slot = cap.getContainerSlot(str);
                    if (slot == null || slot.length < firstcon.getContainerType().length()) continue;
                    int i = 0;
                    while (i < slot.length) {
                        if (slot.getContainers()[i] != null) {
                            i += slot.getContainers()[i].getContainerType().length();
                            continue;
                        }
                        Vec3d capos = cap.getWrapper().getContainerInSlotPosition(str, cap, firstcon.getContainerType(), i);
                        AxisAlignedBB bb = new AxisAlignedBB(capos.func_72441_c(-0.48, 0.0, -0.48), capos.func_72441_c(0.48, 1.0, 0.48));
                        if (bb.func_72318_a(vec1)) {
                            slotid = str;
                            capent = entity;
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index != null) continue;
                    capent = null;
                    continue;
                }
                Vec3d capos = cap.getWrapper().getContainerSlotPosition(str, cap);
                AxisAlignedBB bb = new AxisAlignedBB(capos.func_72441_c(-0.5, 0.0, -0.5), capos.func_72441_c(0.5, 1.0, 0.5));
                if (bb.func_72318_a(vec1)) {
                    slotid = str;
                    capent = entity;
                    continue;
                }
                capent = null;
            }
        }
        if (cap != null && slotid != null) {
            ContainerSlot slot = cap.getContainerSlot(slotid);
            if (!single && hlength > slot.length) {
                Print.bar((EntityPlayer)player, (String)("&cLoaded Containers are longer than the Slot. " + String.format("%s > %s", hlength, slot.length)));
                return;
            }
            if (index != null) {
                for (int i = 0; i < firstcon.getContainerType().length(); ++i) {
                    if (index + i < slot.getContainers().length && slot.getContainers()[index + i] == null) continue;
                    Print.bar((EntityPlayer)player, (String)("&cNo space to load Container into slot! " + String.format("%s !> %s", index, index + i)));
                    return;
                }
                slot.setContainer(index, firstcon);
                holder.setContainer(firstid, null);
            } else {
                int i;
                int free = 0;
                int i2 = 0;
                while (i2 < slot.length) {
                    if (slot.getContainers()[i2] == null) {
                        ++free;
                        ++i2;
                        continue;
                    }
                    i2 += slot.getContainers()[i2].getContainerType().length();
                }
                if (free < hlength) {
                    Print.bar((EntityPlayer)player, (String)("&cNo space to load all Containers into slot! " + String.format("%s !> %s", free, hlength)));
                    return;
                }
                int last = slot.reSort();
                for (i = 0; i < holder.getContainers().length; ++i) {
                    if (holder.getContainers()[i] == null) continue;
                    ContainerData condata = holder.getContainers()[i];
                    slot.setContainer(last, condata);
                    last += condata.getContainerType().length();
                }
                for (i = 0; i < holder.length; ++i) {
                    holder.setContainer(i, null);
                }
            }
            cap.sync(false);
            ch.sync(false);
            Print.bar((EntityPlayer)player, (String)("&6Unloaded to: &3" + capent.func_70005_c_()));
            return;
        }
        boolean passed = false;
        for (int i = 0; i < holder.getContainers().length; ++i) {
            if (holder.getContainers()[i] == null) continue;
            if (passed && single) break;
            passed = true;
            ContainerData condata = holder.getContainers()[i];
            float off = i - holder.getContainers().length / 2 + condata.getContainerType().length() / 2;
            V3D ofs = ent.getVehicleData().getRotationPoint(rotpoint).getRelativeVector(offset.field_72450_a, offset.field_72448_b + 0.1, offset.field_72449_c);
            vec1 = ent.getEntity().func_174791_d().func_72441_c(ofs.x, ofs.y, ofs.z);
            BlockPos vec0 = new BlockPos(vec1);
            Block block0 = player.field_70170_p.func_180495_p(vec0).func_177230_c();
            if (block0 == Blocks.field_150350_a || block0.func_176200_f((IBlockAccess)player.field_70170_p, vec0)) {
                if (player.field_70170_p.func_180495_p(vec0.func_177977_b()).func_177230_c().func_176200_f((IBlockAccess)player.field_70170_p, vec0.func_177977_b())) {
                    if (single) {
                        Print.bar((EntityPlayer)player, (String)"&cNot solid block bellow core Position.");
                    } else {
                        Print.chat((ICommandSender)player, (String)("&cNot solid block bellow core Position." + (single ? "" : " &3slot:" + i)));
                    }
                    return;
                }
                EnumFacing facing = EnumFacing.func_176733_a((double)ent.getRotPoint().getPivot().deg_yaw());
                if (ContainerItem.isValidPostitionForContainer(ent.getEntity().field_70170_p, player, vec0, facing, condata)) {
                    ItemStack stack = (ItemStack)condata.getNewStack().local();
                    stack.func_77978_p().func_74772_a("PlacedPos", vec0.func_177986_g());
                    ContainerBlock.getPositions(condata, vec0, facing).forEach(blkpos -> {
                        IBlockState state = ContainerBlock.INSTANCE.func_176223_P();
                        state.func_177230_c().func_180633_a(player.field_70170_p, blkpos, state.func_177226_a((IProperty)ContainerBlock.FACING, (Comparable)facing), (EntityLivingBase)player, stack);
                    });
                    stack.func_190918_g(64);
                    if (single) {
                        Print.bar((EntityPlayer)player, (String)("&3" + ((Container)condata.getType()).getName() + " &6placed."));
                    } else {
                        Print.chat((ICommandSender)player, (String)("&3" + ((Container)condata.getType()).getName() + " &6placed." + (single ? "" : " &3slot:" + i)));
                    }
                    holder.setContainer(i, null);
                    ch.sync(false);
                    continue;
                }
                if (single) {
                    Print.bar((EntityPlayer)player, (String)"&cContainer could not be placed.");
                    continue;
                }
                Print.chat((ICommandSender)player, (String)("&cContainer could not be placed." + (single ? "" : " &3slot:" + i)));
                continue;
            }
            if (single) {
                Print.bar((EntityPlayer)player, (String)"&cNot replaceable block at core Position.");
            } else {
                Print.chat((ICommandSender)player, (String)("&cNot replaceable block at core Position." + (single ? "" : " &3slot:" + i)));
            }
            return;
        }
    }
}

