/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util.script;

import com.google.gson.JsonElement;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.lib.script.ScrAction;
import net.fexcraft.lib.script.ScrElm;
import net.fexcraft.lib.script.Script;
import net.fexcraft.mod.fvtm.data.Seat;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleScript;
import net.fexcraft.mod.fvtm.event.EventHandler;
import net.fexcraft.mod.fvtm.sys.uni.KeyPress;
import net.fexcraft.mod.fvtm.util.script.VehicleScriptContext;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;

public class FSVehicleScript
extends VehicleScript {
    private Script script;
    private String id;
    private ResourceLocation resloc;
    private ScrAction update;
    private ScrAction save;
    private ScrAction load;
    private ScrAction spawn;
    private ScrAction remove;
    private ScrAction keypress;
    private ScrAction attrtoggle;
    private ScrAction interact;
    private ScrAction onpacket;
    private boolean hasUpdate;
    private boolean hasSave;
    private boolean hasLoad;
    private boolean hasSpawn;
    private boolean hasRemove;
    private boolean hasKeyPress;
    private boolean hasAttrToggle;
    private boolean hasInteract;
    private boolean hasPacket;
    private VehicleScriptContext context;

    public void set(JsonElement elm) {
        this.parseId(elm);
    }

    private void parseId(JsonElement elm) {
        this.resloc = new ResourceLocation(elm.isJsonObject() ? elm.getAsJsonObject().get("script_location").getAsString() : elm.getAsString());
        this.id = this.resloc.func_110624_b() + (this.resloc.func_110623_a().contains("/") ? this.resloc.func_110623_a().substring(this.resloc.func_110623_a().lastIndexOf("/")) : this.resloc.func_110623_a());
        if (this.id.endsWith(".script")) {
            this.id = this.id.substring(0, this.id.length() - 7);
        }
    }

    @Override
    public VehicleScript init(VehicleData data, JsonElement elm) {
        this.parseId(elm);
        Object[] obj = EventHandler.getInputStream(this.resloc);
        this.script = new Script((InputStream)obj[0], this.id);
        if (obj.length > 1) {
            for (Closeable cl : (Closeable[])obj[1]) {
                try {
                    cl.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.hasUpdate = (this.update = (ScrAction)this.script.blocks.get("update")) != null;
        this.save = (ScrAction)this.script.blocks.get("save");
        this.hasSave = this.save != null;
        this.load = (ScrAction)this.script.blocks.get("load");
        this.hasLoad = this.load != null;
        this.spawn = (ScrAction)this.script.blocks.get("spawn");
        this.hasSpawn = this.spawn != null;
        this.remove = (ScrAction)this.script.blocks.get("remove");
        this.hasRemove = this.remove != null;
        this.keypress = (ScrAction)this.script.blocks.get("keypress");
        this.hasKeyPress = this.keypress != null;
        this.attrtoggle = (ScrAction)this.script.blocks.get("attr_toggle");
        this.hasAttrToggle = this.attrtoggle != null;
        this.interact = (ScrAction)this.script.blocks.get("interact");
        this.hasInteract = this.interact != null;
        this.onpacket = (ScrAction)this.script.blocks.get("data_packet");
        this.hasPacket = this.onpacket != null;
        this.context = new VehicleScriptContext(data, this);
        Print.debug((Object)this.script);
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return "VehicleFS(" + this.id + ")";
    }

    @Override
    public void onUpdate(Entity entity, VehicleData data) {
        if (!this.hasUpdate) {
            return;
        }
        this.update.process(new ScrElm[]{this.context.update(entity)});
    }

    @Override
    public VehicleScript load(VehicleData data, TagCW compound) {
        return this;
    }

    @Override
    public TagCW save(VehicleData data, TagCW compound) {
        return null;
    }

    @Override
    public void onSpawn(Entity entity, VehicleData data) {
        if (!this.hasSpawn) {
            return;
        }
        this.spawn.process(new ScrElm[]{this.context.update(entity)});
    }

    @Override
    public void onRemove(Entity entity, VehicleData data) {
        if (!this.hasRemove) {
            return;
        }
        this.remove.process(new ScrElm[]{this.context.update(entity)});
    }

    @Override
    public boolean onKeyPress(KeyPress key, Seat seat, EntityPlayer player) {
        if (!this.hasKeyPress) {
            return false;
        }
        return this.update.process(new ScrElm[]{this.context.update(seat, player)}).scr_bln();
    }

    @Override
    public void onAttributeToggle(Entity entity, Attribute<?> attr, Object oldvalue, EntityPlayer player) {
        if (!this.hasAttrToggle) {
            return;
        }
        this.attrtoggle.process(new ScrElm[]{this.context.update(entity, attr, oldvalue, player)});
    }

    @Override
    public boolean onInteract(Entity entity, VehicleData data, EntityPlayer player, EnumHand hand) {
        if (!this.hasInteract) {
            return false;
        }
        return this.interact.process(new ScrElm[]{this.context.update(entity)}).scr_bln();
    }

    @Override
    public void onDataPacket(Entity entity, VehicleData data, NBTTagCompound compound, Side side) {
        if (side.isClient() && compound.func_74764_b("ScriptElm")) {
            this.context.onElmUpdate(compound);
        }
        if (!this.hasPacket) {
            return;
        }
        this.onpacket.process(new ScrElm[]{this.context.update(entity).update(compound, side)});
    }

    public Script script() {
        return this.script;
    }
}

