/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;

public class InteractZone {
    public final String id;
    public final String point;
    public final V3D pos;
    public final Boolean set;
    public float range;
    public boolean def;

    public InteractZone(String izid, V3D vec, float size, String spoint) {
        this.id = izid;
        this.pos = vec;
        this.range = size;
        this.point = spoint;
        this.set = null;
        this.validate();
    }

    public InteractZone(String izid, JsonValue val) {
        this.id = izid;
        if (val.isArray()) {
            JsonArray arr = val.asArray();
            if (arr.get(0).string_value().equals("expand") || arr.get(0).string_value().equals("set")) {
                this.pos = V3D.NULL;
                this.range = arr.get(1).float_value();
                this.point = arr.size() > 2 ? arr.get(2).string_value() : "vehicle";
                this.set = arr.get(0).string_value().equals("set");
            } else {
                this.pos = ContentConfigUtil.getVector(arr);
                this.range = arr.size() > 3 ? arr.get(3).float_value() : 4.0f;
                this.point = arr.size() > 4 ? arr.get(4).string_value() : "vehicle";
                this.set = null;
            }
        } else {
            JsonMap map = val.asMap();
            this.pos = map.has("pos") ? ContentConfigUtil.getVector(map.getArray("pos")) : V3D.NULL;
            this.range = map.getFloat("range", 4.0f);
            this.point = map.getString("point", "vehicle");
            String ex = map.getString("mode", null);
            this.set = ex != null ? (ex.equals("expand") ? Boolean.valueOf(false) : (ex.equals("set") ? Boolean.valueOf(true) : null)) : null;
        }
        this.validate();
    }

    public void validate() {
        if (this.range < 1.0f) {
            this.range = 1.0f;
        }
        if (this.range > 16.0f) {
            this.range = 16.0f;
        }
        this.def = this.point.equals("vehicle") && this.pos.isNull();
    }

    public InteractZone copy() {
        return new InteractZone(this.id, this.pos, this.range, this.point);
    }

    public boolean inRange(VehicleInstance inst, V3D pos) {
        V3D loc = this.def ? V3D.NULL : inst.data.getRotationPoint(this.point).getRelativeVector(this.pos);
        return loc.add(inst.entity.getPos()).dis(pos) < (double)(this.range + 1.0f);
    }

    public boolean inRange(VehicleData data, V3D lift, V3D pos) {
        V3D loc = this.def ? V3D.NULL : data.getRotationPoint(this.point).getRelativeVector(this.pos);
        return loc.add(lift).dis(pos) < (double)(this.range + 1.0f);
    }

    public V3D pos(VehicleData data) {
        return this.def ? V3D.NULL : data.getRotationPoint(this.point).getRelativeVector(this.pos);
    }
}

