/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.attribute;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.data.attribute.AttrValueType;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.uni.tag.TagCW;

public class AttrFloat
extends Attribute<Float> {
    public AttrFloat(String id, JsonMap map) {
        this(id, Float.valueOf(map.getFloat("value", 0.0f)));
    }

    public AttrFloat(String aid, Float val) {
        super(aid, AttrValueType.FLOAT, val);
    }

    @Override
    public Float validate(Object val) {
        if (val == null) {
            return Float.valueOf(0.0f);
        }
        float va = 0.0f;
        va = val instanceof Number ? ((Number)val).floatValue() : this.parse(val.toString()).floatValue();
        return Float.valueOf(va > this.max ? this.max : (va < this.min ? this.min : va));
    }

    @Override
    public Float parse(String val) {
        try {
            return this.validate(Float.valueOf(Float.parseFloat(val)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    @Override
    public void increase(float by) {
        this.value = Float.valueOf(((Float)this.value).floatValue() + by);
    }

    @Override
    public void decrease(float by) {
        this.value = Float.valueOf(((Float)this.value).floatValue() - by);
    }

    @Override
    public String type() {
        return "float";
    }

    @Override
    public void saveValue(TagCW com) {
        com.set(this.id, ((Float)this.value).floatValue());
    }

    @Override
    public void loadValue(TagCW com) {
        this.value = Float.valueOf(com.getFloat(this.id));
    }

    @Override
    public Attribute<Float> newInstance() {
        return new AttrFloat(this.id, (Float)this.initial);
    }

    @Override
    public int asInteger() {
        return (int)((Float)this.value).floatValue();
    }

    @Override
    public long asLong() {
        return (long)((Float)this.value).floatValue();
    }

    @Override
    public float asFloat() {
        return ((Float)this.value).floatValue();
    }

    @Override
    public String asString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean asBoolean() {
        return ((Float)this.value).floatValue() > 0.0f;
    }
}

