/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.inv;

import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.data.inv.FvtmInv;
import net.fexcraft.mod.fvtm.data.inv.FvtmInvFluid;
import net.fexcraft.mod.fvtm.data.inv.FvtmInvItems;
import net.fexcraft.mod.fvtm.data.inv.FvtmInvStacks;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.uni.ui.UIKey;

public enum InvType {
    STACK("stack", new RGB("733f00"), "stacks"),
    ITEM("item", new RGB("c96f02"), "stacks"),
    FLUID("fluid", new RGB("02d9e0"), "mB"),
    ENERGY("energy", new RGB("0b8c01"), "FE"),
    CONTAINER("container", new RGB("c40202"), "con"),
    VARIABLE("variable", new RGB("db0272"), "var");

    public final RGB color;
    public final String name;
    public final String unit_suffix;

    private InvType(String nome, RGB rgb, String suffix) {
        this.color = rgb;
        this.unit_suffix = suffix;
        this.name = nome;
    }

    public boolean isItem() {
        return this == ITEM;
    }

    public boolean isStack() {
        return this == STACK;
    }

    public boolean isFluid() {
        return this == FLUID;
    }

    public boolean isEnergy() {
        return this == ENERGY;
    }

    public boolean isVariable() {
        return this == VARIABLE;
    }

    public boolean isContainer() {
        return this == CONTAINER;
    }

    public static InvType parse(String str) {
        str = str.toLowerCase();
        for (InvType type : InvType.values()) {
            if (!type.name.equals(str)) continue;
            return type;
        }
        switch (str) {
            case "items": {
                return ITEM;
            }
            case "stacks": {
                return STACK;
            }
            case "var": 
            case "value": {
                return VARIABLE;
            }
        }
        return ITEM;
    }

    public UIKey getMBUI() {
        switch (this.ordinal()) {
            case 1: {
                return UIKeys.MULTIBLOCK_INVENTORY_ITEM;
            }
            case 2: {
                return UIKeys.MULTIBLOCK_INVENTORY_FLUID;
            }
            case 5: {
                return UIKeys.MULTIBLOCK_INVENTORY_VAR;
            }
        }
        return null;
    }

    public FvtmInv newInv() {
        switch (this.ordinal()) {
            case 0: {
                return new FvtmInvStacks();
            }
            case 1: {
                return new FvtmInvItems();
            }
            case 2: {
                return new FvtmInvFluid();
            }
        }
        return null;
    }
}

