/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.FJson;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.fvtm.data.part.PartInstallHandler;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.Sound;
import net.fexcraft.mod.fvtm.data.root.Soundable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.sys.event.EventHolder;
import net.fexcraft.mod.fvtm.sys.event.EventListener;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;

public class Part
extends Content<Part>
implements Textureable.TextureHolder,
Soundable.SoundHolder,
WithItem,
ItemTextureable {
    protected List<IDL> textures;
    protected ArrayList<String> categories;
    protected ArrayList<PartFunction> functions = new ArrayList();
    protected Map<String, Attribute<?>> attributes = new LinkedHashMap();
    protected Map<String, SwivelPoint> swivelpoints = new LinkedHashMap<String, SwivelPoint>();
    protected Map<String, String> attr_mods = new LinkedHashMap<String, String>();
    protected Map<String, Sound> sounds = new LinkedHashMap<String, Sound>();
    protected EventHolder holder = new EventHolder(this);
    protected PartInstallHandler installhandler;
    protected Object installhandler_data;
    protected Model model;
    protected ModelData modeldata;
    protected IDL itemtexloc;
    protected boolean no3ditem;
    protected String modelid;
    protected String ctab;

    @Override
    public Part parse(JsonMap map) {
        JsonValue inst;
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Part");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.textures = ContentConfigUtil.getTextures(map);
        if (map.has("Category")) {
            if (map.get("Category").isArray()) {
                this.categories = map.getArray("Category").toStringList();
            } else {
                this.categories = new ArrayList();
                this.categories.add(map.getString("Category", "ballast"));
            }
        } else if (map.has("Categories")) {
            this.categories = map.getArray("Categories").toStringList();
        } else {
            this.categories = new ArrayList();
            this.categories.add("undefined");
        }
        if (map.has("Attributes") && map.get("Attributes").isMap()) {
            for (Object entry : map.getMap("Attributes").entries()) {
                Attribute<?> attr = Attribute.parse((String)entry.getKey(), ((JsonValue)entry.getValue()).asMap());
                if (attr == null) continue;
                this.attributes.put(attr.id, attr);
            }
        }
        if (map.has("AttributeModifiers")) {
            JsonMap mod = map.getMap("AttributeModifiers");
            for (Map.Entry entry : mod.entries()) {
                this.attr_mods.put((String)entry.getKey(), ((JsonValue)entry.getValue()).string_value());
            }
        }
        if (map.has("Functions") && map.get("Functions").isMap()) {
            JsonMap funcs = map.getMap("Functions");
            for (Map.Entry entry : funcs.entries()) {
                PartFunction fun = FvtmResources.getFunction((String)entry.getKey());
                if (fun == null) continue;
                this.functions.add(fun.init(this, (FJson)entry.getValue()));
            }
        }
        String instid = (inst = map.get("Installation")) == null ? "default" : (inst.isMap() ? inst.asMap().getString("Handler", "default") : inst.string_value());
        this.installhandler = PartInstallHandler.getHandler(instid);
        this.installhandler_data = this.installhandler.parseData(inst != null && inst.isMap() ? inst.asMap() : new JsonMap());
        if (map.has("SwivelPoints") && map.get("SwivelPoints").isMap()) {
            for (Map.Entry entry : map.getMap("SwivelPoints").entries()) {
                SwivelPoint point = new SwivelPoint((String)entry.getKey(), ((JsonValue)entry.getValue()).asMap());
                this.swivelpoints.put((String)entry.getKey(), point);
            }
        }
        if (map.has("Sounds")) {
            for (Map.Entry entry : map.getMap("Sounds").entries()) {
                if (((JsonValue)entry.getValue()).isMap()) {
                    JsonMap val = ((JsonValue)entry.getValue()).asMap();
                    this.sounds.put((String)entry.getKey(), new Sound(IDLManager.getIDLCached((String)val.getString("sound", "minecraft:block.lever.click")), val.getFloat("volume", 1.0f), val.getFloat("pitch", 1.0f)));
                    continue;
                }
                this.sounds.put((String)entry.getKey(), new Sound(IDLManager.getIDLCached((String)((JsonValue)entry.getValue()).string_value()), 1.0f, 1.0f));
            }
        }
        if (map.has("Events")) {
            for (JsonValue val : (List)map.getArray((String)"Events").value) {
                EventListener lis = null;
                try {
                    lis = EventListener.parse(val);
                }
                catch (Exception e) {
                    FvtmLogger.log(e, "vehicle event parsing");
                }
                if (lis == null) continue;
                this.holder.insert(lis);
            }
        }
        if (EnvInfo.CLIENT || EnvInfo.is121()) {
            this.modelid = map.getString("Model", null);
            this.modeldata = new ModelData(map);
        }
        this.ctab = map.getString("CreativeTab", "default");
        this.itemtexloc = ContentConfigUtil.getItemTexture(this.id, this.getContentType(), map);
        this.no3ditem = map.getBoolean("Disable3DItemModel", false);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.PART;
    }

    @Override
    public Class<?> getDataClass() {
        return PartData.class;
    }

    @Override
    public List<IDL> getDefaultTextures() {
        return this.textures;
    }

    public String getCategory() {
        return this.categories.get(0);
    }

    public Collection<String> getCategories() {
        return this.categories;
    }

    public PartInstallHandler getInstallHandler() {
        return this.installhandler;
    }

    @Override
    public Map<String, Sound> getSounds() {
        return this.sounds;
    }

    public Map<String, Attribute<?>> getDefaultAttributes() {
        return this.attributes;
    }

    public Map<String, SwivelPoint> getDefaultSwivelPoints() {
        return this.swivelpoints;
    }

    public <PIHD> PIHD getInstallHandlerData() {
        return (PIHD)this.installhandler_data;
    }

    @Override
    public IDL getItemTexture() {
        return this.itemtexloc;
    }

    @Override
    public boolean noCustomItemModel() {
        return this.no3ditem;
    }

    public ArrayList<PartFunction> getDefaultFunctions() {
        return this.functions;
    }

    @Override
    public String getItemContainer() {
        return null;
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    public Map<String, String> getStaticModifiers() {
        return this.attr_mods;
    }

    @Override
    public void loadModel() {
        this.model = FvtmResources.getModel(this.modelid, this.modeldata, DefaultModel.class);
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    public EventHolder getEvents() {
        return this.holder;
    }
}

