/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.function.part;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.FJson;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.fvtm.sys.condition.ConditionRegistry;
import net.fexcraft.mod.fvtm.sys.condition.Conditional;
import net.fexcraft.mod.fvtm.sys.particle.Particle;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.world.WorldW;

public class ParticleEmitterFunction
extends PartFunction.StaticFunction {
    public ArrayList<EmitterData> emitters = new ArrayList();

    @Override
    public PartFunction init(Part part, FJson json) {
        if (json == null) {
            return this;
        }
        if (json.isArray()) {
            for (JsonValue elm : (List)json.asArray().value) {
                this.emitters.add(new EmitterData(elm.asMap()));
            }
        } else {
            this.emitters.add(new EmitterData(json.asMap()));
        }
        return this;
    }

    @Override
    public String getId() {
        return "fvtm:particle_emitter";
    }

    @Override
    public void addInformation(StackWrapper stack, WorldW world, PartData data, List<String> tooltip, boolean ext) {
        tooltip.add(Formatter.format((String)"&6[&b#&6]&2 Particle Emitter"));
        if (this.emitters.size() == 1) {
            tooltip.add(Formatter.format((String)("&9Particle: &7" + this.emitters.get((int)0).particle.id)));
            EmitterData e = this.emitters.get(0);
            tooltip.add(Formatter.format((String)("&9Frequncy: &7" + (float)(e.frequency == 0 ? e.particle.frequency : e.frequency) / 20.0f + "/tick")));
        } else {
            tooltip.add(Formatter.format((String)("&9Emitters: &7" + this.emitters.size())));
        }
    }

    public static class EmitterData {
        public Conditional conditional;
        public final Particle particle;
        public final String condition;
        public final int frequency;
        public final Float speed;
        public final V3D dir;
        public final V3D pos;

        public EmitterData(JsonMap map) {
            this.pos = map.has("pos") ? ContentConfigUtil.getVector(map.getArray("pos")) : new V3D();
            this.particle = map.has("particle") ? FvtmRegistry.PARTICLES.get(map.get("particle").string_value()) : null;
            this.frequency = map.getInteger("frequency", 0);
            this.condition = map.getString("condition", null);
            this.dir = map.has("direction") ? ContentConfigUtil.getVector(map.getArray("direction")) : null;
            this.speed = map.has("speed") ? Float.valueOf(map.get("speed").float_value()) : null;
        }

        public Conditional getConditional() {
            if (this.condition == null) {
                return null;
            }
            if (this.conditional == null) {
                this.conditional = ConditionRegistry.get(this.condition);
            }
            return this.conditional;
        }
    }
}

