/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import java.util.ArrayList;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.Polygon;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.frl.Vertex;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.model.content.RailGaugeModel;
import net.fexcraft.mod.fvtm.model.content.WireModel;
import net.fexcraft.mod.fvtm.model.program.WirePrograms;
import net.fexcraft.mod.fvtm.render.PathModelPositioned;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.util.VecUtil;

public class PathModelGenerator {
    public static void generateTrackModel(Track track, RailGaugeModel model) {
        V3D last;
        double angle;
        V3D vec;
        double passed = 0.0;
        float obuf = 0.0f;
        float nbuf = 0.0f;
        V3D cen = track.vecpath[0];
        ArrayList<V3D> path = new ArrayList<V3D>();
        PathModelPositioned tarp = new PathModelPositioned(track, RGB.WHITE);
        for (int p = 0; p < model.rail_model.size(); ++p) {
            path.clear();
            passed = 0.0;
            obuf = 0.0f;
            nbuf = 0.0f;
            float u = model.rail_u.get(p).floatValue();
            float[] vv = model.rail_vv.get(p);
            vec = track.getVectorPosition0(0.001f, false);
            angle = -Math.atan2(track.vecpath[0].x - vec.x, track.vecpath[0].z - vec.z);
            path.add(VecUtil.rotByRad(angle, model.rail_model.get(p)[0]));
            path.add(VecUtil.rotByRad(angle, model.rail_model.get(p)[1]));
            for (int v = 0; v < track.vecpath.length - 1; ++v) {
                last = track.vecpath[v];
                vec = track.vecpath[v + 1];
                angle = -Math.atan2(last.x - vec.x, last.z - vec.z);
                path.add(vec.add(VecUtil.rotByRad(angle, model.rail_model.get(p)[0])).sub(cen));
                path.add(vec.add(VecUtil.rotByRad(angle, model.rail_model.get(p)[1])).sub(cen));
            }
            for (int k = 0; k < track.vecpath.length - 1; ++k) {
                if ((nbuf += (float)track.vecpath[k].dis(track.vecpath[k + 1])) > 1.0f) {
                    nbuf -= 1.0f;
                    obuf -= 1.0f;
                }
                TexturedVertex vert0 = new TexturedVertex((V3D)path.get(k * 2), obuf * u, vv[1]);
                TexturedVertex vert1 = new TexturedVertex((V3D)path.get(k * 2 + 1), obuf * u, vv[0]);
                TexturedVertex vert2 = new TexturedVertex((V3D)path.get((k + 1) * 2), nbuf * u, vv[1]);
                TexturedVertex vert3 = new TexturedVertex((V3D)path.get((k + 1) * 2 + 1), nbuf * u, vv[0]);
                TexturedPolygon poly0 = new TexturedPolygon(new TexturedVertex[]{vert1, vert0, vert2, vert3});
                int pess = (int)passed;
                if (pess >= tarp.hedrons.length) {
                    pess = tarp.hedrons.length - 1;
                }
                tarp.hedrons[pess].importMRT(poly0, 1.0f);
                passed += track.vecpath[k].dis(track.vecpath[k + 1]);
                obuf = nbuf;
            }
        }
        track.railmodel = tarp;
        tarp = new PathModelPositioned(track, null);
        if (track.length > (double)model.ties_distance) {
            double half;
            for (double accu = half = (double)model.ties_distance * 0.5; accu < track.length; accu += (double)model.ties_distance) {
                last = track.getVectorPosition0(accu - 0.1, false);
                vec = track.getVectorPosition0(accu + 0.1, false);
                angle = -Math.atan2(last.x - vec.x, last.z - vec.z);
                vec = track.getVectorPosition0(accu, false);
                if (model.get("ties") == null) continue;
                for (Polyhedron hedron : model.get("ties")) {
                    for (Polygon poly : hedron.polygons) {
                        TexturedVertex[] verts = new TexturedVertex[poly.vertices.length];
                        for (int m = 0; m < verts.length; ++m) {
                            Vertex org = poly.vertices[m];
                            verts[m] = new TexturedVertex(VecUtil.rotByRad(angle, org.vector.x, org.vector.y, org.vector.z), org.u, org.v);
                            double dx = (double)verts[m].vector.x + vec.x - cen.x;
                            double dy = (double)verts[m].vector.y + vec.y - cen.y;
                            double dz = (double)verts[m].vector.z + vec.z - cen.z;
                            verts[m].vector = new Vec3f(dx, dy, dz);
                        }
                        tarp.hedrons[(int)accu].importMRT(new TexturedPolygon(verts), 1.0f);
                    }
                }
            }
        }
        track.restmodel = tarp;
    }

    public static void generateWireModel(Wire wire, WireModel model) {
        double dz;
        float len;
        V3D vec;
        double passed = 0.0;
        float obuf = 0.0f;
        float nbuf = 0.0f;
        float abuf = 0.0f;
        float arad = 0.0f;
        V3D cen = wire.vecpath[0];
        ArrayList<V3D> path = new ArrayList<V3D>();
        PathModelPositioned tarp = new PathModelPositioned(wire, RGB.WHITE);
        for (int p = 0; p < model.wire_model.size(); ++p) {
            path.clear();
            passed = 0.0;
            obuf = 0.0f;
            nbuf = 0.0f;
            abuf = 0.0f;
            arad = model.wire_ang.get(p).floatValue() * 0.0174533f;
            float u = model.wire_u.get(p).floatValue();
            float[] vv = model.wire_vv.get(p);
            vec = wire.getVectorPosition(0.001f, false);
            double angle = -Math.atan2(wire.vecpath[0].x - vec.x, wire.vecpath[0].z - vec.z);
            path.add(VecUtil.rotByRad(angle, model.wire_model.get(p)[0]));
            path.add(VecUtil.rotByRad(angle, model.wire_model.get(p)[1]));
            for (int v = 0; v < wire.vecpath.length - 1; ++v) {
                V3D last = wire.vecpath[v];
                vec = wire.vecpath[v + 1];
                angle = -Math.atan2(last.x - vec.x, last.z - vec.z);
                if ((abuf += arad * (float)last.dis(vec)) >= 3.14159f) {
                    abuf -= 6.28318f;
                }
                path.add(vec.add(VecUtil.rotate(model.wire_model.get(p)[0], 0.0, (double)abuf, angle)).sub(cen));
                path.add(vec.add(VecUtil.rotate(model.wire_model.get(p)[1], 0.0, (double)abuf, angle)).sub(cen));
            }
            for (int k = 0; k < wire.vecpath.length - 1; ++k) {
                if ((nbuf += (float)wire.vecpath[k].dis(wire.vecpath[k + 1])) > 1.0f) {
                    nbuf -= 1.0f;
                    obuf -= 1.0f;
                }
                TexturedVertex vert0 = new TexturedVertex((V3D)path.get(k * 2), obuf * u, vv[1]);
                TexturedVertex vert1 = new TexturedVertex((V3D)path.get(k * 2 + 1), obuf * u, vv[0]);
                TexturedVertex vert2 = new TexturedVertex((V3D)path.get((k + 1) * 2), nbuf * u, vv[1]);
                TexturedVertex vert3 = new TexturedVertex((V3D)path.get((k + 1) * 2 + 1), nbuf * u, vv[0]);
                TexturedPolygon poly0 = new TexturedPolygon(new TexturedVertex[]{vert1, vert0, vert2, vert3});
                int pess = (int)passed;
                if (pess >= tarp.hedrons.length) {
                    pess = tarp.hedrons.length - 1;
                }
                tarp.hedrons[pess].importMRT(poly0, 1.0f);
                passed += wire.vecpath[k].dis(wire.vecpath[k + 1]);
                obuf = nbuf;
            }
        }
        wire.wiremodel = tarp;
        vec = wire.vecpath[wire.vecpath.length - 1];
        wire.model_end_angle = Math.atan2(wire.vecpath[0].z - vec.z, wire.vecpath[0].x - vec.x);
        wire.model_end_angle = Static.toDegrees((double)wire.model_end_angle);
        wire.model_start_angle = wire.model_end_angle - 180.0;
        if (wire.deco_start != null) {
            wire.deco_s = FvtmRegistry.WIREDECOS.get(wire.deco_start);
        }
        if (wire.deco_end != null) {
            wire.deco_e = FvtmRegistry.WIREDECOS.get(wire.deco_end);
        }
        float hwl = wire.length / 2.0f;
        if (wire.deco_s != null) {
            len = PathModelGenerator.getLongestDownward(wire.deco_s.getModel());
            vec = wire.getVectorPosition(len > hwl ? (double)hwl : (double)len, false);
            double dx = wire.vecpath[0].x - vec.x;
            double dy = wire.vecpath[0].y - vec.y;
            dz = wire.vecpath[0].z - vec.z;
            wire.model_start_angle_down = (float)Math.atan2(dy, Math.sqrt(dx * dx + dz * dz));
            wire.model_start_angle_down = Static.toDegrees((double)wire.model_start_angle_down);
        }
        if (wire.deco_e != null) {
            len = PathModelGenerator.getLongestDownward(wire.deco_e.getModel());
            vec = wire.getVectorPosition(wire.length - (len > hwl ? hwl : len), false);
            double dx = wire.vecpath[wire.vecpath.length - 1].x - vec.x;
            double dy = wire.vecpath[wire.vecpath.length - 1].y - vec.y;
            dz = wire.vecpath[wire.vecpath.length - 1].z - vec.z;
            wire.model_end_angle_down = (float)Math.atan2(dy, Math.sqrt(dx * dx + dz * dz));
            wire.model_end_angle_down = Static.toDegrees((double)wire.model_end_angle_down);
        }
    }

    public static float getLongestDownward(WireModel model) {
        float l = 0.01f;
        for (ModelGroup list : model.groups) {
            for (Program program : list.getAllPrograms()) {
                WirePrograms.DownwardAngled prog;
                if (!(program instanceof WirePrograms.DownwardAngled) || !((prog = (WirePrograms.DownwardAngled)program).length() > l)) continue;
                l = prog.length();
            }
        }
        return l;
    }
}

