/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.uni.PathKey;
import net.fexcraft.mod.fvtm.sys.uni.RegionKey;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.uni.tag.TagCW;

public class RailRegion
extends SystemRegion<RailSystem, Junction> {
    public static final TreeMap<Long, TagCW> fillqueue = new TreeMap();
    public static final TreeMap<Long, TagCW> clientqueue = new TreeMap();
    protected ConcurrentHashMap<Long, RailEntity> entities = new ConcurrentHashMap();

    public RailRegion(RailSystem root, RegionKey rk) {
        super(root, rk);
    }

    public ConcurrentHashMap<Long, RailEntity> getEntities() {
        return this.entities;
    }

    public void spawnEntity(RailEntity ent) {
        try {
            FvtmLogger.debug((Object)("Spawning Entity " + ent.uid + "!"));
            this.entities.put(ent.getUID(), ent);
            if (((RailSystem)this.system).getWorld().isClient()) {
                return;
            }
            TagCW compound = ent.write(null);
            compound.set("XZ", this.key.toArray());
            Packets.sendToAllTrackingPos(Packets.PKT_TAG, ((RailSystem)this.system).getWorld(), ent.pos, "rail_spawn_ent", compound);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RailSystem getSystem() {
        return (RailSystem)this.system;
    }

    public Track getTrack(PathKey key) {
        Junction junction = (Junction)this.get(key.toPos(0));
        return junction == null ? null : junction.getTrack(key);
    }
}

