/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.Material;
import net.fexcraft.mod.fvtm.data.Seat;
import net.fexcraft.mod.fvtm.data.attribute.AttrFloat;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.attribute.AttributeUtil;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.root.Lockable;
import net.fexcraft.mod.fvtm.data.root.LoopedSound;
import net.fexcraft.mod.fvtm.data.root.Sound;
import net.fexcraft.mod.fvtm.data.vehicle.SimplePhysData;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleType;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.function.part.InventoryFunction;
import net.fexcraft.mod.fvtm.function.part.TireFunction;
import net.fexcraft.mod.fvtm.function.part.TransmissionFunction;
import net.fexcraft.mod.fvtm.handler.InteractionHandler;
import net.fexcraft.mod.fvtm.handler.TireInstallationHandler;
import net.fexcraft.mod.fvtm.handler.WheelInstallationHandler;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.packet.Packet_VehKeyPress;
import net.fexcraft.mod.fvtm.packet.Packet_VehKeyPressState;
import net.fexcraft.mod.fvtm.packet.Packet_VehMove;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.uni.FvtmWorld;
import net.fexcraft.mod.fvtm.sys.uni.KeyPress;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.UniWheel;
import net.fexcraft.mod.fvtm.sys.uni.WheelMap;
import net.fexcraft.mod.fvtm.sys.uni.WheelTireData;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.fvtm.util.MathUtils;
import net.fexcraft.mod.fvtm.util.Pivot;
import net.fexcraft.mod.fvtm.util.ess.SimplePhysSpawnSystem;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.MessageSender;

public class VehicleInstance {
    public VehicleData data;
    public VehicleType type;
    public EntityW entity;
    private UUID placer;
    public VehicleInstance front;
    public VehicleInstance rear;
    public SwivelPoint point;
    private InteractionHandler.InteractRef ref;
    public RenderCache cache;
    public double[] serv_pos = new double[3];
    public double[] serv_rot = new double[3];
    public double serv_steer;
    public byte serv_sync;
    public WheelTireData w_front_l;
    public WheelTireData w_front_r;
    public WheelTireData w_rear_l;
    public WheelTireData w_rear_r;
    public RailEntity railent;
    public SimplePhysData spdata;
    public WheelMap wheels = new WheelMap();
    public double steer_yaw;
    public double throttle;
    public double speed;
    public V3D pos;
    public V3D prev;
    public V3D move = new V3D();
    public double[] rot;
    public ArrayList<SeatInstance> seats = new ArrayList();
    public HashMap<String, WheelTireData> wheeldata = new HashMap();
    public byte toggable_timer;
    public double max_steering_yaw;
    public int fuel_accumulator;
    public int fuel_consumed;
    public HashMap<String, LoopedSound> activesounds = new LinkedHashMap<String, LoopedSound>();
    public boolean adv;
    public boolean braking;
    public boolean pbrake;
    public int gear_timer;
    public int autogear_timer;
    public EngineFunction engine;
    public TransmissionFunction transmission;
    public static final float GRAVITY = 9.81f;
    public static final float GRAVITY_20th = 0.49050003f;
    public static final float GRAVITY_200th = 0.049050003f;
    public static final int INTERACT_SUCCESS = 1;
    public static final int INTERACT_PASS = 0;
    public static final int INTERACT_FAIL = -1;
    public static final String PKT_UPD_VEHICLEDATA = "vehicledata";
    public static final String PKT_UPD_LIGHTS = "toggle_lights";
    public static final String PKT_UPD_LOCK = "lock_state";
    public static final String PKT_UPD_TOGGLE_ATTR = "toggle_attr";
    public static final String PKT_UPD_UPDATE_ATTR = "update_attr";
    public static final String PKT_UPD_CONNECTOR = "vehicle_front";
    public static final String PKT_UPD_START_SOUND = "start_sound";
    public static final String PKT_UPD_STOP_SOUND = "stop_sound";
    public static final String PKT_UPD_ENGINE_TOGGLE = "engine_toggle";
    public static final String PKT_UPD_ENTITY = "entity";

    public VehicleInstance(EntityW wrapper, VehicleData vdata, boolean base) {
        this.entity = wrapper;
        this.ref = new InteractionHandler.InteractRef(this);
        this.adv = base;
        this.init(vdata, null);
    }

    public VehicleInstance(EntityW wrapper, VehicleData vdata) {
        this(wrapper, vdata, false);
    }

    public UUID getPlacer() {
        return this.placer;
    }

    public void setPlacer(UUID uuid) {
        if (this.placer == null) {
            this.placer = uuid;
        }
    }

    public Pivot pivot() {
        return this.point.getPivot();
    }

    public Pivot prev_pivot() {
        return this.point.getPrevPivot();
    }

    public boolean onKeyPress(KeyPress key, Seat seat, Passenger player, boolean state, boolean sync) {
        if (!seat.driver && key.driver_only()) {
            return false;
        }
        if (this.entity.isOnClient() && !key.control() && !sync) {
            if (key.synced() && key.sync_state()) {
                Packets.send(Packet_VehKeyPressState.class, new Object[]{key, state, this.entity.getId(), player.getId()});
            } else {
                Packets.send(Packet_VehKeyPress.class, new Object[]{key});
                return true;
            }
        }
        switch (key) {
            case ACCELERATE: {
                if (this.adv) {
                    this.throttle += 0.01;
                    if (this.throttle > 1.0) {
                        this.throttle = 1.0;
                    }
                } else {
                    this.throttle += this.throttle < 0.0 ? 0.02 : 0.01;
                    if (this.throttle > 1.0) {
                        this.throttle = 1.0;
                    }
                }
                return true;
            }
            case DECELERATE: {
                if (this.adv) {
                    this.throttle -= this.braking ? (double)0.05f : (double)0.01f;
                    if (this.throttle < 0.0) {
                        this.throttle = 0.0;
                    }
                } else {
                    SimplePhysData spdata;
                    this.throttle -= this.throttle > 0.0 ? 0.02 : 0.01;
                    if (this.throttle < -1.0) {
                        this.throttle = -1.0;
                    }
                    if ((spdata = ((Vehicle)this.data.getType()).getSphData()) != null && this.throttle < 0.0 && spdata.min_throttle == 0.0f) {
                        this.throttle = 0.0;
                    }
                }
                return true;
            }
            case TURN_LEFT: {
                if (this.type.isRailVehicle()) {
                    if (this.throttle > (double)0.05f) {
                        player.bar("fvtm.rail.decrease_throttle");
                    } else {
                        this.railent.setForward(player, false);
                    }
                    return true;
                }
                this.steer_yaw -= 5.0;
                return true;
            }
            case TURN_RIGHT: {
                if (this.type.isRailVehicle()) {
                    if (this.throttle > (double)0.05f) {
                        player.bar("fvtm.rail.decrease_throttle");
                    } else {
                        this.railent.setForward(player, true);
                    }
                    return true;
                }
                this.steer_yaw += 5.0;
                return true;
            }
            case BRAKE: {
                if (this.adv) {
                    this.braking = state;
                } else {
                    this.throttle *= 0.8;
                    this.entity.decreaseXZMotion(0.8);
                    if (this.throttle < -1.0E-4) {
                        this.throttle = 0.0;
                    }
                }
                return true;
            }
            case PBRAKE: {
                if (this.toggable_timer > 0) {
                    return true;
                }
                this.pbrake = !this.pbrake;
                this.toggable_timer = (byte)(this.toggable_timer + 10);
                return true;
            }
            case ENGINE: {
                this.toggleEngine();
                return true;
            }
            case DISMOUNT: {
                player.dismount();
                return true;
            }
            case INVENTORY: {
                player.openUI(UIKeys.VEHICLE_MAIN, new V3I(this.entity.getId(), 0, 0));
                return true;
            }
            case SCRIPTS: {
                return true;
            }
            case LIGHTS: {
                if (this.toggable_timer > 0) {
                    return true;
                }
                if (this.data.getAttribute("lights").asBoolean()) {
                    if (this.type.isRailVehicle()) {
                        this.data.getAttribute("lights").set(false);
                    } else if (this.data.getAttribute("lights_long").asBoolean()) {
                        this.data.getAttribute("lights").set(false);
                        this.data.getAttribute("lights_long").set(false);
                    } else {
                        this.data.getAttribute("lights_long").set(true);
                    }
                } else {
                    this.data.getAttribute("lights").set(true);
                }
                this.sendUpdate(PKT_UPD_LIGHTS);
                if (this.type.isRailVehicle()) {
                    if (this.railent.getCompound().isMultiple()) {
                        boolean bool = this.data.getAttributeBoolean("lights", false);
                        for (RailEntity ent : this.railent.getCompound().getEntitites()) {
                            ent.vehicle.data.getAttribute("lights").set(bool);
                            ent.vehicle.sendUpdate(PKT_UPD_LIGHTS);
                        }
                    }
                } else {
                    VehicleInstance trailer = this.rear;
                    while (trailer != null) {
                        trailer.data.getAttribute("lights").set(this.data.getAttribute("lights").asBoolean());
                        trailer.data.getAttribute("lights_long").set(this.data.getAttribute("lights_long").asBoolean());
                        trailer.sendUpdate(PKT_UPD_LIGHTS);
                        trailer = trailer.rear;
                    }
                }
                this.toggable_timer = (byte)10;
                return true;
            }
            case COUPLER_REAR: {
                if (this.toggable_timer > 0) {
                    return true;
                }
                if (this.type.isRailVehicle()) {
                    this.railent.tryCoupling(player, false);
                    this.toggable_timer = (byte)10;
                    return true;
                }
                return true;
            }
            case COUPLER_FRONT: {
                if (this.toggable_timer > 0) {
                    return true;
                }
                if (this.type.isRailVehicle()) {
                    this.railent.tryCoupling(player, true);
                    this.toggable_timer = (byte)10;
                    return true;
                }
                return true;
            }
            case GEAR_UP: {
                if (this.gear_timer <= 0) {
                    if (this.transmission == null) {
                        return true;
                    }
                    int gear = this.data.getAttributeInteger("gear", 0);
                    if (this.transmission.isAutomatic()) {
                        if (gear < 0) {
                            this.data.getAttribute("gear").set(0);
                            this.updateAttr("gear");
                        } else if (gear == 0) {
                            this.data.getAttribute("gear").set(1);
                            this.updateAttr("gear");
                        }
                        this.autogear_timer += this.transmission.getShiftSpeed();
                    } else if (gear + 1 <= this.transmission.getFGearAmount()) {
                        this.data.getAttribute("gear").set(gear + 1);
                        this.updateAttr("gear");
                    }
                    this.gear_timer += 10;
                }
                return true;
            }
            case GEAR_DOWN: {
                if (this.gear_timer <= 0) {
                    if (this.transmission == null) {
                        return true;
                    }
                    int gear = this.data.getAttributeInteger("gear", 0);
                    if (this.transmission.isAutomatic()) {
                        if (gear > 0) {
                            this.data.getAttribute("gear").set(0);
                            this.updateAttr("gear");
                        } else if (gear == 0) {
                            this.data.getAttribute("gear").set(-1);
                            this.updateAttr("gear");
                        }
                        this.autogear_timer += this.transmission.getShiftSpeed();
                    } else if (gear - 1 >= -this.transmission.getRGearAmount()) {
                        this.data.getAttribute("gear").set(gear - 1);
                        this.updateAttr("gear");
                    }
                    this.gear_timer += 10;
                }
                return true;
            }
        }
        player.bar("Action '" + String.valueOf((Object)key) + "' not found.");
        return false;
    }

    public void toggleEngine() {
        if (this.toggable_timer > 0) {
            return;
        }
        TagCW com = TagCW.create();
        com.set("cargo", PKT_UPD_ENGINE_TOGGLE);
        this.toggable_timer = (byte)(this.toggable_timer + 10);
        this.engine = (EngineFunction)this.data.getPart("engine").getFunction("fvtm:engine");
        if (this.entity.isOnClient()) {
            this.engine.setState(com.getBoolean("engine_toggle_result"));
        } else {
            com.set("engine_toggle_result", this.engine.toggle());
        }
        if (this.data.getStoredFuel() == 0) {
            com.set("engine_toggle_result", this.engine.setState(false));
            com.set("no_fuel", true);
        }
        Packets.INSTANCE.send(this, com);
        this.throttle = 0.0;
    }

    public void updateAttr(String attrid) {
        Attribute<?> attr = this.data.getAttribute(attrid);
        if (attr == null) {
            return;
        }
        TagCW com = TagCW.create();
        com.set("cargo", PKT_UPD_UPDATE_ATTR);
        com.set("id", attrid);
        attr.save(com);
        Packets.INSTANCE.send(this, com);
    }

    public boolean getKeyPressState(KeyPress key) {
        if (key == KeyPress.BRAKE) {
            return this.braking;
        }
        return false;
    }

    public boolean consumeFuel() {
        if (this.data.outoffuel()) {
            return false;
        }
        if (this.engine.isOn()) {
            this.fuel_consumed = this.throttle == 0.0 || this.throttle < 0.05 && this.throttle > -0.05 ? (this.fuel_consumed += this.engine.getIdleFuelConsumption()) : (int)((double)this.fuel_consumed + (double)this.engine.getFuelConsumption(this.data.getAttribute("fuel_secondary").asString()) * this.throttle);
        }
        ++this.fuel_accumulator;
        if (this.fuel_accumulator < 20) {
            return this.engine.isOn();
        }
        boolean cons = false;
        if (this.fuel_consumed > 0) {
            int consumed = (int)((float)this.fuel_consumed / 20.0f);
            this.data.getAttribute("fuel_stored").decrease(consumed < 0 ? 1.0f : (float)consumed);
            cons = true;
        }
        if (this.engine.isOn() && this.data.outoffuel()) {
            this.throttle = 0.0;
            this.engine.setState(false);
        }
        this.fuel_accumulator = 0;
        this.fuel_consumed = 0;
        return cons;
    }

    public V3D getV3D() {
        return this.entity.getPos();
    }

    public void updatePointsSeats() {
        for (SwivelPoint point : this.data.getRotationPoints().values()) {
            point.update(this);
        }
        for (SeatInstance seat : this.seats) {
            seat.update();
        }
    }

    public void sendUpdatePacket() {
        this.data.getAttribute("throttle").set(this.throttle);
        Packets.sendToAllTrackingEnt(Packet_VehMove.class, this.entity, this.entity, this);
        for (SwivelPoint point : this.data.getRotationPoints().values()) {
            point.sendUpdatePacket(this.entity);
        }
    }

    public SeatInstance getSeatOf(Object passenger) {
        for (SeatInstance seat : this.seats) {
            if (seat.passenger_direct() != passenger) continue;
            return seat;
        }
        return null;
    }

    public SeatInstance getSeatOf(Passenger passenger) {
        return this.getSeatOf(passenger.direct());
    }

    public void packet(TagCW packet, Passenger passenger) {
        String cargo;
        switch (cargo = packet.getString("cargo")) {
            case "lock_state": {
                this.data.getLock().setLocked(packet.getBoolean("state"));
                return;
            }
            case "toggle_lights": {
                this.data.getAttribute("lights").set(packet.getBoolean("lights"));
                this.data.getAttribute("lights_long").set(packet.getBoolean("lights_long"));
                return;
            }
            case "toggle_attr": {
                if (passenger.isOnClient()) {
                    AttributeUtil.processToggleClient(this, packet, passenger);
                }
                return;
            }
            case "vehicledata": {
                this.data.read(packet);
                return;
            }
            case "engine_toggle": {
                if (passenger.getSeatOn() != null && passenger.getSeatOn().root == this) {
                    boolean state = packet.getBoolean("engine_toggle_result");
                    if (this.engine.setState(state)) {
                        passenger.send("interact.fvtm.vehicle.engine_toggled_on");
                    } else {
                        passenger.send("interact.fvtm.vehicle.engine_toggled_off");
                    }
                    if (packet.has("no_fuel") && packet.getBoolean("no_fuel")) {
                        passenger.send("interact.fvtm.vehicle.engine_no_fuel");
                    }
                }
                this.throttle = 0.0;
                Sound sound = this.data.getSound("engine_running");
                if (sound != null && sound.event != null) {
                    if (this.data.getPart("engine").getFunction(EngineFunction.class, "fvtm:engine").isOn()) {
                        if (!this.isSoundActive("engine_running")) {
                            this.startSound("engine_running");
                        }
                    } else {
                        this.stopSound("engine_running");
                    }
                }
                return;
            }
            case "vehicle_front": {
                VehicleInstance veh;
                int id = packet.getInteger("vehid");
                if (id < 0) {
                    if (this.front != null) {
                        this.front.rear = null;
                    }
                    this.front = null;
                }
                if ((veh = ((FvtmWorld)this.entity.getWorld()).getVehicle(id)) != null) {
                    veh.rear = this;
                    this.front = veh;
                }
                return;
            }
            case "start_sound": {
                if (passenger.isOnClient()) {
                    this.startSound(packet.getString("sound"));
                }
                return;
            }
            case "stop_sound": {
                if (passenger.isOnClient()) {
                    this.stopSound(packet.getString("sound"));
                }
                return;
            }
            case "entity": {
                if (this.entity != null) {
                    this.entity.onPacket((EntityW)passenger, packet);
                }
                return;
            }
            case "update_attr": {
                Attribute<?> attr = this.data.getAttribute(packet.getString("id"));
                if (attr != null) {
                    attr.load(packet);
                }
                return;
            }
        }
        FvtmLogger.log((Object)("'" + this.data.getName() + "'/" + this.entity.getId() + " received invalid packet: " + packet.toString()));
    }

    public boolean isBraking() {
        return this.braking;
    }

    public void assignWheels() {
        this.w_rear_l = this.w_rear_r = new WheelTireData();
        this.w_front_r = this.w_rear_r;
        this.w_front_l = this.w_rear_r;
        for (WheelTireData wheel : this.wheeldata.values()) {
            if (!((Vehicle)this.data.getType()).isTrailer()) {
                if (wheel.pos.x <= this.w_front_l.pos.x && wheel.pos.z <= this.w_front_l.pos.z) {
                    this.w_front_l = wheel;
                    continue;
                }
                if (wheel.pos.x >= this.w_front_r.pos.x && wheel.pos.z <= this.w_front_r.pos.z) {
                    this.w_front_r = wheel;
                    continue;
                }
            }
            if (wheel.pos.x <= this.w_rear_l.pos.x && wheel.pos.z >= this.w_rear_l.pos.z) {
                this.w_rear_l = wheel;
                continue;
            }
            if (!(wheel.pos.x >= this.w_rear_r.pos.x) || !(wheel.pos.z >= this.w_rear_r.pos.z)) continue;
            this.w_rear_r = wheel;
        }
        if (((Vehicle)this.data.getType()).isTrailer()) {
            this.w_front_l = new WheelTireData("_" + this.w_rear_l.id);
            this.w_front_l.asTrailerFront(this.w_rear_l);
            this.wheeldata.put(this.w_front_l.id, this.w_front_l);
            this.w_front_r = new WheelTireData("_" + this.w_rear_r.id);
            this.w_front_r.asTrailerFront(this.w_rear_r);
            this.wheeldata.put(this.w_front_r.id, this.w_front_r);
        }
    }

    public void sendUpdate(String type) {
        this.sendUpdate(type, null);
    }

    public void sendUpdate(String type, TagCW com) {
        if (this.entity == null) {
            return;
        }
        if (com == null) {
            com = TagCW.create();
        }
        com.set("cargo", type);
        switch (type) {
            case "vehicledata": {
                this.data.write(com);
                break;
            }
            case "lock_state": {
                com.set("state", this.data.getLock().isLocked());
                break;
            }
            case "toggle_lights": {
                com.set("lights", this.data.getAttribute("lights").asBoolean());
                com.set("lights_long", this.data.getAttribute("lights_long").asBoolean());
                break;
            }
            case "toggle_attr": {
                break;
            }
            case "vehicle_front": {
                com.set("vehid", this.front == null ? -1 : this.front.entity.getId());
            }
        }
        Packets.INSTANCE.send(this, com);
    }

    public InteractionHandler.InteractRef iref() {
        this.ref.update();
        return this.ref;
    }

    private boolean isSoundActive(String key) {
        return this.activesounds.containsKey(key) && this.activesounds.get((Object)key).active;
    }

    public void startSound(String key) {
        if (!this.entity.isOnClient()) {
            TagCW com = TagCW.create();
            com.set("sound", key);
            this.sendUpdate(PKT_UPD_START_SOUND, com);
            return;
        }
        if (!this.activesounds.containsKey(key)) {
            this.activesounds.put(key, new LoopedSound(this, this.data.getSound(key)));
        }
        this.activesounds.get(key).start();
    }

    public void stopSound(String key) {
        if (!this.entity.isOnClient()) {
            TagCW com = TagCW.create();
            com.set("sound", key);
            this.sendUpdate(PKT_UPD_STOP_SOUND, com);
            return;
        }
        if (this.activesounds.containsKey(key)) {
            this.activesounds.get(key).stop();
        }
    }

    public EntityW driver() {
        for (SeatInstance seat : this.seats) {
            if (!seat.seat.driver || !seat.passengerIsPlayer()) continue;
            return seat.passenger();
        }
        return null;
    }

    public void onVehMovePkt(Packet_VehMove packet) {
        this.serv_pos = packet.pos;
        this.serv_rot = packet.rot;
        this.serv_steer = packet.steering;
        this.throttle = packet.throttle;
        if (this.data != null) {
            this.data.getAttribute("fuel_stored").set(packet.fuel);
        }
        this.serv_sync = Config.VEHICLE_SYNC_RATE;
    }

    public void init(VehicleData vdata, TagCW com) {
        if (vdata != null) {
            this.data = vdata;
        }
        if (com != null) {
            if (this.data == null) {
                this.data = FvtmResources.getVehicleData(com);
            } else {
                this.data.read(com);
            }
        }
        if (this.data == null) {
            return;
        }
        this.type = ((Vehicle)this.data.getType()).getVehicleType();
        this.point = this.data.getRotationPoint(null);
        if (com != null) {
            this.point.loadPivot(com);
        }
        this.max_steering_yaw = this.data.getAttributeInteger("max_steering_angle", 45);
        this.engine = (EngineFunction)this.data.getFunctionInPart("engine", "fvtm:engine");
        if (this.adv) {
            this.transmission = (TransmissionFunction)this.data.getFunctionInPart("transmission", "fvtm:transmission");
        }
        this.spdata = ((Vehicle)this.data.getType()).getSphData();
        this.initWheels();
        this.seats.clear();
        for (int i = 0; i < this.data.getSeats().size(); ++i) {
            this.seats.add(new SeatInstance(this, i));
        }
        if (!this.entity.isOnClient() && this.front != null) {
            this.sendUpdate(PKT_UPD_CONNECTOR);
        }
    }

    public void initWheels() {
        this.wheels.clear();
        if (!this.type.isRailVehicle()) {
            for (Map.Entry<String, V3D> entry : this.data.getWheelPositions().entrySet()) {
                if (entry.getKey().endsWith(":tire")) continue;
                WheelTireData wheel = new WheelTireData(entry.getKey());
                wheel.pos = entry.getValue();
                PartData part = this.data.getPart(entry.getKey());
                if (!((WheelInstallationHandler.WheelData)((Part)part.getType()).getInstallHandlerData()).hasTire()) {
                    part = this.data.getPart(entry.getKey() + ":tire");
                    wheel.radius = ((TireInstallationHandler.TireData)((Part)part.getType()).getInstallHandlerData()).getOuterRadius();
                } else {
                    wheel.radius += ((WheelInstallationHandler.WheelData)((Part)part.getType()).getInstallHandlerData()).getRadius();
                }
                wheel.function = part.getFunction(TireFunction.class, "fvtm:tire").getTireAttr(part);
                wheel.steering = this.data.getWheelSlots().get((Object)entry.getKey()).steering;
                wheel.mirror = this.data.getWheelSlots().get((Object)entry.getKey()).mirror;
                this.wheeldata.put(entry.getKey(), wheel);
            }
            this.assignWheels();
        }
    }

    public void onRemove() {
        if (Config.VEHICLES_DROP_CONTENTS && !this.entity.isOnClient()) {
            for (String part : this.data.getInventories()) {
                InventoryFunction func = (InventoryFunction)this.data.getPart(part).getFunction("fvtm:inventory");
                if (func == null) continue;
                func.inventory().clearAt(this.entity);
            }
        }
        for (UniWheel wheel : this.wheels.values()) {
            wheel.remove();
        }
        if (!this.type.isRailVehicle()) {
            if (this.front != null) {
                this.front.rear = null;
            }
            if (this.rear != null) {
                this.rear.front = null;
            }
        }
    }

    public int onInteract(Passenger player, StackWrapper stack) {
        if (this.entity.isOnClient()) {
            if (!stack.empty() && stack.isItemOf(ContentType.PART.item_type)) {
                return 1;
            }
            if (Lockable.isKey(stack.getItem())) {
                return 1;
            }
            if (this.data.getLock().isLocked()) {
                player.bar("interact.fvtm.vehicle.locked");
                return 1;
            }
            InteractionHandler.handle(KeyPress.MOUSE_RIGHT, this.data, this.iref(), null, player, stack);
            return 1;
        }
        if (Lockable.isKey(stack.getItem()) && !Material.isFuelContainer(stack)) {
            this.data.getLock().toggle((MessageSender)player, stack);
            this.sendUpdate(PKT_UPD_LOCK);
        }
        if (!stack.empty()) {
            if (Material.isFuelContainer(stack)) {
                player.openUI(UIKeys.VEHICLE_FUEL, this.entity.getId(), 0, 0);
            } else {
                if (stack.isItemOf(ContentType.TOOLBOX.item_type)) {
                    int type = (Integer)stack.getContent(ContentType.TOOLBOX.item_type);
                    switch (type) {
                        case 1: {
                            player.openUI(UIKeys.TOOLBOX_TEXTURE, this.entity.getId(), 0, 0);
                            break;
                        }
                        case 2: {
                            player.openUI(UIKeys.TOOLBOX_COLORS, this.entity.getId(), 0, 0);
                            break;
                        }
                    }
                    return 1;
                }
                if (stack.isItemOf(ContentType.VEHICLE.item_type) && this.type.isLandVehicle()) {
                    VehicleData tdat = (VehicleData)stack.getContent(ContentType.VEHICLE.item_type);
                    if (((Vehicle)tdat.getType()).isTrailer()) {
                        if (!this.data.hasCompatibleConnector(((Vehicle)tdat.getType()).getCategories())) {
                            player.send("interact.fvtm.vehicle.no_compatible_connector");
                            FvtmLogger.debug(this.data.getConnectors());
                            return 1;
                        }
                        if (!SimplePhysSpawnSystem.validToSpawn((MessageSender)player, stack, tdat)) {
                            return 1;
                        }
                        if (this.rear != null) {
                            player.send("interact.fvtm.vehicle.disconnect_trailer");
                            return 1;
                        }
                        ((FvtmWorld)this.entity.getWorld()).spawnLandEntity(tdat, this, (EntityW)player);
                    }
                    return 1;
                }
                if (stack.isItemOf(ContentType.CONTAINER.item_type)) {
                    return 1;
                }
                if (this.engine != null && this.engine.isOn()) {
                    player.send("interact.fvtm.vehicle.engine_on");
                } else {
                    player.openUI(UIKeys.VEHICLE_MAIN, 0, this.entity.getId(), 0);
                }
                return 1;
            }
        }
        if (this.data.getLock().isLocked()) {
            player.bar("interact.fvtm.vehicle.locked");
        }
        return 0;
    }

    public void onUpdate() {
        boolean remote = this.entity.isOnClient();
        if (!remote) {
            this.checkWheelPresence(this.w_front_l.id);
            this.checkWheelPresence(this.w_front_r.id);
            this.checkWheelPresence(this.w_rear_l.id);
            this.checkWheelPresence(this.w_rear_r.id);
        }
        this.point.updatePrevAxe();
        if (this.toggable_timer > 0) {
            this.toggable_timer = (byte)(this.toggable_timer - 1);
        }
        if (this.gear_timer > 0) {
            --this.gear_timer;
        }
        if (this.autogear_timer > 0) {
            --this.autogear_timer;
        }
        if (!remote) {
            this.steer_yaw *= (double)Config.STEER_RESET_RATE;
        }
        if (this.steer_yaw > this.max_steering_yaw) {
            this.steer_yaw = this.max_steering_yaw;
        }
        if (this.steer_yaw < -this.max_steering_yaw) {
            this.steer_yaw = -this.max_steering_yaw;
        }
        this.pos = this.entity.getPos();
        this.rot = this.point.getPivot().toArray();
        if (remote) {
            if (this.serv_sync > 0) {
                this.pos.x += (this.serv_pos[0] - this.pos.x) / (double)this.serv_sync;
                this.pos.y += (this.serv_pos[1] - this.pos.y) / (double)this.serv_sync;
                this.pos.z += (this.serv_pos[2] - this.pos.z) / (double)this.serv_sync;
                this.rot[0] = MathUtils.valDeg(this.rot[0] + (this.serv_rot[0] - this.rot[0]) / (double)this.serv_sync);
                this.rot[1] = MathUtils.valDeg(this.rot[1] + (this.serv_rot[1] - this.rot[1]) / (double)this.serv_sync);
                this.rot[2] = MathUtils.valDeg(this.rot[2] + (this.serv_rot[2] - this.rot[2]) / (double)this.serv_sync);
                this.steer_yaw += (this.serv_steer - this.steer_yaw) / (double)this.serv_sync;
                this.serv_sync = (byte)(this.serv_sync - 1);
                this.entity.setPos(this.pos);
                this.pivot().set_rotation(this.rot[0], this.rot[1], this.rot[2], true);
            }
            this.prev = this.entity.getPrevPos();
            if (this.type.isRailVehicle()) {
                if (this.railent.current == null) {
                    return;
                }
                V3D bf0 = this.railent.moveOnly((float)(this.railent.passed + 0.1));
                V3D bf1 = this.railent.moveOnly((float)(this.railent.passed - 0.1));
                V3D br0 = this.railent.moveOnly((float)(this.railent.passed - this.railent.frbogiedis - this.railent.rrbogiedis + 0.1));
                V3D br1 = this.railent.moveOnly((float)(this.railent.passed - this.railent.frbogiedis - this.railent.rrbogiedis - 0.1));
                if (bf0 != null && br0 != null && bf1 != null && br1 != null) {
                    float front = (float)(Math.toDegrees(Math.atan2(bf0.z - bf1.z, bf0.x - bf1.x)) - (double)this.point.getPivot().deg_yaw());
                    float rear = (float)(Math.toDegrees(Math.atan2(br0.z - br1.z, br0.x - br1.x)) - (double)this.point.getPivot().deg_yaw());
                    this.data.getAttribute("bogie_front_angle").set(Float.valueOf(front));
                    this.data.getAttribute("bogie_rear_angle").set(Float.valueOf(rear));
                }
            } else {
                AttrFloat attr = (AttrFloat)this.data.getAttribute("steering_angle");
                attr.initial = attr.value;
                attr.value = Float.valueOf((float)this.steer_yaw);
                double dir = (double)Math.abs(this.pivot().yaw() + 3.14159f) - Math.abs(-Math.atan2(this.prev.x - this.pos.x, this.prev.z - this.pos.z) + (double)3.14159f);
                dir = dir > (double)1.5708f || dir < (double)-1.5708f ? -1.0 : 1.0;
                for (WheelTireData val : this.wheeldata.values()) {
                    val.rotation = MathUtils.valDegF((double)val.rotation + this.speed * dir * (double)val.radius * 100.0);
                }
                this.data.setAttribute("throttle", this.throttle);
                this.data.setAttribute("speed", this.speed);
            }
        }
        for (UniWheel wheel : this.wheels.values()) {
            if (wheel == null) continue;
            wheel.updatePrevPos();
        }
        this.onUpdateMovement(remote);
        this.updatePointsSeats();
    }

    private void checkWheelPresence(String id) {
        if (!this.wheels.containsKey(id) || !((UniWheel)this.wheels.get(id)).isAdded()) {
            this.wheels.put(id, ((FvtmWorld)this.entity.getWorld()).spawnWheel(this, id));
        }
    }

    private void onUpdateMovement(boolean remote) {
        boolean creative;
        EntityW driver = this.driver();
        boolean bl = creative = driver != null && driver.isCreative();
        if (!remote) {
            V3D lef;
            V3D rig;
            V3D rea;
            V3D fro;
            if (this.type.isRailVehicle()) {
                this.data.getAttribute("section_on").set(this.railent.current.getUnit().section().getUID());
                this.railent.alignEntity(false);
                fro = this.railent.bfront;
                rea = this.railent.brear;
                lef = rig = new V3D((fro.x + rea.x) * 0.5, (fro.y + rea.y) * 0.5, (fro.z + rea.z) * 0.5);
            } else {
                if (driver == null || !creative && this.data.outoffuel()) {
                    this.throttle *= 0.98;
                }
                this.move(!Config.VEHICLES_NEED_FUEL || creative);
                if (this.rear != null) {
                    this.rear.align();
                }
                V3D fl = ((UniWheel)this.wheels.get(this.w_front_l.id)).pos();
                V3D fr = ((UniWheel)this.wheels.get(this.w_front_r.id)).pos();
                V3D rl = ((UniWheel)this.wheels.get(this.w_rear_l.id)).pos();
                V3D rr = ((UniWheel)this.wheels.get(this.w_rear_r.id)).pos();
                if (fl == null) {
                    return;
                }
                fro = new V3D((fl.x + fr.x) * 0.5, (fl.y + fr.y) * 0.5, (fl.z + fr.z) * 0.5);
                rea = new V3D((rl.x + rr.x) * 0.5, (rl.y + rr.y) * 0.5, (rl.z + rr.z) * 0.5);
                lef = new V3D((fl.x + rl.x) * 0.5, (fl.y + rl.y) * 0.5, (fl.z + rl.z) * 0.5);
                rig = new V3D((fr.x + rr.x) * 0.5, (fr.y + rr.y) * 0.5, (fr.z + rr.z) * 0.5);
            }
            double dx = rea.x - fro.x;
            double dy = rea.y - fro.y;
            double dz = rea.z - fro.z;
            double drx = rig.x - lef.x;
            double dry = rig.y - lef.y;
            double drz = rig.z - lef.z;
            double dxz = Math.sqrt(dx * dx + dz * dz);
            double y = -Math.atan2(dx, dz);
            double p = -Math.atan2(dy, dxz);
            double r = Math.atan2(dry, Math.sqrt(drx * drx + drz * drz));
            this.pivot().set_rotation(y, p, r, false);
        } else {
            this.speed = MathUtils.calcSpeed(this.pos.x, this.pos.y, this.pos.z, this.prev.x, this.prev.y, this.prev.z);
        }
    }

    private void move(boolean nocons) {
        if (((Vehicle)this.data.getType()).isTrailer()) {
            return;
        }
        this.entity.setOnGround(true);
        this.move.z = 0.0;
        this.move.y = 0.0;
        this.move.x = 0.0;
        if (!this.type.isWaterVehicle()) {
            double steer = Math.toRadians(this.steer_yaw);
            double wyaw = MathUtils.valRad(this.pivot().yaw());
            double syaw = MathUtils.valRad(wyaw + steer);
            double myaw = 0.0;
            double ryaw = 0.0;
            double scal = 0.0;
            boolean cons = nocons || this.engine != null && this.consumeFuel();
            for (UniWheel wheel : this.wheels.values()) {
                if (wheel.wtd() == null) continue;
                wheel.prepare();
                if (this.engine != null && cons) {
                    if (!((Vehicle)this.data.getType()).isTracked()) {
                        scal = 0.05 * this.throttle * (double)(this.throttle > 0.0 ? this.spdata.max_throttle : this.spdata.min_throttle) * (double)this.engine.getSphEngineSpeed();
                        ryaw = this.pivot().deg_yaw();
                        myaw = wyaw;
                        if (wheel.wtd().steering) {
                            ryaw += this.steer_yaw;
                            myaw = syaw;
                        }
                    }
                    wheel.addMotion(-Math.sin(-myaw) * scal, 0.0, -Math.cos(-myaw) * scal);
                }
                wheel.yaw((float)ryaw);
                wheel.move();
                this.moveToWheel(wheel);
            }
        }
        this.moveFinish();
    }

    private void moveFinish() {
        this.move.x += this.pos.x;
        this.move.y += this.pos.y;
        this.move.z += this.pos.z;
        this.entity.setPos(this.move);
        this.speed = Math.sqrt(this.move.x * this.move.x + this.move.z * this.move.z);
    }

    private void moveToWheel(UniWheel wheel) {
        V3D dest = this.pivot().get_vector(wheel.wtd().pos);
        dest.x = (dest.x - (wheel.pos().x - this.pos.x)) * 0.25;
        dest.y = (dest.y - (wheel.pos().y - this.pos.y)) * 0.25;
        dest.z = (dest.z - (wheel.pos().z - this.pos.z)) * 0.25;
        if (dest.length() > 0.001) {
            V3D.sub((V3D)dest, (V3D)this.move);
        }
    }

    private void align() {
        this.entity.setPrevPos(this.entity.getPos());
        if (this.wheels.isEmpty() || this.front == null) {
            return;
        }
        V3D conn = this.front.pivot().get_vector(this.front.data.getConnectorFor(((Vehicle)this.data.getType()).getCategories()));
        V3D.add((V3D)this.front.getV3D(), (V3D)conn);
        this.entity.setPos(conn);
        this.throttle = this.front.throttle;
        V3D wl = ((UniWheel)this.wheels.get(this.w_rear_l.id)).pos();
        V3D wr = ((UniWheel)this.wheels.get(this.w_rear_r.id)).pos();
        this.pivot().set_rotation(-Math.atan2((wl.x + wr.x) * 0.5 - conn.x, (wl.z + wr.z) * 0.5 - conn.z), (double)this.pivot().pitch(), (double)this.pivot().roll(), false);
        this.move.z = 0.0;
        this.move.y = 0.0;
        this.move.x = 0.0;
        this.pos = this.entity.getPos();
        for (UniWheel wheel : this.wheels.values()) {
            wheel.prepare();
            wheel.yaw(this.pivot().deg_yaw());
            V3D dest = this.pivot().get_vector(wheel.wtd().pos);
            dest.x = (dest.x - (wheel.pos().x - this.pos.x)) * 0.5;
            dest.y = (dest.y - (wheel.pos().y - this.pos.y)) * 0.5;
            dest.z = (dest.z - (wheel.pos().z - this.pos.z)) * 0.5;
            wheel.addMotion(dest.x, dest.y, dest.z);
            wheel.move();
            this.moveToWheel(wheel);
        }
        this.moveFinish();
        if (this.rear != null) {
            this.rear.align();
        }
    }
}

