/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.wire;

import java.util.LinkedHashMap;
import java.util.Map;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.FvtmBlockEntity;
import net.fexcraft.mod.fvtm.data.block.RelayData;
import net.fexcraft.mod.fvtm.sys.uni.SysObj;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;

public class RelayHolder
implements SysObj {
    public LinkedHashMap<String, WireRelay> relays = new LinkedHashMap();
    private final SystemRegion<WireSystem, RelayHolder> region;
    protected Block blockref;
    protected Object blocktile;
    public V3I pos;

    public RelayHolder(SystemRegion<WireSystem, RelayHolder> region, V3I pos) {
        this(region);
        this.pos = pos;
    }

    public RelayHolder(SystemRegion<WireSystem, RelayHolder> region) {
        this.region = region;
    }

    public WireRelay add(String key, V3D vec, boolean override) {
        if (this.relays.containsKey(key)) {
            if (override) {
                this.remove(key);
            } else {
                return this.get(key);
            }
        }
        WireRelay relay = new WireRelay(this, key, vec);
        this.relays.put(key, relay);
        return relay;
    }

    public WireRelay get(String key) {
        return this.relays.get(key);
    }

    public WireRelay remove(String relkey) {
        return (WireRelay)this.relays.remove(relkey);
    }

    public boolean contains(String key) {
        return this.relays.containsKey(key);
    }

    public void setTile(Object tile) {
        this.blocktile = tile;
    }

    public <TE> TE getTile() {
        return (TE)this.blocktile;
    }

    @Override
    public void delete() {
        for (WireRelay relay : this.relays.values()) {
            while (relay.wires.size() > 0) {
                relay.remove(0, true);
            }
        }
        this.relays.clear();
    }

    @Override
    public TagCW write() {
        TagCW compound = TagCW.create();
        compound.set("Pos", this.pos, false);
        TagLW list = TagLW.create();
        for (Map.Entry<String, WireRelay> relay : this.relays.entrySet()) {
            TagCW com = relay.getValue().write(null);
            com.set("Key", relay.getKey());
            list.add(com);
        }
        compound.set("Relays", list);
        if (this.blockref != null) {
            compound.set("Block", this.blockref.getIDS());
        }
        return compound;
    }

    @Override
    public void read(TagCW compound) {
        this.pos = compound.getV3I("Pos");
        TagLW list = compound.getList("Relays");
        for (TagCW tag : list) {
            WireRelay relay = new WireRelay(this).read(tag);
            this.relays.put(tag.getString("Key"), relay);
        }
        if (compound.has("Block")) {
            this.blockref = FvtmRegistry.BLOCKS.get(compound.getString("Block"));
        }
    }

    @Override
    public void update() {
    }

    public WireRelay get(int index) {
        int idx = 0;
        for (WireRelay relay : this.relays.values()) {
            if (idx == index) {
                return relay;
            }
            ++idx;
        }
        return null;
    }

    public SystemRegion<WireSystem, RelayHolder> getRegion() {
        return this.region;
    }

    public void integrate(FvtmBlockEntity tile) {
        this.blockref = (Block)tile.getBlockData().getType();
        for (Map.Entry<String, V3D> entry : this.blockref.getRelayData().getVectors(tile).entrySet()) {
            this.add(entry.getKey(), entry.getValue(), false);
        }
    }

    public boolean hasRef() {
        return this.blockref != null && this.blockref.getRelayData() != null;
    }

    public RelayData ref() {
        return this.blockref.getRelayData();
    }
}

