/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import java.util.ArrayList;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.Cloth;
import net.fexcraft.mod.fvtm.data.Consumable;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.Decoration;
import net.fexcraft.mod.fvtm.data.Fuel;
import net.fexcraft.mod.fvtm.data.Material;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.data.Recipe;
import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.WireDeco;
import net.fexcraft.mod.fvtm.data.WireType;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.container.Container;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;

public enum ContentType {
    ADDON(".fvtm", null),
    TOOLBOX(null, null, "fvtm:toolbox", null),
    PART(".part", "parts", "fvtm:part", Part.class),
    VEHICLE(".vehicle", "vehicles", "fvtm:vehicle", Vehicle.class),
    MATERIAL(".material", "materials", "fvtm:material", Material.class),
    CONTAINER(".container", "containers", "fvtm:container", Container.class),
    CONSUMABLE(".consumable", "consumables", "fvtm:consumable", Consumable.class),
    FUEL(".fuel", "fuels", null, Fuel.class),
    BLOCK(".block", "blocks", "fvtm:block", Block.class),
    MULTIBLOCK(".multiblock", "blocks", "fvtm:multiblock", null),
    RAILGAUGE(".gauge", "railgauges", "fvtm:railgauge", RailGauge.class),
    CLOTH(".cloth", "clothes", "fvtm:cloth", Cloth.class),
    WIRE(".wire", "wires", "fvtm:wire", WireType.class),
    WIREDECO(".wiredeco", "wires", "fvtm:wiredeco", WireDeco.class),
    DECORATION(".deco", "decos", "fvtm:decoration", Decoration.class),
    SIGN(".sign", "signs", "fvtm:sign", Sign.class),
    RECIPE(".json", "recipes", null, Recipe.class);

    public static ArrayList<String> ITYPES;
    public static String ITYPE;
    public String suffix;
    public String folder;
    public String item_type;
    public Class<? extends Content<?>> impl;

    private ContentType(String suffix, String folder) {
        this.suffix = suffix;
        this.folder = folder;
    }

    private ContentType(String suffix, String folder, String itid, Class<? extends Content<?>> clazz) {
        this(suffix, folder);
        this.impl = clazz;
        this.item_type = itid;
    }

    public void register(Content<?> content) {
        switch (this.ordinal()) {
            case 2: {
                FvtmRegistry.PARTS.register(content);
                return;
            }
            case 3: {
                FvtmRegistry.VEHICLES.register(content);
                return;
            }
            case 4: {
                FvtmRegistry.MATERIALS.register(content);
                return;
            }
            case 5: {
                FvtmRegistry.CONTAINERS.register(content);
                return;
            }
            case 6: {
                FvtmRegistry.CONSUMABLES.register(content);
                return;
            }
            case 7: {
                FvtmRegistry.FUELS.register(content);
                return;
            }
            case 8: {
                FvtmRegistry.BLOCKS.register(content);
                return;
            }
            case 9: {
                return;
            }
            case 10: {
                FvtmRegistry.RAILGAUGES.register(content);
                return;
            }
            case 11: {
                FvtmRegistry.CLOTHES.register(content);
                return;
            }
            case 12: {
                FvtmRegistry.WIRES.register(content);
                return;
            }
            case 13: {
                FvtmRegistry.WIREDECOS.register(content);
                return;
            }
            case 14: {
                FvtmRegistry.DECORATIONS.register(content);
                return;
            }
            case 16: {
                FvtmRegistry.RECIPES.register(content);
                return;
            }
            case 15: {
                FvtmRegistry.SIGNS.register(content);
                return;
            }
        }
    }

    static {
        ITYPES = new ArrayList();
        ITYPE = "fvtm:content";
        for (ContentType value : ContentType.values()) {
            if (value.item_type == null) continue;
            ITYPES.add(value.item_type);
        }
    }
}

