/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import java.util.HashMap;
import java.util.Map;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleType;
import net.fexcraft.mod.uni.Appendable;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;

public class FvtmPlayerData
implements Appendable<UniEntity> {
    private HashMap<VehicleType, String> favtypes = new HashMap();
    private V3D position;
    private UniEntity ent;

    public FvtmPlayerData(UniEntity ent) {
        this.ent = ent;
    }

    public String getFavoriteSpawnSystemFor(VehicleType type) {
        return this.favtypes.get((Object)type);
    }

    public boolean setFavoriteSpawnSystemFor(VehicleType type, String systemid) {
        return this.favtypes.put(type, systemid) == null;
    }

    public void setActiveSpawnPoint(V3D vector) {
        this.position = vector;
    }

    public V3D getActiveSpawnPoint() {
        return this.position;
    }

    public void save(UniEntity player, TagCW com) {
        if (this.favtypes.isEmpty()) {
            return;
        }
        TagCW types = TagCW.create();
        for (Map.Entry<VehicleType, String> entry : this.favtypes.entrySet()) {
            if (entry.getValue() == null) continue;
            types.set(entry.getKey().name(), entry.getValue());
        }
        com.set("favtypes", types);
    }

    public void load(UniEntity player, TagCW com) {
        if (com.has("favtypes")) {
            this.favtypes.clear();
            TagCW types = com.getCompound("favtypes");
            for (String key : types.keys()) {
                try {
                    VehicleType type = VehicleType.valueOf(key);
                    this.favtypes.put(type, types.getString(key));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void copy(UniEntity old, Appendable<UniEntity> app) {
        this.favtypes.putAll(((FvtmPlayerData)app).favtypes);
    }

    public FvtmPlayerData create(UniEntity unient) {
        if (!unient.entity.isPlayer()) {
            return null;
        }
        return new FvtmPlayerData(unient);
    }

    public String id() {
        return "fvtm:player";
    }

    public EntityW getPlayer() {
        return this.ent.entity;
    }
}

