/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.content.WireModel;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;

public class WireType
extends Content<WireType>
implements WithItem,
ItemTextureable {
    protected String type;
    protected float def_slack;
    protected boolean customisable;
    protected IDL texture;
    protected IDL itemtexloc;
    protected Model model;
    protected ModelData modeldata;
    protected String modelid;
    protected String ctab;
    protected int segmentation;

    @Override
    public WireType parse(JsonMap map) {
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Wire");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.type = map.getString("Type", "universal");
        this.def_slack = map.getFloat("Slack", Config.WIRE_SLACK_ADJUSTMENT);
        this.segmentation = map.getInteger("Segmentation", 4);
        this.customisable = map.getBoolean("Customisable", true);
        this.texture = ContentConfigUtil.getTextures(map).get(0);
        if (EnvInfo.CLIENT || EnvInfo.is121()) {
            this.modelid = map.getString("Model", null);
            this.modeldata = new ModelData(map);
        }
        this.itemtexloc = ContentConfigUtil.getItemTexture(this.id, ContentType.WIRE, map);
        this.ctab = map.getString("CreativeTab", "default");
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.WIRE;
    }

    @Override
    public Class<?> getDataClass() {
        return null;
    }

    @Override
    public IDL getItemTexture() {
        return this.itemtexloc;
    }

    @Override
    public String getItemContainer() {
        return null;
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    @Override
    public void loadModel() {
        this.model = FvtmResources.getModel(this.modelid, this.modeldata, WireModel.class);
    }

    @Override
    public WireModel getModel() {
        return (WireModel)this.model;
    }

    public float getDefaultSlack() {
        return this.def_slack;
    }

    public boolean isCustomisable() {
        return this.customisable;
    }

    public String getType() {
        return this.type;
    }

    public IDL getTexture() {
        return this.texture;
    }

    public int getSegmentation() {
        return this.segmentation;
    }
}

