/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.addon;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.TextureSupply;
import net.fexcraft.mod.fvtm.data.addon.AddonLocation;
import net.fexcraft.mod.fvtm.sys.condition.Condition;
import net.fexcraft.mod.fvtm.sys.condition.ConditionRegistry;
import net.fexcraft.mod.fvtm.sys.particle.Particle;
import net.fexcraft.mod.fvtm.util.CTab;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.inv.ClothMaterial;

public class Addon
extends Content<Addon> {
    private HashMap<String, CTab> creativetabs = new HashMap();
    protected HashMap<String, ClothMaterial> clothmats = new HashMap();
    protected LinkedHashMap<String, TextureSupply> supp_tex = new LinkedHashMap();
    private List<String> authors = new ArrayList<String>();
    private AddonLocation loc;
    private boolean isJar;
    private File file;
    private String version;
    private String website;
    private String license;

    public Addon(File file, AddonLocation loc) {
        this.isJar = file != null && !file.isDirectory();
        this.file = file;
        this.loc = loc;
    }

    @Override
    public Addon parse(JsonMap map) {
        this.id = ContentConfigUtil.getID(map);
        this.pack = this;
        this.name = map.getString("Name", "Unnamed Addon");
        this.version = map.getString("Version", "0.0");
        if (map.has("Authors")) {
            ((List)map.getArray((String)"Authors").value).forEach(val -> this.authors.add(val.string_value()));
        }
        if (map.has("Author")) {
            this.authors.add(map.get("Author").string_value());
        }
        this.website = map.getString("Website", "http://fexcraft.net/minecraft/content");
        this.license = map.getString("License", "All Rights Reserved");
        if (EnvInfo.CLIENT || EnvInfo.is121()) {
            if (!map.has("CreativeTabs")) {
                this.creativetabs.put("default", CTab.create(this, "default", "fvtm:decoration"));
            } else if (map.get("CreativeTabs").isArray()) {
                ((List)map.getArray((String)"CreativeTabs").value).forEach(jsn -> this.creativetabs.put(jsn.string_value(), CTab.create(this, jsn.string_value(), "fvtm:decoration")));
            } else {
                map.getMap("CreativeTabs").entries().forEach(entry -> this.creativetabs.put((String)entry.getKey(), CTab.create(this, (String)entry.getKey(), ((JsonValue)entry.getValue()).string_value())));
            }
        }
        if (map.has("ClothMaterials") && !EnvInfo.is120()) {
            map.getMap("ClothMaterials").entries().forEach(entry -> {
                try {
                    this.clothmats.put((String)entry.getKey(), ClothMaterial.create((IDL)IDLManager.getIDLCached((String)IDL.conid((IDL)this.id, (String)((String)entry.getKey()))), (JsonMap)((JsonValue)entry.getValue()).asMap()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        if (map.has("SupplyTextures")) {
            map.getMap("SupplyTextures").entries().forEach(entry -> this.supp_tex.put((String)entry.getKey(), new TextureSupply((String)entry.getKey(), ((JsonValue)entry.getValue()).asMap())));
        }
        if (map.has("Particles") && EnvInfo.CLIENT) {
            for (Map.Entry entry2 : map.getMap("Particles").entries()) {
                try {
                    new Particle(IDL.conid((IDL)this.id, (String)((String)entry2.getKey())), ((JsonValue)entry2.getValue()).asMap());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        if (map.has("Conditions")) {
            for (Map.Entry entry2 : map.getMap("Conditions").entries()) {
                Condition cond = null;
                cond = ((JsonValue)entry2.getValue()).isArray() ? new Condition(IDL.conid((IDL)this.id, (String)((String)entry2.getKey())), ((JsonValue)entry2.getValue()).asArray()) : new Condition(IDL.conid((IDL)this.id, (String)((String)entry2.getKey())), ((JsonValue)entry2.getValue()).asMap());
                if (cond == null) continue;
                ConditionRegistry.register(cond);
            }
        }
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.ADDON;
    }

    @Override
    public Class<?> getDataClass() {
        return null;
    }

    @Override
    public void loadModel() {
    }

    public File getFile() {
        return this.file;
    }

    public AddonLocation getLocation() {
        return this.loc;
    }

    public boolean isJar() {
        return this.isJar;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, TextureSupply> getTextureSuppliers() {
        return this.supp_tex;
    }

    public CTab getDefaultCreativeTab() {
        if (this.creativetabs.size() == 0) {
            return null;
        }
        if (this.creativetabs.containsKey("default")) {
            return this.creativetabs.get("default");
        }
        return this.creativetabs.values().toArray(new CTab[0])[0];
    }

    public CTab getCreativeTab(String id) {
        if (this.creativetabs.containsKey(id)) {
            return this.creativetabs.get(id);
        }
        return this.getDefaultCreativeTab();
    }

    public List<String> getAuthors() {
        return ImmutableList.copyOf(this.authors);
    }

    public String getWebsite() {
        return this.website;
    }

    public String getLicense() {
        return this.license;
    }
}

