/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.attribute;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.data.attribute.AttrValueType;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.uni.tag.TagCW;

public class AttrTristate
extends Attribute<Boolean> {
    public AttrTristate(String id, JsonMap map) {
        this(id, map.has("value") ? AttrTristate.validatee(map.get("value").string_value()) : null);
    }

    private static Boolean validatee(String value) {
        if (value.equals("null") || value.trim().length() == 0) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    public AttrTristate(String aid, Boolean val) {
        super(aid, AttrValueType.TRISTATE, val);
    }

    @Override
    public Boolean validate(Object val) {
        return val == null ? null : Boolean.valueOf(Boolean.parseBoolean(val.toString()));
    }

    @Override
    public Boolean parse(String val) {
        return val.equals("null") || val.trim().length() == 0 ? null : Boolean.valueOf(Boolean.parseBoolean(val));
    }

    @Override
    public void increase(float by) {
        this.value = true;
    }

    @Override
    public void decrease(float by) {
        this.value = false;
    }

    @Override
    public String type() {
        return "tristate";
    }

    @Override
    public void saveValue(TagCW com) {
        if (this.value == null) {
            return;
        }
        com.set(this.id, ((Boolean)this.value).booleanValue());
    }

    @Override
    public void loadValue(TagCW com) {
        this.value = !com.has(this.id) ? null : Boolean.valueOf(com.getBoolean(this.id));
    }

    @Override
    public Attribute<Boolean> newInstance() {
        return new AttrTristate(this.id, (Boolean)this.initial);
    }

    @Override
    public int asInteger() {
        return this.value == null ? -1 : ((Boolean)this.value != false ? 1 : 0);
    }

    @Override
    public long asLong() {
        return this.value == null ? -1L : ((Boolean)this.value != false ? 1L : 0L);
    }

    @Override
    public float asFloat() {
        return this.value == null ? -1.0f : ((Boolean)this.value != false ? 1.0f : 0.0f);
    }

    @Override
    public String asString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean asBoolean() {
        return this.value != null && (Boolean)this.value != false;
    }

    @Override
    public Boolean asTristate() {
        return (Boolean)this.value;
    }
}

