/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.block;

import net.fexcraft.app.json.JsonArray;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.data.block.AABB;
import net.fexcraft.mod.uni.world.CubeSide;

public class MB_Interact {
    private AABB aabb;
    private CubeSide sidefrom;
    private V3I pos;
    private String target;
    private boolean script;

    public MB_Interact(JsonArray array, V3I core) {
        this.pos = new V3I(array.toIntegerArray(), 0);
        if (core != null) {
            this.pos = this.pos.add(-core.z, -core.y, -core.x);
        }
        this.script = array.get(3).string_value().equals("script");
        this.target = array.get(4).string_value();
        if (array.size() > 5) {
            if (array.get(5).isArray()) {
                this.aabb = AABB.create(array.get(5).asArray().toFloatArray());
            } else {
                this.sidefrom = CubeSide.valueOf((String)array.get(5).string_value().toUpperCase());
            }
        }
    }

    public boolean isWholeBlock() {
        return this.sidefrom == null && this.aabb == null;
    }

    public AABB getBB() {
        return this.aabb;
    }

    public CubeSide getSide(CubeSide rotate) {
        if (rotate != null && rotate.axe() != CubeSide.Axe.Y && this.sidefrom.axe() != CubeSide.Axe.Y) {
            switch (rotate) {
                case EAST: {
                    return this.sidefrom.rotate();
                }
                case SOUTH: {
                    return this.sidefrom.rotate().rotate();
                }
                case WEST: {
                    return this.sidefrom.rotateCC();
                }
            }
            return this.sidefrom;
        }
        return this.sidefrom;
    }

    public CubeSide getSide(int idx) {
        return this.getSide(CubeSide.fromIndex((int)idx, null));
    }

    public CubeSide getSide() {
        return this.sidefrom;
    }

    public V3I getPos() {
        return this.pos;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean forScript() {
        return this.script;
    }

    public boolean forInventory() {
        return !this.script;
    }
}

