/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.container;

import java.util.Map;
import java.util.TreeMap;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.data.ContentData;
import net.fexcraft.mod.fvtm.data.container.Container;
import net.fexcraft.mod.fvtm.data.container.ContainerType;
import net.fexcraft.mod.fvtm.data.inv.InvHandler;
import net.fexcraft.mod.fvtm.data.root.Colorable;
import net.fexcraft.mod.fvtm.data.root.Lockable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.uni.tag.TagCW;

public class ContainerData
extends ContentData<Container, ContainerData>
implements Colorable,
Textureable.TextureUser {
    protected TreeMap<String, RGB> channels = new TreeMap();
    protected Textureable texture;
    private InvHandler inventory;
    protected Lockable lock;

    public ContainerData(Container type) {
        super(type);
        this.texture = new Textureable(type);
        for (Map.Entry entry : ((TreeMap)type.getDefaultColorChannels()).entrySet()) {
            this.channels.put((String)entry.getKey(), ((RGB)entry.getValue()).copy());
        }
        this.inventory = type.invtype.gen(type.type.length() * 3);
        this.lock = new Lockable();
    }

    @Override
    public RGB getColorChannel(String channel) {
        return this.channels.get(channel);
    }

    @Override
    public void setColorChannel(String channel, RGB color) {
        this.channels.put(channel, color);
    }

    public TreeMap<String, RGB> getColorChannels() {
        return this.channels;
    }

    public Lockable getLock() {
        return this.lock;
    }

    @Override
    public TagCW write(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        compound.set("Container", ((Container)this.type).getIDS());
        for (String str : this.channels.keySet()) {
            compound.set("RGB_" + str, this.channels.get((Object)str).packed);
        }
        this.texture.save(compound);
        this.inventory.save(compound, "Inventory");
        this.lock.save(compound);
        return compound;
    }

    @Override
    public ContainerData read(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        if (compound.has("RGBPrimary")) {
            this.channels.get((Object)"primary").packed = compound.getInteger("RGBPrimary");
        }
        if (compound.has("RGBSecondary")) {
            this.channels.get((Object)"secondary").packed = compound.getInteger("RGBSecondary");
        }
        for (String str : this.channels.keySet()) {
            if (!compound.has("RGB_" + str)) continue;
            this.channels.get((Object)str).packed = compound.getInteger("RGB_" + str);
        }
        this.texture.load(compound);
        this.inventory.load(compound, "Inventory");
        this.lock.load(compound);
        return this;
    }

    @Override
    public ContainerData parse(JsonMap obj) {
        return this;
    }

    @Override
    public JsonMap toJson() {
        return new JsonMap();
    }

    public ContainerType getContainerType() {
        return ((Container)this.type).getContainerType();
    }

    public InvHandler getInventory() {
        return this.inventory;
    }

    @Override
    public Textureable getTexture() {
        return this.texture;
    }

    @Override
    public Textureable.TextureHolder getTexHolder() {
        return (Textureable.TextureHolder)((Object)this.type);
    }
}

