/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.container;

import net.fexcraft.lib.common.math.RGB;

public enum ContainerType {
    MICRO(1, 0x404040),
    TINY(2, 0xE20000),
    SMALL(3, 32639),
    MEDIUM(6, 32526),
    LARGE(12, 4991);

    private boolean even;
    private int length;
    private RGB color;

    private ContainerType(int length, int color) {
        this.length = length;
        this.even = this.length % 2 == 0;
        this.color = new RGB(color);
    }

    public int length() {
        return this.length;
    }

    public boolean isEven() {
        return this.even;
    }

    public ContainerType next(boolean loop, boolean nell) {
        switch (this.ordinal()) {
            case 4: {
                return loop ? TINY : (nell ? null : LARGE);
            }
            case 3: {
                return LARGE;
            }
            case 2: {
                return MEDIUM;
            }
            case 1: {
                return SMALL;
            }
            case 0: {
                return TINY;
            }
        }
        return nell ? null : MEDIUM;
    }

    public ContainerType prev(boolean loop, boolean nell) {
        switch (this.ordinal()) {
            case 4: {
                return MEDIUM;
            }
            case 3: {
                return SMALL;
            }
            case 2: {
                return TINY;
            }
            case 1: {
                return MICRO;
            }
            case 0: {
                return loop ? LARGE : (nell ? null : MICRO);
            }
        }
        return nell ? null : MEDIUM;
    }

    public boolean isLarge() {
        return this == LARGE;
    }

    public boolean isMedium() {
        return this == MEDIUM;
    }

    public boolean isSmall() {
        return this == SMALL;
    }

    public boolean isTiny() {
        return this == TINY;
    }

    public boolean isMicro() {
        return this == MICRO;
    }

    public int getColor() {
        return this.color.packed;
    }

    public RGB getRGB() {
        return this.color;
    }
}

