/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.vehicle;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;

public class WheelSlot {
    public V3D position;
    public boolean mirror;
    public float hubsize;
    public float max_radius = 0.75f;
    public float min_wheel_radius = 0.25f;
    public float min_tire_radius = 0.5f;
    public float max_width = 0.75f;
    public float min_wheel_width = 0.125f;
    public float min_tire_width = 0.125f;
    public boolean steering;
    public boolean required;
    public boolean relative;
    public boolean braking;
    public String powered;

    public WheelSlot() {
    }

    public WheelSlot(JsonMap map) {
        this.position = ContentConfigUtil.getVector(map.getArray("pos"));
        this.mirror = map.getBoolean("mirror", false);
        this.hubsize = map.getFloat("hubsize", 0.0f);
        if (map.has("radius")) {
            float rad = map.getFloat("radius", 0.5f);
            this.max_radius = rad + 0.0125f;
            this.min_wheel_radius = rad / 2.0f;
            this.min_tire_radius = rad - 0.0125f;
        }
        if (map.has("width")) {
            float wid = map.getFloat("width", 0.5f);
            this.max_width = wid + 0.0125f;
            this.min_wheel_width = wid - 0.0125f;
            this.min_tire_width = wid - 0.0125f;
        }
        this.max_radius = map.getFloat("max_radius", this.max_radius);
        this.min_wheel_radius = map.getFloat("min_wheel_radius", this.min_wheel_width);
        this.min_tire_radius = map.getFloat("min_tire_radius", this.min_tire_radius);
        this.max_width = map.getFloat("max_width", this.max_width);
        this.min_wheel_width = map.getFloat("min_wheel_width", this.min_wheel_width);
        this.min_tire_width = map.getFloat("min_tire_width", this.min_tire_width);
        this.steering = map.getBoolean("steering", false);
        this.required = map.getBoolean("required", true);
        this.relative = map.getBoolean("relative", false);
        if (map.has("powered")) {
            this.powered = map.get("powered").string_value().equals("true") ? "" : map.getString("powered", "");
        }
        this.braking = map.getBoolean("braking", true);
    }

    public boolean powered(VehicleData data) {
        return this.powered == null ? false : this.powered.length() == 0 || data.getAttributeBoolean(this.powered, false) != false;
    }

    public float min_radius(boolean tire) {
        return tire ? this.min_tire_radius : this.min_wheel_radius;
    }

    public float min_width(boolean tire) {
        return tire ? this.min_tire_width : this.min_wheel_width;
    }

    public WheelSlot copy(V3D pos) {
        V3D npos = this.position.copy();
        if (pos != null && this.relative) {
            npos = npos.add(pos);
        }
        WheelSlot slot = new WheelSlot();
        slot.position = npos;
        slot.mirror = this.mirror;
        slot.hubsize = this.hubsize;
        slot.max_radius = this.max_radius;
        slot.min_wheel_radius = this.min_wheel_radius;
        slot.min_tire_radius = this.min_tire_radius;
        slot.max_width = this.max_width;
        slot.min_wheel_width = this.min_wheel_width;
        slot.min_tire_width = this.min_tire_width;
        slot.steering = this.steering;
        slot.required = this.required;
        slot.relative = this.relative;
        slot.braking = this.braking;
        slot.powered = this.powered;
        return slot;
    }
}

