/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.function.block;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.data.block.BlockFunction;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.world.CubeSide;
import net.fexcraft.mod.uni.world.StateWrapper;
import net.fexcraft.mod.uni.world.WorldW;

public class SetStateFunction
extends BlockFunction.StaticBlockFunction {
    private ArrayList<ChangeState> changes = new ArrayList();

    @Override
    public BlockFunction parse(JsonValue val) {
        if (val == null) {
            return this;
        }
        if (val.isMap()) {
            this.changes.add(new ChangeState(val.asMap()));
        } else if (val.isArray()) {
            for (JsonValue jsn : (List)val.asArray().value) {
                this.changes.add(new ChangeState(jsn.asMap()));
            }
        }
        return this;
    }

    @Override
    public String id() {
        return "fvtm:set_state";
    }

    @Override
    public boolean onClick(WorldW world, V3I pos, V3D hit, StateWrapper state, CubeSide side, Passenger player, boolean main) {
        if (!main) {
            return false;
        }
        for (ChangeState cs : this.changes) {
            StateWrapper cond;
            FvtmLogger.marker(cs.cstate + " " + cs.nstate);
            if (Static.random.nextFloat() < 1.0f - cs.chance || cs.cstate != null && !state.equals((Object)(cond = StateWrapper.from((Object)state.getBlock(), (String)cs.cstate)))) continue;
            if (cs.valid.size() > 0) {
                if (!cs.valid.contains(player.getHeldItem(main).getID())) continue;
                if (cs.consume) {
                    StackWrapper stack = player.getHeldItem(main);
                    stack.count(stack.count() - 1);
                }
            }
            String str = cs.nstate.isEmpty() ? state.getStateString() : (cs.nstate.endsWith(" *") ? cs.nstate.replace("*", state.getStateString()) : cs.nstate);
            StateWrapper newstate = StateWrapper.from((Object)(cs.nstate.contains(" ") ? null : state.getBlock()), (String)str);
            world.setBlockState(pos, newstate);
            return true;
        }
        return false;
    }

    private static class ChangeState {
        private String cstate;
        private String nstate;
        private float chance;
        private ArrayList<String> valid = new ArrayList();
        private boolean consume;

        public ChangeState(JsonMap map) {
            this.cstate = map.getString("equals", null);
            this.nstate = map.getString("state", "");
            if (map.has("state12") && EnvInfo.is112()) {
                this.nstate = map.getString("state12", "");
            }
            this.chance = map.getFloat("chance", 1.0f);
            if (this.chance > 1.0f) {
                this.chance = 1.0f;
            }
            if (this.chance < 0.0f) {
                this.chance = 0.0f;
            }
            if (map.has("valid_items")) {
                this.valid = map.getArray("valid_items").toStringList();
            }
            this.consume = map.getBoolean("consume_item", false);
        }
    }
}

