/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.content;

import java.util.ArrayList;
import java.util.TreeMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import org.lwjgl.opengl.GL11;

public class ClothModel
extends DefaultModel {
    public static final ClothModel EMPTY = new ClothModel();
    protected TreeMap<String, ArrayList<String>> cloth_groups = new TreeMap();

    @Override
    public ClothModel parse(ModelData data) {
        super.parse(data);
        if (data.has("SetGroupAs")) {
            JsonValue sga = data.get("SetGroupAs");
            ArrayList<String> list = null;
            if (sga.isArray()) {
                list = sga.asArray().toStringList();
            } else {
                list = new ArrayList<String>();
                list.add(sga.string_value());
            }
            for (String string : list) {
                String[] args = string.trim().split(" ");
                if (!this.groups.contains(args[0])) continue;
                try {
                    String group = args[0];
                    String model = args[1];
                    float x = args.length > 2 ? Float.parseFloat(args[2]) : 0.0f;
                    float y = args.length > 3 ? Float.parseFloat(args[3]) : 0.0f;
                    float z = args.length > 4 ? Float.parseFloat(args[4]) : 0.0f;
                    this.setGroupAs(group, model, x, y, z);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this;
    }

    public void setGroupAs(String group, String playermodelpart, float x, float y, float z) {
        if (!this.groups.contains(group)) {
            return;
        }
        this.setGroupAs(this.groups.get(group), playermodelpart, x, y, z);
    }

    public void setGroupAs(ModelGroup group, String playermodelpart, float x, float y, float z) {
        if (!this.cloth_groups.containsKey(playermodelpart)) {
            this.cloth_groups.put(playermodelpart, new ArrayList());
        }
        this.cloth_groups.get(playermodelpart).add(group.name);
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            return;
        }
        group.translate(x, y, z, false);
    }

    @Override
    public void render(ModelRenderData data) {
        this.transforms.apply();
        GL11.glShadeModel((int)(this.smooth_shading ? 7424 : 7425));
        for (ModelGroup list : this.groups) {
            if (!data.cloth_groups.contains(list.name)) continue;
            list.render(data);
        }
        this.transforms.deapply();
    }

    public TreeMap<String, ArrayList<String>> getClothGroups() {
        return this.cloth_groups;
    }
}

