/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import java.util.ArrayList;
import java.util.Map;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.data.InteractZone;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartSlot;
import net.fexcraft.mod.fvtm.data.part.PartSlots;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.entity.RootVehicle;
import net.fexcraft.mod.fvtm.handler.DefaultPartInstallHandler;
import net.fexcraft.mod.fvtm.handler.WheelInstallationHandler;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.item.PartItem;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.model.RenderCacheI;
import net.fexcraft.mod.fvtm.render.FvtmRenderState;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.Renderer21;
import net.fexcraft.mod.fvtm.render.SeparateRenderCache;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.fvtm.util.MathUtils;
import net.fexcraft.mod.fvtm.util.PartItemApp;
import net.fexcraft.mod.fvtm.util.Rot;
import net.fexcraft.mod.uni.inv.UniStack;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class RVRenderer
extends class_897<RootVehicle, FvtmRenderState> {
    private SeparateRenderCache.SepVehCache sepcache;

    public RVRenderer(class_5617.class_5618 context) {
        super(context);
        this.field_4673 = 0.25f;
    }

    public FvtmRenderState createRenderState() {
        return new FvtmRenderState();
    }

    public void extractRenderState(RootVehicle entity, FvtmRenderState state, float f) {
        super.method_62354((class_1297)entity, (class_10017)state, f);
        state.entity = entity;
        state.vehicle = entity.vehicle;
        state.f = f;
    }

    public void render(FvtmRenderState state, class_4587 pose, class_4597 buffer, int light) {
        V3D vp;
        if (state.vehicle == null || state.vehicle.data == null) {
            return;
        }
        if (state.vehicle.cache == null) {
            state.vehicle.cache = new RenderCacheI();
        }
        this.sepcache = state.vehicle.cache.get(SeparateRenderCache.SEP_VEH_CACHE, data -> new SeparateRenderCache.SepVehCache());
        pose.method_22903();
        V3D rot = this.getRotations(state.entity, state.f);
        pose.method_22907((Quaternionfc)new Quaternionf().rotateAxis((float)Static.toRadians((double)(-rot.x)), (Vector3fc)Renderer21.AY).rotateAxis((float)Static.toRadians((double)rot.y), (Vector3fc)Renderer21.AX).rotateAxis((float)Static.toRadians((double)rot.z), (Vector3fc)Renderer21.AZ));
        this.sepcache.set(state.entity.method_19538().field_1352, state.entity.method_19538().field_1351, state.entity.method_19538().field_1350, rot);
        Renderer21.set(pose, buffer, light);
        pose.method_22903();
        Model vehmod = ((Vehicle)state.vehicle.data.getType()).getModel();
        FvtmRenderTypes.setCutout(state.vehicle.data.getCurrentTexture());
        if (vehmod != null) {
            pose.method_22903();
            vehmod.render(DefaultModel.RENDERDATA.set(state.vehicle.data, state.vehicle, state.f).rc(state.vehicle.cache));
            pose.method_22909();
        } else {
            FvtmLogger.LOGGER.info("NO MODEL " + state.entity.method_5628() + " " + String.valueOf(((Vehicle)state.vehicle.data.getType()).getID()));
        }
        if (state.vehicle.data.getParts().size() > 0) {
            RVRenderer.renderPoint(pose, state.vehicle.point, state.entity, state.vehicle.data, state.vehicle.cache, state.f);
        }
        if (RVRenderer.isInRange(pose, vp = state.vehicle.getV3D(), state.vehicle.data)) {
            RVRenderer.renderVehicleInfo(pose, vp, state.vehicle.data);
        }
        pose.method_22909();
        if (DebugUtils.ACTIVE) {
            this.renderSeats(pose, state.vehicle);
        }
        pose.method_22909();
    }

    private void renderSeats(class_4587 pose, VehicleInstance vehicle) {
        if (vehicle.seats.isEmpty()) {
            return;
        }
        pose.method_22903();
        FvtmRenderTypes.setLines();
        for (SeatInstance seat : vehicle.seats) {
            pose.method_22903();
            float scale = seat.seat.scale() * 0.5f;
            V3D pos = seat.seat.pos;
            if (!seat.point.isVehicle()) {
                pos = seat.point.getRelativeVector(pos);
            }
            pose.method_22904(pos.x, pos.y, pos.z);
            Renderer21.pose.method_22905(scale, scale, scale);
            Renderer21.setColor(DebugUtils.SEATCOLOR);
            DebugUtils.CUBE.render();
            pose.method_22909();
        }
        Renderer21.resetColor();
        pose.method_22909();
    }

    public static boolean isInRange(class_4587 pose, V3D vehpos, VehicleData data) {
        FvtmRenderTypes.setLineStrip();
        V3D ply = new V3D(class_310.method_1551().field_1724.method_19538().field_1352, class_310.method_1551().field_1724.method_19538().field_1351, class_310.method_1551().field_1724.method_19538().field_1350);
        boolean inrange = false;
        for (InteractZone zone : data.getInteractZones().values()) {
            if (zone.inRange(data, vehpos, ply)) {
                inrange = true;
                break;
            }
            if (!DebugUtils.ACTIVE) continue;
            pose.method_22903();
            Renderer21.setColor(zone.inRange(data, vehpos, ply) ? DebugUtils.GRNCOLOR : DebugUtils.GRYCOLOR);
            pose.method_22905(zone.range, zone.range, zone.range);
            DebugUtils.SPHERE.render();
            Renderer21.resetColor();
            pose.method_22909();
        }
        return inrange;
    }

    public static void renderVehicleInfo(class_4587 pose, V3D vehpos, VehicleData data) {
        int tool;
        boolean red;
        PartData part = RVRenderer.isNormalPart();
        SwivelPoint point = null;
        FvtmRenderTypes.setLines();
        if (part != null) {
            for (Map.Entry<String, PartSlots> ps : data.getPartSlotProviders().entrySet()) {
                V3D pos = ps.getKey().equals("vehicle") ? V3D.NULL : data.getPart((String)ps.getKey()).getInstalledPos();
                point = data.getRotationPointOfPart((String)ps.getKey());
                red = false;
                for (PartSlot value : ((PartSlots)ps.getValue()).values()) {
                    if (data.hasPart(value.type)) {
                        Part epart = (Part)data.getPart(value.type).getType();
                        if (!(epart.getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData)) continue;
                        red = !((DefaultPartInstallHandler.DPIHData)epart.getInstallHandlerData()).swappable;
                    }
                    String type = value.type;
                    for (String str : ((Part)part.getType()).getCategories()) {
                        if (!str.equals(type)) continue;
                        V3D pes = pos.add(value.pos);
                        if (point.isVehicle()) {
                            pose.method_22904(pes.x, pes.y, pes.z);
                        } else {
                            pose.method_22903();
                            V3D vec = point.getRelativeVector(pes);
                            pose.method_22904(vec.x, vec.y, vec.z);
                            Renderer21.rotateRad(point.getPivot().yaw(), Renderer21.AY);
                            Renderer21.rotateRad(point.getPivot().pitch(), Renderer21.AX);
                            Renderer21.rotateRad(point.getPivot().roll(), Renderer21.AZ);
                        }
                        pose.method_22903();
                        pose.method_22905(value.radius, value.radius, value.radius);
                        Renderer21.setColor(red ? DebugUtils.REDCOLOR : DebugUtils.CYNCOLOR);
                        DebugUtils.CUBE.render();
                        pose.method_22909();
                        if (!point.isVehicle()) {
                            pose.method_22909();
                            continue;
                        }
                        pose.method_22904(-pes.x, -pes.y, -pes.z);
                    }
                }
            }
        }
        if ((tool = RVRenderer.isImpact()) > -1) {
            red = ((Vehicle)data.getType()).getImpactWrenchLevel() > tool;
            for (WheelSlot slot : data.getWheelSlots().values()) {
                pose.method_22903();
                pose.method_22904(slot.position.x, slot.position.y, slot.position.z);
                pose.method_22905(slot.max_radius, slot.max_radius, slot.max_radius);
                Renderer21.setColor(red ? DebugUtils.REDCOLOR : DebugUtils.CYNCOLOR);
                DebugUtils.CUBE.render();
                pose.method_22909();
            }
        }
        if ((part = RVRenderer.isWheelOrTire()) != null) {
            boolean wheel = part.hasFunction("fvtm:wheel");
            for (Map.Entry<String, WheelSlot> entry : data.getWheelSlots().entrySet()) {
                boolean green = ((Part)part.getType()).getInstallHandler().validInstall(FvtmLogger.NONE, part, entry.getKey(), data, true);
                if (wheel) {
                    red = data.hasPart(entry.getKey());
                } else {
                    boolean bl = red = data.hasPart(entry.getKey()) && ((WheelInstallationHandler.WheelData)((Part)data.getPart(entry.getKey()).getType()).getInstallHandlerData()).hasTire();
                    if (!red) {
                        red = data.hasPart(entry.getKey() + ":tire");
                    }
                }
                WheelSlot slot = entry.getValue();
                pose.method_22903();
                pose.method_22904(slot.position.x, slot.position.y, slot.position.z);
                pose.method_22905(slot.max_radius, slot.max_radius, slot.max_radius);
                Renderer21.setColor(red ? DebugUtils.REDCOLOR : (green ? DebugUtils.GRNCOLOR : DebugUtils.CYNCOLOR));
                DebugUtils.CUBE.render();
                pose.method_22909();
            }
        }
        if ((tool = RVRenderer.isToolbox()) > 0) {
            Renderer21.setColor(DebugUtils.ORGCOLOR);
            DebugUtils.CUBE.render();
        }
        if (tool > -1 && tool < 2) {
            for (Map.Entry<String, PartData> entry : data.getParts().entrySet()) {
                if (tool == 0 && !(((Part)entry.getValue().getType()).getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData)) continue;
                red = tool != 0 || ((DefaultPartInstallHandler.DPIHData)((Part)entry.getValue().getType()).getInstallHandlerData()).removable;
                point = data.getRotationPointOfPart(entry.getKey());
                V3D pos = entry.getValue().getInstalledPos();
                if (point.isVehicle()) {
                    pose.method_22904(pos.x, pos.y, pos.z);
                } else {
                    pose.method_22903();
                    pos = point.getRelativeVector(pos);
                    pose.method_22904(pos.x, pos.y, pos.z);
                    Renderer21.rotateDeg(pose, point.getPivot().deg_yaw(), Renderer21.AY);
                    Renderer21.rotateDeg(pose, point.getPivot().deg_pitch(), Renderer21.AX);
                    Renderer21.rotateDeg(pose, point.getPivot().deg_roll(), Renderer21.AZ);
                }
                pose.method_22903();
                if (red) {
                    pose.method_22905(0.25f, 0.25f, 0.25f);
                    Renderer21.setColor(DebugUtils.YLWCOLOR);
                } else {
                    pose.method_22905(0.125f, 0.125f, 0.125f);
                    Renderer21.setColor(DebugUtils.REDCOLOR);
                }
                DebugUtils.CUBE.render();
                pose.method_22909();
                if (!point.isVehicle()) {
                    pose.method_22909();
                    continue;
                }
                pose.method_22904(-pos.x, -pos.y, -pos.z);
            }
        }
        Renderer21.resetColor();
    }

    private static int isImpact() {
        if (!(class_310.method_1551().field_1724.method_6047().method_7909() instanceof MaterialItem)) {
            return -1;
        }
        return ((MaterialItem)class_310.method_1551().field_1724.method_6047().method_7909()).getContent().getImpactLevel();
    }

    public static int isToolbox() {
        if (!(class_310.method_1551().field_1724.method_6047().method_7909() instanceof ToolboxItem)) {
            return -1;
        }
        return ((ToolboxItem)class_310.method_1551().field_1724.method_6047().method_7909()).var;
    }

    private static PartData isNormalPart() {
        if (!(class_310.method_1551().field_1724.method_6047().method_7909() instanceof PartItem)) {
            return null;
        }
        PartData data = ((PartItemApp)UniStack.getApp((Object)class_310.method_1551().field_1724.method_6047(), PartItemApp.class)).data;
        return ((Part)data.getType()).getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData ? data : null;
    }

    private static PartData isWheelOrTire() {
        if (!(class_310.method_1551().field_1724.method_6047().method_7909() instanceof PartItem)) {
            return null;
        }
        PartData data = ((PartItemApp)UniStack.getApp((Object)class_310.method_1551().field_1724.method_6047(), PartItemApp.class)).data;
        return data.hasFunction("fvtm:wheel") || data.hasFunction("fvtm:tire") ? data : null;
    }

    private V3D getRotations(RootVehicle veh, float ticks) {
        double yaw = MathUtils.valDeg(veh.vehicle.pivot().deg_yaw() - veh.field_5982);
        double pitch = MathUtils.valDeg(veh.vehicle.pivot().deg_pitch() - veh.field_6004);
        double roll = MathUtils.valDeg(veh.vehicle.pivot().deg_roll() - veh.protZ);
        return new V3D((double)veh.field_5982 + yaw * (double)ticks, (double)veh.field_6004 + pitch * (double)ticks, (double)veh.protZ + roll * (double)ticks);
    }

    public static V3D getRotations(SwivelPoint point, float ticks) {
        double yaw = MathUtils.valDeg(point.getPivot().deg_yaw() - point.getPrevPivot().deg_yaw());
        double pitch = MathUtils.valDeg(point.getPivot().deg_pitch() - point.getPrevPivot().deg_pitch());
        double roll = MathUtils.valDeg(point.getPivot().deg_roll() - point.getPrevPivot().deg_roll());
        return new V3D((double)point.getPrevPivot().deg_yaw() + yaw * (double)ticks, (double)point.getPrevPivot().deg_pitch() + pitch * (double)ticks, (double)point.getPrevPivot().deg_roll() + roll * (double)ticks);
    }

    public static void renderPoint(class_4587 pose, SwivelPoint point, RootVehicle vehicle, VehicleData data, RenderCache cache, float ticks) {
        ArrayList<Map.Entry<String, PartData>> parts = data.sorted_parts.get(point.id);
        if (parts == null) {
            return;
        }
        pose.method_22903();
        if (!point.isVehicle()) {
            V3D temp0 = point.getPos();
            V3D temp1 = point.getPrevPos();
            V3D temp2 = new V3D(temp1.x + (temp0.x - temp1.x) * (double)ticks, temp1.y + (temp0.y - temp1.y) * (double)ticks, temp1.z + (temp0.z - temp1.z) * (double)ticks);
            V3D rot = RVRenderer.getRotations(point, ticks);
            pose.method_22904(temp2.x, temp2.y, temp2.z);
            pose.method_22907((Quaternionfc)new Quaternionf().rotateAxis((float)Static.toRadians((double)(-rot.x)), (Vector3fc)Renderer21.AY).rotateAxis((float)Static.toRadians((double)(-rot.y)), (Vector3fc)Renderer21.AX).rotateAxis((float)Static.toRadians((double)(-rot.z)), (Vector3fc)Renderer21.AZ));
        }
        for (Map.Entry<String, PartData> entry : parts) {
            if (((Part)entry.getValue().getType()).getModel() == null) continue;
            pose.method_22903();
            FvtmRenderTypes.setCutout(entry.getValue().getCurrentTexture());
            RVRenderer.translate(pose, entry.getValue().getInstalledPos());
            RVRenderer.rotate(pose, entry.getValue().getInstalledRot());
            ((Part)entry.getValue().getType()).getModel().render(DefaultModel.RENDERDATA.set(data, vehicle == null ? null : vehicle.vehicle, entry.getValue(), entry.getKey(), ticks).rc(cache));
            pose.method_22909();
        }
        for (SwivelPoint sub : point.subs) {
            RVRenderer.renderPoint(pose, sub, vehicle, data, cache, ticks);
        }
        pose.method_22909();
    }

    private static void translate(class_4587 pose, V3D pos) {
        pose.method_22904(pos.x, pos.y, pos.z);
    }

    private static void rotate(class_4587 pose, Rot rot) {
        rot.rotate112();
        Quaternionf q = new Quaternionf();
        if (rot.vec().y != 0.0) {
            q.rotateAxis((float)Static.toRadians((double)rot.vec().y), (Vector3fc)Renderer21.AY);
        }
        if (rot.vec().x != 0.0) {
            q.rotateAxis((float)Static.toRadians((double)rot.vec().x), (Vector3fc)Renderer21.AX);
        }
        if (rot.vec().z != 0.0) {
            q.rotateAxis((float)Static.toRadians((double)rot.vec().z), (Vector3fc)Renderer21.AZ);
        }
        pose.method_22907((Quaternionfc)q);
    }

    public static void renderPointSep(class_4587 pose, SwivelPoint point, VehicleInstance inst, ArrayList<String> parts, float ticks) {
        pose.method_22903();
        if (!point.isVehicle()) {
            V3D temp0 = point.getPos();
            V3D temp1 = point.getPrevPos();
            V3D temp2 = new V3D(temp1.x + (temp0.x - temp1.x) * (double)ticks, temp1.y + (temp0.y - temp1.y) * (double)ticks, temp1.z + (temp0.z - temp1.z) * (double)ticks);
            V3D rot = RVRenderer.getRotations(point, ticks);
            pose.method_22904(temp2.x, temp2.y, temp2.z);
            pose.method_22907((Quaternionfc)new Quaternionf().rotateAxis((float)Static.toRadians((double)(-rot.x)), (Vector3fc)Renderer21.AY).rotateAxis((float)Static.toRadians((double)(-rot.y)), (Vector3fc)Renderer21.AX).rotateAxis((float)Static.toRadians((double)(-rot.z)), (Vector3fc)Renderer21.AZ));
        }
        for (Map.Entry<String, PartData> entry : inst.data.getParts().entrySet()) {
            if (!parts.contains(entry.getKey()) || !entry.getValue().isInstalledOnSwivelPoint(point.id)) continue;
            pose.method_22903();
            FvtmRenderTypes.setCutout(entry.getValue().getCurrentTexture());
            RVRenderer.translate(pose, entry.getValue().getInstalledPos());
            RVRenderer.rotate(pose, entry.getValue().getInstalledRot());
            ((Part)entry.getValue().getType()).getModel().render(DefaultModel.RENDERDATA.set(inst.data, inst, entry.getValue(), entry.getKey(), ticks).rc(inst.cache).sep());
            pose.method_22909();
        }
        for (SwivelPoint sub : point.subs) {
            RVRenderer.renderPointSep(pose, sub, inst, parts, ticks);
        }
        pose.method_22909();
    }
}

