/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.road;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.road.UniRoadTool;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WorldW;

public class RoadPlacingUtil {
    public static final ConcurrentHashMap<UUID, NewRoad> QUEUE = new ConcurrentHashMap();
    public static final ConcurrentHashMap<UUID, UUID> CURRENT = new ConcurrentHashMap();
    public static NewRoad CL_CURRENT = null;

    public static void place(WorldW world, Passenger pass, TagCW com, QV3D vector) {
        UUID roadid = CURRENT.get(pass.getUUID());
        if (!com.has("RoadLayers")) {
            pass.send("interact.fvtm.road_tool.empty");
            return;
        }
        int width = com.getIntArray("RoadLayers")[0];
        if (roadid == null) {
            UUID newid = RoadPlacingUtil.genId();
            QUEUE.put(newid, new NewRoad(newid, vector, width));
            CURRENT.put(pass.getUUID(), newid);
            TagCW compound = TagCW.create();
            compound.set("uuid_l", newid.getMostSignificantBits());
            compound.set("uuid_m", newid.getLeastSignificantBits());
            compound.set("width", width);
            vector.write(compound, "vector");
            Packets.sendToAll(Packets.PKT_TAG, "road_tool_new", compound);
            FvtmResources.INSTANCE.spawnRoadMarker(world, vector, newid);
            return;
        }
        NewRoad road = QUEUE.get(roadid);
        if (road == null) {
            CURRENT.remove(pass.getUUID());
        }
        road.add(vector, width);
        TagCW compound = TagCW.create();
        compound.set("uuid_l", roadid.getMostSignificantBits());
        compound.set("uuid_m", roadid.getLeastSignificantBits());
        compound.set("width", width);
        vector.write(compound, "vector");
        Packets.sendToAll(Packets.PKT_TAG, "road_tool_add", compound);
        FvtmResources.INSTANCE.spawnRoadMarker(world, vector, roadid);
    }

    private static UUID genId() {
        UUID uuid = UUID.randomUUID();
        while (QUEUE.contains(uuid) || uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L) {
            uuid = UUID.randomUUID();
        }
        return uuid;
    }

    public static class NewRoad {
        public ArrayList<QV3D> points = new ArrayList();
        public ArrayList<ArrayList<V3D>> preview;
        public UniRoadTool.Road road;
        public int selected = -1;
        public int width;
        public UUID id;

        public NewRoad(UUID uuid, QV3D vector, int width) {
            this.points.add(vector);
            this.width = width;
            this.id = uuid;
        }

        public void add(QV3D vector, int width) {
            this.points.add(this.selected == -1 ? this.points.size() : (this.selected = this.selected + 1), vector);
            this.width = width;
            this.preview = null;
            this.genroad();
        }

        public void genroad() {
            this.road = this.points.size() > 1 ? new UniRoadTool.Road(this.points.toArray(new QV3D[0])) : null;
        }

        public void select(Passenger pass, QV3D vector) {
            int sel = -1;
            for (int i = 0; i < this.points.size(); ++i) {
                if (!vector.equals(this.points.get(i))) continue;
                sel = i;
                break;
            }
            this.selected = sel;
            TagCW compound = TagCW.create();
            compound.set("selected", this.selected);
            compound.set("uuid_l", this.id.getMostSignificantBits());
            compound.set("uuid_m", this.id.getLeastSignificantBits());
            Packets.sendToAll(Packets.PKT_TAG, "road_tool_selected", compound);
        }

        public void remove(Passenger pass, QV3D vector) {
            int rem = -1;
            for (int i = 0; i < this.points.size(); ++i) {
                if (!vector.equals(this.points.get(i))) continue;
                rem = i;
                break;
            }
            if (rem < 0) {
                return;
            }
            if (rem <= this.selected) {
                --this.selected;
            }
            if (this.selected < -1) {
                this.selected = -1;
            }
            this.points.remove(rem);
            this.genroad();
            this.preview = null;
            if (this.points.size() == 0) {
                this.reset();
                return;
            }
            TagCW compound = TagCW.create();
            compound.set("remove", rem);
            compound.set("uuid_l", this.id.getMostSignificantBits());
            compound.set("uuid_m", this.id.getLeastSignificantBits());
            vector.write(TagCW.wrap((Object)compound), "vector");
            Packets.sendToAll(Packets.PKT_TAG, "road_tool_remove", compound);
        }

        public void reset() {
            QUEUE.remove(this.id);
            CURRENT.entrySet().removeIf(entry -> ((UUID)entry.getValue()).equals(this.id));
            TagCW compound = TagCW.create();
            compound.set("uuid_l", this.id.getMostSignificantBits());
            compound.set("uuid_m", this.id.getLeastSignificantBits());
            Packets.sendToAll(Packets.PKT_TAG, "road_tool_reset", compound);
        }

        public int indexOf(QV3D vector) {
            for (int i = 0; i < this.points.size(); ++i) {
                if (!vector.equals(this.points.get(i))) continue;
                return i;
            }
            return -2;
        }

        public void create(Passenger pass, QV3D vector, StackWrapper stack) {
            UUID current = CURRENT.get(pass.getUUID());
            if (current == null) {
                pass.send("no_queue_entry / 0");
                return;
            }
            NewRoad nroad = QUEUE.get(current);
            if (nroad == null) {
                pass.send("no_queue_entry / 1");
                return;
            }
            if (!UniRoadTool.placeRoad(pass, stack, new UniRoadTool.Road(nroad.points.toArray(new QV3D[0])))) {
                return;
            }
            pass.send("interact.fvtm.road_tool.complete");
            nroad.reset();
        }

        public void genpreview() {
            double half = (float)this.width * 0.5f;
            this.preview = new ArrayList();
            for (int i = 0; i < this.width + 1; ++i) {
                this.preview.add(new ArrayList());
            }
            V3D vec = this.road.vecpath[0];
            float pass = 0.0f;
            while ((double)pass < this.road.length + 0.125) {
                V3D last = vec;
                vec = this.road.getVectorPosition0(pass == 0.0f ? (double)0.001f : (double)pass, false);
                double angle = (float)Math.atan2(last.x - vec.x, last.z - vec.z);
                for (int w = 0; w < this.width + 1; ++w) {
                    this.preview.get(w).add(vec.add(UniRoadTool.grv(angle, new V3D(-half + (double)w, 0.0, 0.0))));
                }
                pass += 0.125f;
            }
        }
    }
}

