/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.vehicle;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.data.Fuel;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniInventory;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;

public class VehicleFuelCon
extends ContainerInterface {
    protected VehicleInstance vehicle;
    protected long date;

    public VehicleFuelCon(JsonMap map, UniEntity player, V3I pos) {
        super(map, player, pos);
        this.vehicle = ((Passenger)player.entity).getFvtmWorld().getVehicle(pos.x);
        this.inventory = UniInventory.create((int)1).stacksize(1).drop(true);
    }

    public Object get(String key, Object ... objs) {
        if (key.equals("vehicle")) {
            return this.vehicle;
        }
        return null;
    }

    public void packet(TagCW com, boolean client) {
        if (!client) {
            return;
        }
        if (com.getString("cargo").equals("update_fuel_tank")) {
            this.vehicle.data.getAttribute("fuel_stored").set(com.getInteger("state"));
            if (com.has("stack")) {
                this.inventory.set(0, UniStack.createStack((Object)com.getCompound("stack")));
            }
        }
        if (com.getString("cargo").equals("update_fuel_data")) {
            this.vehicle.data.getAttribute("fuel_primary").set(com.getString("primary"));
            this.vehicle.data.getAttribute("fuel_secondary").set(com.getString("secondary"));
            this.vehicle.data.getAttribute("fuel_quality").set(Float.valueOf(com.getFloat("quality")));
        }
    }

    public void update(Object lc) {
        if (this.inventory.empty(0)) {
            return;
        }
        if (this.date + 50L > Time.getDate()) {
            return;
        }
        this.date = Time.getDate();
        boolean changes = false;
        StackWrapper stack = this.inventory.get(0);
        if (Fuel.isFuelItem(stack)) {
            boolean pass = false;
            Fuel fuel = Fuel.getStoredType(stack);
            if (fuel != null) {
                for (String str : this.vehicle.data.getFuelGroup()) {
                    if (!fuel.primary.equals(str)) continue;
                    pass = true;
                    break;
                }
            }
            if (!pass) {
                return;
            }
            int stored = Fuel.getStoredAmount(stack);
            if (stored > 0) {
                boolean considerempty = this.vehicle.data.getAttribute("fuel_stored").asInteger() <= 1000;
                int in = this.vehicle.data.getAttribute("fuel_stored").asInteger();
                int cantake = this.vehicle.data.getAttribute("fuel_capacity").asInteger() - in;
                if (cantake < stored) {
                    stored = cantake;
                }
                if (stored > 100) {
                    stored = 100;
                }
                if (stored > 0) {
                    Fuel.extract(stack, stored);
                    this.vehicle.data.getAttribute("fuel_stored").increase(stored);
                    changes = true;
                    boolean morechanges = false;
                    if (this.vehicle.data.getAttribute("fuel_primary").asString().length() == 0) {
                        this.vehicle.data.getAttribute("fuel_primary").set(fuel.getPrimaryGroup());
                        morechanges = true;
                    }
                    Attribute<?> seco = this.vehicle.data.getAttribute("fuel_secondary");
                    Attribute<?> qual = this.vehicle.data.getAttribute("fuel_quality");
                    if (!seco.asString().equals(fuel.secondary)) {
                        seco.set(considerempty ? fuel.secondary : "mixed");
                        morechanges = true;
                    }
                    float oldqual = qual.asFloat();
                    int stor = this.vehicle.data.getAttribute("fuel_stored").asInteger();
                    if (!considerempty) {
                        if (fuel.quality != oldqual) {
                            float per0 = in / stor;
                            float per1 = stored / stor;
                            qual.set(Float.valueOf(per0 * oldqual + per1 * fuel.quality));
                        }
                        if (!morechanges) {
                            morechanges = qual.asFloat() != oldqual;
                        }
                    } else {
                        qual.set(Float.valueOf(fuel.quality));
                        morechanges = true;
                    }
                    if (morechanges) {
                        TagCW com = TagCW.create();
                        com.set("cargo", "update_fuel_data");
                        com.set("primary", this.vehicle.data.getAttribute("fuel_primary").asString());
                        com.set("secondary", seco.asString());
                        com.set("quality", qual.asFloat());
                        SEND_TO_CLIENT.accept(com, this.player);
                    }
                }
            }
        }
        if (!this.player.entity.isOnClient() && changes) {
            TagCW com = TagCW.create();
            com.set("cargo", "update_fuel_tank");
            com.set("state", this.vehicle.data.getAttributeInteger("fuel_stored", 0));
            TagCW is = TagCW.create();
            stack.save(is);
            com.set("stack", is);
            SEND_TO_CLIENT.accept(com, this.player);
        }
    }

    public void onClosed() {
        super.onClosed();
        if (this.player.entity.isOnClient()) {
            return;
        }
        if (this.inventory.empty(0)) {
            return;
        }
        try {
            this.player.entity.addStack(this.inventory.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

