/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.mod.fvtm.util.SaveUtils;
import net.fexcraft.mod.uni.tag.TagCW;
import org.lwjgl.opengl.GL11;

public class Rot {
    public static final Rot NULL = new Rot();
    private final V3D vec;
    public boolean nell;

    public Rot() {
        this.vec = new V3D();
        this.check();
    }

    public Rot(double x, double y, double z) {
        this.vec = new V3D(x, y, z);
        this.check();
    }

    public Rot(V3D vec) {
        this.vec = vec;
        this.check();
    }

    public Rot(JsonArray array) {
        this(SaveUtils.loadV3D(array));
    }

    private void check() {
        this.nell = this.vec.x == 0.0 && this.vec.y == 0.0 && this.vec.z == 0.0;
    }

    public void toTag(String key, TagCW compound) {
        if (this.isNull()) {
            return;
        }
        compound.set(key, SaveUtils.saveV3D(this.vec));
    }

    public boolean isNull() {
        return this.nell;
    }

    public static Rot fromTag(String key, TagCW compound) {
        if (!compound.has(key)) {
            return new Rot();
        }
        V3D vec = SaveUtils.loadV3D(compound.getList(key));
        return new Rot(vec);
    }

    public static Rot fromJson(JsonMap map, String key) {
        if (!map.has(key) || !map.get(key).isArray()) {
            return new Rot();
        }
        return new Rot(SaveUtils.loadV3D(map.getArray(key)));
    }

    public JsonArray toJson() {
        return SaveUtils.saveV3DJson(this.vec);
    }

    public void rotate112() {
        if (this.nell) {
            return;
        }
        if (this.vec.y != 0.0) {
            GL11.glRotated((double)this.vec.y, (double)0.0, (double)1.0, (double)0.0);
        }
        if (this.vec.x != 0.0) {
            GL11.glRotated((double)this.vec.x, (double)1.0, (double)0.0, (double)0.0);
        }
        if (this.vec.z != 0.0) {
            GL11.glRotated((double)this.vec.z, (double)0.0, (double)0.0, (double)1.0);
        }
    }

    public void rotate112R() {
        if (this.nell) {
            return;
        }
        if (this.vec.z != 0.0) {
            GL11.glRotated((double)(-this.vec.z), (double)0.0, (double)0.0, (double)1.0);
        }
        if (this.vec.x != 0.0) {
            GL11.glRotated((double)(-this.vec.x), (double)1.0, (double)0.0, (double)0.0);
        }
        if (this.vec.y != 0.0) {
            GL11.glRotated((double)(-this.vec.y), (double)0.0, (double)1.0, (double)0.0);
        }
    }

    public void set(Vec3f rot) {
        this.vec.x = rot.x;
        this.vec.y = rot.y;
        this.vec.z = rot.z;
        this.check();
    }

    public Rot add(Rot other) {
        return new Rot(this.vec.add(other.vec));
    }

    public V3D vec() {
        return this.vec;
    }
}

