/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm;

import java.util.UUID;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.world.MessageSender;

public abstract class FvtmLogger {
    public static UUID NULL_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static FvtmLogger LOGGER = null;
    public static final MessageSender LOG = new MessageSender(){

        public void send(String s) {
            FvtmLogger.log((Object)s);
        }

        public void send(String str, Object ... args) {
            FvtmLogger.log(str, args);
        }

        public void bar(String s) {
            FvtmLogger.log((Object)s);
        }

        public void bar(String str, Object ... args) {
            FvtmLogger.log(str, args);
        }

        public String getName() {
            return "LOG";
        }

        public UUID getUUID() {
            return NULL_UUID;
        }
    };
    public static final MessageSender DEVLOG = new MessageSender(){

        public void send(String s) {
            if (EnvInfo.DEV) {
                FvtmLogger.log((Object)s);
            }
        }

        public void send(String str, Object ... args) {
            if (EnvInfo.DEV) {
                FvtmLogger.log(str, args);
            }
        }

        public void bar(String s) {
            if (EnvInfo.DEV) {
                FvtmLogger.log((Object)s);
            }
        }

        public void bar(String str, Object ... args) {
            if (EnvInfo.DEV) {
                FvtmLogger.log(str, args);
            }
        }

        public String getName() {
            return "DEVLOG";
        }

        public UUID getUUID() {
            return NULL_UUID;
        }
    };
    public static final MessageSender NONE = new MessageSender(){

        public void send(String s) {
        }

        public void send(String str, Object ... args) {
        }

        public void bar(String s) {
        }

        public void bar(String str, Object ... args) {
        }

        public String getName() {
            return "NONE";
        }

        public UUID getUUID() {
            return NULL_UUID;
        }
    };

    protected abstract void log0(Object var1);

    public void info(String s) {
        this.log0(s);
    }

    public static void log(Object o) {
        LOGGER.log0(o);
    }

    public static void log(Iterable<?> it) {
        LOGGER.log0("#[");
        for (Object o : it) {
            LOGGER.log0(it);
        }
        LOGGER.log0("]#");
    }

    public static void log(Object ... os) {
        LOGGER.log0("@[");
        for (Object o : os) {
            LOGGER.log0(o);
        }
        LOGGER.log0("]@");
    }

    public static void debug(Object o) {
        if (EnvInfo.DEV) {
            LOGGER.log0(o);
        }
    }

    public static void debug(Object ... os) {
        LOGGER.log0("DEBUG:[");
        for (Object o : os) {
            LOGGER.log0(o);
        }
        LOGGER.log0("]");
    }

    public static void marker(Object o) {
        if (EnvInfo.DEV) {
            LOGGER.log0("MARKER " + o);
        }
    }

    public static void marker(Object ... os) {
        if (EnvInfo.DEV) {
            StringBuilder str = new StringBuilder();
            for (Object o : os) {
                str.append(o + " ");
            }
            LOGGER.log0("MARKER " + str);
        }
    }

    public static void log(Throwable e, String info) {
        LOGGER.log0("ERROR: " + e.getMessage() + " / " + e.getCause() + " @ " + info);
        for (StackTraceElement elm : e.getStackTrace()) {
            LOGGER.log0(elm);
        }
    }
}

