/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.block;

import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.mc.api.packet.IPacketReceiver;
import net.fexcraft.lib.mc.network.PacketHandler;
import net.fexcraft.lib.mc.network.packet.PacketTileEntityUpdate;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.block.ContainerBlock;
import net.fexcraft.mod.fvtm.data.container.Container;
import net.fexcraft.mod.fvtm.data.container.ContainerData;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.fvtm.item.ContainerItem;
import net.fexcraft.mod.uni.impl.TagCWI;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class ContainerEntity
extends TileEntity
implements IPacketReceiver<PacketTileEntityUpdate> {
    private boolean core = false;
    private boolean setup = false;
    private ContainerData container = null;
    private BlockPos corepos = null;
    private ContainerEntity coretile = null;
    private ContainerEntity corr;

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("Core", this.core);
        if (this.core && this.container != null) {
            this.container.write(compound);
        }
        if (!this.core && this.corepos != null) {
            compound.func_74772_a("CorePos", this.corepos.func_177986_g());
        }
        compound.func_74757_a("SetUp", this.setup);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.core = compound.func_74767_n("Core");
        if (this.core && compound.func_74764_b("Container")) {
            this.container = FvtmResources.getContainerData(compound);
        }
        if (!this.core) {
            this.corepos = BlockPos.func_177969_a((long)compound.func_74763_f("CorePos"));
        }
        this.setup = compound.func_74767_n("SetUp");
        if (!this.core && this.setup && this.corepos == null) {
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
        }
    }

    protected ContainerEntity getCore() {
        return this.core ? this : (this.coretile == null ? (this.coretile = this.corepos == null ? null : (ContainerEntity)this.field_145850_b.func_175625_s(this.corepos)) : this.coretile);
    }

    public ContainerData getContainerData() {
        this.corr = this.getCore();
        return this.corr == null ? null : this.corr.container;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing != null && facing.func_176740_k().func_176720_b() && this.getCore() != null && this.getCore().container != null && !this.isLocked()) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.getCore().container.getInventory().type.isItem() && this.getCore().container.getInventory().capacity() > 0;
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.getCore().container.getInventory().type.isFluid();
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getCore().container.getInventory().type.isItem()) {
            return (T)this.getCore().container.getInventory().getStackHandler();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getCore().container.getInventory().type.isFluid()) {
            return (T)this.getCore().container.getInventory().getTank();
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isCore() {
        return this.core;
    }

    public BlockPos getCorePos() {
        return this.core ? this.field_174879_c : this.corepos;
    }

    public void setUp(ItemStack stack) {
        BlockPos core = BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("PlacedPos"));
        this.core = this.field_174879_c.equals((Object)core);
        if (this.core) {
            this.container = ((ContainerItem)stack.func_77973_b()).getData(TagCW.wrap((Object)stack.func_77978_p()));
            Print.debug((Object)this.container.write(new NBTTagCompound()).toString());
        } else {
            this.corepos = core;
        }
        this.setup = true;
        Print.debug((Object)("CONTESETUP: " + this.field_174879_c.toString() + " OK;"));
    }

    public void notifyBreak(World world, BlockPos pos, IBlockState state, boolean asplayer) {
        if (this.getCore() == null) {
            return;
        }
        ContainerEntity core = this.getCore();
        if (core.container == null) {
            return;
        }
        ContainerBlock.getPositions(core.container, core.field_174879_c, (EnumFacing)state.func_177229_b((IProperty)ContainerBlock.FACING)).forEach(blkpos -> {
            if (!asplayer) {
                core.container = null;
            }
            if (this.core && blkpos.equals((Object)core.field_174879_c) && asplayer) {
                if (core.container != null) {
                    EntityItem ent = new EntityItem(world);
                    ent.func_70107_b((double)blkpos.func_177958_n() + 0.5, (double)blkpos.func_177956_o() + 1.5, (double)blkpos.func_177952_p() + 0.5);
                    ent.func_92058_a((ItemStack)core.container.getNewStack().local());
                    world.func_72838_d((Entity)ent);
                    core.container = null;
                }
                if (Config.VEHICLES_DROP_CONTENTS && !world.field_72995_K) {
                    this.getContainerData().getInventory().dropAllAt(WrapperHolder.getWorld((Object)world), new V3I(blkpos.func_177958_n(), blkpos.func_177956_o(), blkpos.func_177952_p()));
                }
            }
            if (!asplayer || !blkpos.equals((Object)pos)) {
                world.func_180501_a(blkpos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * 8.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean isLocked() {
        return this.getContainerData().getLock().isLocked();
    }

    public void processClientPacket(PacketTileEntityUpdate packet) {
        if (packet.nbt.func_74764_b("task")) {
            switch (packet.nbt.func_74779_i("task")) {
                case "update_container_inventory": {
                    if (this.getContainerData() == null) break;
                    this.getContainerData().getInventory().load((TagCW)new TagCWI(packet.nbt), "state");
                }
            }
        } else {
            this.func_145839_a(packet.nbt);
        }
    }

    public void sendInvUpdate(EntityPlayer player) {
        if (player == null) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("task", "update_container_inventory");
        this.getContainerData().getInventory().save((TagCW)new TagCWI(nbt), "state");
        PacketHandler.getInstance().sendTo((IMessage)new PacketTileEntityUpdate(player.field_71093_bK, this.func_174877_v(), nbt), (EntityPlayerMP)player);
    }

    public InvType getInventoryType() {
        return this.getContainerData() == null ? null : ((Container)this.getContainerData().getType()).getInventoryType();
    }
}

