/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.block;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.mod.fvtm.block.generated.FvtmProperties;
import net.fexcraft.mod.fvtm.block.generated.G_POSTLIKE;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StreetPost
extends BlockFence {
    public static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.25, 0.375, 0.625, 0.75, 0.625), new AxisAlignedBB(0.375, 0.25, 0.375, 0.625, 0.75, 1.0), new AxisAlignedBB(0.0, 0.25, 0.375, 0.625, 0.75, 0.625), new AxisAlignedBB(0.0, 0.25, 0.375, 0.625, 0.75, 1.0), new AxisAlignedBB(0.375, 0.25, 0.0, 0.625, 0.75, 0.625), new AxisAlignedBB(0.375, 0.25, 0.0, 0.625, 0.75, 1.0), new AxisAlignedBB(0.0, 0.25, 0.0, 0.625, 0.75, 0.625), new AxisAlignedBB(0.0, 0.25, 0.0, 0.625, 0.75, 1.0), new AxisAlignedBB(0.375, 0.25, 0.375, 1.0, 0.75, 0.625), new AxisAlignedBB(0.375, 0.25, 0.375, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.25, 0.375, 1.0, 0.75, 0.625), new AxisAlignedBB(0.0, 0.25, 0.375, 1.0, 0.75, 1.0), new AxisAlignedBB(0.375, 0.25, 0.0, 1.0, 0.75, 0.625), new AxisAlignedBB(0.375, 0.25, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 0.75, 0.625), new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 0.75, 1.0)};
    public static final AxisAlignedBB PILLAR_AABB = new AxisAlignedBB(0.375, 0.25, 0.375, 0.625, 0.75, 0.625);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.375, 0.25, 0.625, 0.625, 0.75, 1.0);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.25, 0.375, 0.375, 0.75, 0.625);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.375, 0.25, 0.0, 0.625, 0.75, 0.375);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.625, 0.25, 0.375, 1.0, 0.75, 0.625);

    public StreetPost() {
        super(Material.field_151573_f, MapColor.field_151670_w);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(50.0f);
        this.func_149752_b(280.0f);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        StreetPost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PILLAR_AABB);
        if (((Boolean)state.func_177229_b((IProperty)field_176526_a)).booleanValue()) {
            StreetPost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176525_b)).booleanValue()) {
            StreetPost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176527_M)).booleanValue()) {
            StreetPost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176528_N)).booleanValue()) {
            StreetPost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return BOUNDING_BOXES[StreetPost.getBoundingBoxIdx(state)];
    }

    private static int getBoundingBoxIdx(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)field_176526_a)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176525_b)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176527_M)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176528_N)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)field_176526_a, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)field_176525_b, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)field_176527_M, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)field_176528_N, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos, EnumFacing.WEST))).func_177226_a((IProperty)FvtmProperties.UP, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos, EnumFacing.UP))).func_177226_a((IProperty)FvtmProperties.DOWN, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos, EnumFacing.DOWN))).func_177226_a((IProperty)FvtmProperties.BASE, (Comparable)Boolean.valueOf(StreetPost.isSolidUnder(worldIn, pos, state)));
    }

    public static boolean isSolidUnder(IBlockAccess world, BlockPos pos, IBlockState state) {
        BlockPos offset = pos.func_177972_a(EnumFacing.DOWN);
        IBlockState block = world.func_180495_p(offset);
        if (block.func_177230_c() instanceof G_POSTLIKE) {
            return false;
        }
        return block.isSideSolid(world, offset, EnumFacing.UP);
    }

    public boolean canConnect(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        Block block = world.func_180495_p(other).func_177230_c();
        return block instanceof BlockFence || block.canBeConnectedTo(world, other, facing.func_176734_d()) || block instanceof G_POSTLIKE || this.func_176524_e(world, other, facing.func_176734_d());
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.CENTER;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)field_176526_a, state.func_177229_b((IProperty)field_176527_M)).func_177226_a((IProperty)field_176525_b, state.func_177229_b((IProperty)field_176528_N)).func_177226_a((IProperty)field_176527_M, state.func_177229_b((IProperty)field_176526_a)).func_177226_a((IProperty)field_176528_N, state.func_177229_b((IProperty)field_176525_b));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)field_176526_a, state.func_177229_b((IProperty)field_176525_b)).func_177226_a((IProperty)field_176525_b, state.func_177229_b((IProperty)field_176527_M)).func_177226_a((IProperty)field_176527_M, state.func_177229_b((IProperty)field_176528_N)).func_177226_a((IProperty)field_176528_N, state.func_177229_b((IProperty)field_176526_a));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)field_176526_a, state.func_177229_b((IProperty)field_176528_N)).func_177226_a((IProperty)field_176525_b, state.func_177229_b((IProperty)field_176526_a)).func_177226_a((IProperty)field_176527_M, state.func_177229_b((IProperty)field_176525_b)).func_177226_a((IProperty)field_176528_N, state.func_177229_b((IProperty)field_176527_M));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)field_176526_a, state.func_177229_b((IProperty)field_176527_M)).func_177226_a((IProperty)field_176527_M, state.func_177229_b((IProperty)field_176526_a));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)field_176525_b, state.func_177229_b((IProperty)field_176528_N)).func_177226_a((IProperty)field_176528_N, state.func_177229_b((IProperty)field_176525_b));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176526_a, field_176525_b, field_176528_N, field_176527_M, FvtmProperties.UP, FvtmProperties.DOWN, FvtmProperties.BASE});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() instanceof ItemLead) {
                ItemLead.func_180618_a((EntityPlayer)player, (World)world, (BlockPos)pos);
                return true;
            }
            return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        }
        return true;
    }
}

