/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.block.generated;

import net.fexcraft.lib.common.Static;
import net.fexcraft.mod.fvtm.block.generated.BlockBase;
import net.fexcraft.mod.fvtm.block.generated.BlockTileEntity;
import net.fexcraft.mod.fvtm.block.generated.JunctionTrackingTileEntity;
import net.fexcraft.mod.fvtm.sys.rail.EntryDirection;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.nbt.NBTTagCompound;

public class SignalTileEntity
extends BlockTileEntity
implements JunctionTrackingTileEntity {
    protected QV3D juncpos;
    protected Junction junction;
    protected EntryDirection dir = EntryDirection.FORWARD;

    public SignalTileEntity() {
    }

    public SignalTileEntity(BlockBase type) {
        super(type);
    }

    public int getSignalState() {
        return this.getJunction() == null ? -1 : (this.junction.getSignalState(this.dir) ? 1 : 0);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.juncpos != null) {
            this.juncpos.write(TagCW.wrap((Object)compound), "junction");
            compound.func_74774_a("direction", this.dir.getSaveByte());
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("junction")) {
            this.juncpos = new QV3D(TagCW.wrap((Object)compound), "junction");
            this.dir = EntryDirection.getFromSaveByte(compound.func_74771_c("direction"));
        } else {
            this.juncpos = null;
            this.junction = null;
            this.dir = EntryDirection.FORWARD;
        }
    }

    @Override
    public void setJunction(QV3D vec) {
        this.juncpos = vec;
        this.linkJunction(this.field_145850_b, this.field_174879_c, vec);
        this.sendUpdate();
    }

    @Override
    public Junction getJunction() {
        if (this.junction == null && this.juncpos != null && this.field_174879_c != null) {
            RailSystem sys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)this.field_145850_b));
            if (sys != null) {
                this.junction = sys.getJunction(this.juncpos.pos, false);
            }
            if (this.junction == null) {
                this.juncpos = null;
                Static.stop();
            } else {
                this.junction.addLinkedTileEntity(WrapperHolder.mutPos((Object)this.field_174879_c));
            }
        }
        return this.junction;
    }

    @Override
    public QV3D getJuncPos() {
        return this.juncpos;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.junction != null) {
            this.junction.entities.remove(this.field_174879_c);
        }
    }

    @Override
    public void updateSignalState() {
        if (this.field_145850_b == null || this.getJunction() == null) {
            return;
        }
        this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
    }

    @Override
    public void toggleDirection() {
        this.dir = this.dir.toggle();
        this.sendUpdate();
    }

    @Override
    public EntryDirection getDirection() {
        return this.dir;
    }

    public String getValidatedJunctionStatus() {
        if (this.dir.isForward() ? this.junction.sigtype1.any() : this.junction.sigtype0.any()) {
            return this.junction.getSignalState(this.dir) ? "&agreen" : "&cred";
        }
        return "&einvalid signal direction for this junction";
    }

    @Override
    public boolean isSignal() {
        return true;
    }

    public long getSectionId() {
        if (this.getJunction() == null) {
            return 0L;
        }
        return this.junction.tracks.get(this.dir.getTrackId()).getUnit().getSectionId();
    }
}

