/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import java.util.Map;
import java.util.TreeMap;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.data.ContentData;
import net.fexcraft.mod.fvtm.data.Decoration;
import net.fexcraft.mod.fvtm.data.root.Colorable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.uni.Pos;
import net.fexcraft.mod.uni.tag.TagCW;

public class DecorationData
extends ContentData<Decoration, DecorationData>
implements Textureable.TextureUser,
Colorable {
    private TreeMap<String, RGB> channels = new TreeMap();
    protected Textureable texture;
    public Pos offset = new Pos(0.0f, 0.0f, 0.0f);
    public float rotx;
    public float roty;
    public float rotz;
    public float sclx = 1.0f;
    public float scly = 1.0f;
    public float sclz = 1.0f;
    public int size = 8;

    public DecorationData(Decoration deco) {
        super(deco);
        this.texture = new Textureable(deco);
        for (Map.Entry<String, RGB> entry : ((Decoration)this.type).getDefaultColorChannels().entrySet()) {
            this.channels.put(entry.getKey(), entry.getValue().copy());
        }
    }

    @Override
    public RGB getColorChannel(String channel) {
        return this.channels.get(channel);
    }

    @Override
    public void setColorChannel(String channel, RGB color) {
        this.channels.put(channel, color);
    }

    public TreeMap<String, RGB> getColorChannels() {
        return this.channels;
    }

    @Override
    public TagCW write(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        compound.set("Decoration", ((Decoration)this.type).getID().toString());
        compound.set("offx", this.offset.x);
        compound.set("offy", this.offset.y);
        compound.set("offz", this.offset.z);
        if (this.rotx != 0.0f) {
            compound.set("rotx", this.rotx);
        }
        if (this.roty != 0.0f) {
            compound.set("roty", this.roty);
        }
        if (this.rotz != 0.0f) {
            compound.set("rotz", this.rotz);
        }
        if (this.sclx != 1.0f) {
            compound.set("sclx", this.sclx);
        }
        if (this.scly != 1.0f) {
            compound.set("scly", this.scly);
        }
        if (this.sclz != 1.0f) {
            compound.set("sclz", this.sclz);
        }
        this.texture.save(compound);
        for (String str : this.channels.keySet()) {
            compound.set("rgb_" + str, this.channels.get((Object)str).packed);
        }
        return compound;
    }

    @Override
    public DecorationData read(TagCW compound) {
        if (compound == null || compound.empty()) {
            if (((Decoration)this.type).randomtex) {
                this.texture.setSelectedTexture(((Decoration)this.type).getDefaultTextures().size(), null, false);
            }
            return this;
        }
        this.offset = new Pos(compound.getFloat("offx"), compound.getFloat("offy"), compound.getFloat("offz"));
        if (compound.has("rotx")) {
            this.rotx = compound.getFloat("rotx");
        }
        if (compound.has("roty")) {
            this.roty = compound.getFloat("roty");
        }
        if (compound.has("rotz")) {
            this.rotz = compound.getFloat("rotz");
        }
        if (compound.has("sclx")) {
            this.sclx = compound.getFloat("sclx");
        }
        if (compound.has("scly")) {
            this.scly = compound.getFloat("scly");
        }
        if (compound.has("sclz")) {
            this.sclz = compound.getFloat("sclz");
        }
        this.texture.load(compound);
        for (String str : this.channels.keySet()) {
            if (!compound.has("rgb_" + str)) continue;
            this.channels.get((Object)str).packed = compound.getInteger("rgb_" + str);
        }
        return this;
    }

    @Override
    public DecorationData parse(JsonMap map) {
        return this;
    }

    @Override
    public JsonMap toJson() {
        return new JsonMap();
    }

    @Override
    public Textureable getTexture() {
        return this.texture;
    }

    @Override
    public Textureable.TextureHolder getTexHolder() {
        return (Textureable.TextureHolder)((Object)this.type);
    }
}

