/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import java.text.ParseException;
import java.util.Map;
import java.util.TreeMap;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.ContentData;
import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.root.Colorable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.UIField;

public class SignData
extends ContentData<Sign, SignData>
implements Textureable.TextureUser,
Colorable {
    private TreeMap<String, RGB> channels = new TreeMap();
    protected Textureable texture;
    public V3D offset = new V3D(0.0, 0.0, 0.0);
    public float rotx;
    public float roty;
    public float rotz;
    public float sclx = 1.0f;
    public float scly = 1.0f;
    public float sclz = 1.0f;
    public String text;
    public String form;
    public boolean centered;
    public boolean[] sides;
    public float width;
    public float height;

    public SignData(Sign sign) {
        super(sign);
        this.texture = new Textureable(sign);
        for (Map.Entry<String, RGB> entry : ((Sign)this.type).getDefaultColorChannels().entrySet()) {
            this.channels.put(entry.getKey(), entry.getValue().copy());
        }
        if (sign.isText()) {
            this.text = this.form = sign.text;
        }
        if (sign.isBase()) {
            this.sides = new boolean[4];
        }
        this.height = 1.0f;
        this.width = 1.0f;
    }

    @Override
    public RGB getColorChannel(String channel) {
        return this.channels.get(channel);
    }

    @Override
    public void setColorChannel(String channel, RGB color) {
        this.channels.put(channel, color);
    }

    public TreeMap<String, RGB> getColorChannels() {
        return this.channels;
    }

    @Override
    public TagCW write(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        compound.set("Sign", ((Sign)this.type).getID().toString());
        compound.set("offx", this.offset.x);
        compound.set("offy", this.offset.y);
        compound.set("offz", this.offset.z);
        if (this.rotx != 0.0f) {
            compound.set("rotx", this.rotx);
        }
        if (this.roty != 0.0f) {
            compound.set("roty", this.roty);
        }
        if (this.rotz != 0.0f) {
            compound.set("rotz", this.rotz);
        }
        if (this.sclx != 1.0f) {
            compound.set("sclx", this.sclx);
        }
        if (this.scly != 1.0f) {
            compound.set("scly", this.scly);
        }
        if (this.sclz != 1.0f) {
            compound.set("sclz", this.sclz);
        }
        this.texture.save(compound);
        for (String str : this.channels.keySet()) {
            compound.set("rgb_" + str, this.channels.get((Object)str).packed);
        }
        if (((Sign)this.type).isText()) {
            compound.set("text", this.text);
            compound.set("form", this.form);
            if (this.centered) {
                compound.set("centered", true);
            }
        }
        if (((Sign)this.type).isBase()) {
            for (int i = 0; i < this.sides.length; ++i) {
                if (!this.sides[i]) continue;
                compound.set("side" + i, this.sides[i]);
            }
            if (this.width != 1.0f) {
                compound.set("width", this.width);
            }
            if (this.height != 1.0f) {
                compound.set("height", this.height);
            }
        }
        return compound;
    }

    @Override
    public SignData read(TagCW compound) {
        this.offset.x = compound.getDouble("offx");
        this.offset.y = compound.getDouble("offy");
        this.offset.z = compound.getDouble("offz");
        if (compound.has("rotx")) {
            this.rotx = compound.getFloat("rotx");
        }
        if (compound.has("roty")) {
            this.roty = compound.getFloat("roty");
        }
        if (compound.has("rotz")) {
            this.rotz = compound.getFloat("rotz");
        }
        if (compound.has("sclx")) {
            this.sclx = compound.getFloat("sclx");
        }
        if (compound.has("scly")) {
            this.scly = compound.getFloat("scly");
        }
        if (compound.has("sclz")) {
            this.sclz = compound.getFloat("sclz");
        }
        this.texture.load(compound);
        for (String str : this.channels.keySet()) {
            if (!compound.has("rgb_" + str)) continue;
            this.channels.get((Object)str).packed = compound.getInteger("rgb_" + str);
        }
        if (((Sign)this.type).isText()) {
            this.text = compound.getString("text");
            this.form = compound.getString("form");
            this.centered = compound.getBoolean("centered");
        }
        if (((Sign)this.type).isBase()) {
            if (this.sides == null) {
                this.sides = new boolean[4];
            }
            for (int i = 0; i < this.sides.length; ++i) {
                if (!compound.has("side" + i)) continue;
                this.sides[i] = compound.getBoolean("side" + i);
            }
            this.width = compound.has("width") ? compound.getFloat("width") : 1.0f;
            this.height = compound.has("height") ? compound.getFloat("height") : 1.0f;
        }
        return this;
    }

    @Override
    public SignData parse(JsonMap map) {
        JsonArray arr = null;
        if (map.has("off")) {
            arr = map.getArray("off");
            this.offset.x = arr.get(0).float_value();
            this.offset.y = arr.get(1).float_value();
            this.offset.z = arr.get(2).float_value();
        }
        if (map.has("rot")) {
            arr = map.getArray("rot");
            this.rotx = arr.get(0).float_value();
            this.roty = arr.get(1).float_value();
            this.rotz = arr.get(2).float_value();
        }
        if (map.has("scl")) {
            arr = map.getArray("scl");
            this.sclx = arr.get(0).float_value();
            this.scly = arr.get(1).float_value();
            this.sclz = arr.get(2).float_value();
        }
        this.texture.load(map);
        if (map.has("rgb")) {
            JsonMap rgb = map.getMap("rgb");
            for (Map.Entry entry : rgb.entries()) {
                int col = Integer.parseInt(((JsonValue)entry.getValue()).string_value(), 16);
                if (this.channels.containsKey(entry.getKey())) {
                    this.channels.get(entry.getKey()).packed = col;
                    continue;
                }
                this.channels.put((String)entry.getKey(), new RGB(col));
            }
        }
        if (((Sign)this.type).isText()) {
            this.form = map.getString("form", this.form);
            this.text = map.getString("text", this.form);
            this.centered = map.getBoolean("center", false);
        }
        if (((Sign)this.type).isBase()) {
            String sd = map.getString("sides", "0000");
            for (int i = 0; i < (sd.length() > 4 ? 4 : sd.length()); ++i) {
                this.sides[i] = sd.charAt(i) == '1';
            }
            this.width = map.getFloat("width", 1.0f);
            this.height = map.getFloat("height", 1.0f);
        }
        return this;
    }

    @Override
    public JsonMap toJson() {
        JsonMap sub;
        JsonMap map = new JsonMap();
        map.add("type", ((Sign)this.type).getIDS());
        if (!this.offset.isNull()) {
            map.add("off", (JsonValue)new JsonArray.Flat(new Object[]{Float.valueOf(this.f(this.offset.x)), Float.valueOf(this.f(this.offset.y)), Float.valueOf(this.f(this.offset.z))}));
        }
        if (this.rotx != 0.0f || this.roty != 0.0f || this.rotz != 0.0f) {
            map.add("rot", (JsonValue)new JsonArray.Flat(new Object[]{Float.valueOf(this.f(Float.valueOf(this.rotx))), Float.valueOf(this.f(Float.valueOf(this.roty))), Float.valueOf(this.f(Float.valueOf(this.rotz)))}));
        }
        if (this.sclx != 1.0f || this.scly != 1.0f || this.sclz != 1.0f) {
            map.add("scl", (JsonValue)new JsonArray.Flat(new Object[]{Float.valueOf(this.f(Float.valueOf(this.sclx))), Float.valueOf(this.f(Float.valueOf(this.scly))), Float.valueOf(this.f(Float.valueOf(this.sclz)))}));
        }
        if (!(sub = this.texture.save()).empty()) {
            map.add("tex", (JsonValue)sub);
        }
        sub = new JsonMap();
        for (String str : this.channels.keySet()) {
            if (this.channels.get((Object)str).packed == ((Sign)this.type).getDefaultColorChannels().get((Object)str).packed) continue;
            sub.add(str, Integer.toHexString(this.channels.get((Object)str).packed));
        }
        if (!sub.empty()) {
            map.add("rgb", (JsonValue)sub);
        }
        if (((Sign)this.type).isText()) {
            if (!this.text.equals(this.form)) {
                map.add("text", this.text);
            }
            map.add("form", this.form);
            if (this.centered) {
                map.add("center", true);
            }
        }
        if (((Sign)this.type).isBase()) {
            boolean any = false;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.sides.length; ++i) {
                sb.append(this.sides[i] ? "1" : "0");
                if (!this.sides[i]) continue;
                any = true;
            }
            if (any) {
                map.add("sides", sb.toString());
            }
            if (this.width != 1.0f) {
                map.add("width", this.width);
            }
            if (this.height != 1.0f) {
                map.add("height", this.height);
            }
        }
        return map;
    }

    private float f(Number v) {
        try {
            return UIField.nf.parse(UIField.df.format(v)).floatValue();
        }
        catch (ParseException e) {
            return v.floatValue();
        }
    }

    @Override
    public Textureable getTexture() {
        return this.texture;
    }

    @Override
    public Textureable.TextureHolder getTexHolder() {
        return (Textureable.TextureHolder)((Object)this.type);
    }
}

