/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.attribute;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.data.attribute.AttrValueType;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.uni.tag.TagCW;

public class AttrBoolean
extends Attribute<Boolean> {
    public AttrBoolean(String id, JsonMap map) {
        this(id, map.getBoolean("value", false));
    }

    public AttrBoolean(String aid, Boolean val) {
        super(aid, AttrValueType.BOOLEAN, val);
    }

    @Override
    public Boolean validate(Object val) {
        return val == null ? false : Boolean.parseBoolean(val.toString());
    }

    @Override
    public Boolean parse(String val) {
        return Boolean.parseBoolean(val);
    }

    @Override
    public void increase(float by) {
        this.value = true;
    }

    @Override
    public void decrease(float by) {
        this.value = false;
    }

    @Override
    public String type() {
        return "boolean";
    }

    @Override
    public void saveValue(TagCW com) {
        com.set(this.id, ((Boolean)this.value).booleanValue());
    }

    @Override
    public void loadValue(TagCW com) {
        this.value = com.getBoolean(this.id);
    }

    @Override
    public Attribute<Boolean> newInstance() {
        return new AttrBoolean(this.id, (Boolean)this.initial);
    }

    @Override
    public int asInteger() {
        return (Boolean)this.value != false ? 1 : 0;
    }

    @Override
    public long asLong() {
        return (Boolean)this.value != false ? 1L : 0L;
    }

    @Override
    public float asFloat() {
        return (Boolean)this.value != false ? 1.0f : 0.0f;
    }

    @Override
    public String asString() {
        return this.value + "";
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)this.value;
    }
}

