/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.inv;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.data.inv.FvtmInv;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniInventory;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;

public class FvtmInvItems
extends FvtmInv {
    public UniInventory items;
    public int rows;
    public int cols;

    public FvtmInvItems() {
        super(InvType.ITEM);
    }

    public FvtmInvItems init(JsonMap map) {
        this.rows = map.getInteger("rows", 1);
        this.cols = map.getInteger("cols", 1);
        if (this.rows < 1) {
            this.rows = 1;
        }
        if (this.rows > 7) {
            this.rows = 7;
        }
        if (this.cols < 1) {
            this.cols = 1;
        }
        if (this.cols > 9) {
            this.cols = 9;
        }
        this.items = UniInventory.create((int)(this.rows * this.cols));
        if (map.has("filter")) {
            // empty if block
        }
        this.init0(map);
        return this;
    }

    @Override
    public TagCW save(TagCW compound, String ctag) {
        TagCW stacks = TagCW.create();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                int idx = r * this.cols + c;
                StackWrapper stack = this.items.get(idx);
                if (stack == null || stack.empty()) continue;
                TagCW com = TagCW.create();
                stack.save(com);
                stacks.set("s" + idx, com);
            }
        }
        if (stacks.size() > 0) {
            compound.set(ctag == null ? "Items" : ctag, stacks);
        }
        return compound;
    }

    @Override
    public void load(TagCW compound, String ctag) {
        this.items.clear();
        TagCW stacks = compound.getCompound(ctag == null ? "Items" : ctag);
        if (stacks.empty()) {
            return;
        }
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                StackWrapper stack;
                int idx = r * this.cols + c;
                if (!stacks.has("s" + idx) || (stack = UniStack.createStack((Object)stacks.getCompound("s" + idx))).empty()) continue;
                this.items.set(idx, stack);
            }
        }
    }

    @Override
    public void clearAt(EntityW entity) {
        for (int i = 0; i < this.items.size(); ++i) {
            StackWrapper stack = this.items.get(i);
            if (stack.empty()) continue;
            entity.drop(stack, 0.5f);
        }
        this.items.clear();
    }

    public FvtmInvItems copy() {
        FvtmInvItems inv = new FvtmInvItems();
        this.copy(inv);
        inv.rows = this.rows;
        inv.cols = this.cols;
        inv.items = UniInventory.create((int)(this.rows * this.cols));
        return inv;
    }
}

