/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.inv;

import java.util.ArrayList;
import net.fexcraft.lib.common.lang.FilledList;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.data.inv.InvHandler;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.fvtm.data.inv.StackEntry;
import net.fexcraft.mod.fvtm.data.inv.StackUtil;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;

public class InvHandlerVar
extends InvHandler {
    protected int value;
    protected int items;
    protected String concat;
    protected String conid;
    protected FilledList<StackWrapper> stacks;
    protected boolean in;
    private int i = 0;
    private int s = 0;

    public InvHandlerVar(String arg, int cap) {
        super(InvType.VARIABLE);
        String[] str = arg.split(":");
        this.conid = str[0];
        this.concat = str.length > 1 ? str[1] : "fluid";
        this.items = str.length > 2 ? Integer.parseInt(str[2]) : 1;
        this.in = str.length > 3 ? str[3].equals("in") : false;
        this.stacks = new FilledList(this.items, () -> StackWrapper.EMPTY, elm -> elm.empty());
        this.capacity = cap;
    }

    @Override
    public TagCW save(TagCW compound, String ctag) {
        compound.set(ctag, this.value());
        StackUtil.saveItems(compound, this.stacks, false, ctag + "-items");
        return compound;
    }

    @Override
    public void load(TagCW compound, String ctag) {
        this.value = compound.getInteger(ctag);
        if (compound.has(ctag + "-items")) {
            StackUtil.loadItems(compound, this.stacks, ctag + "-items");
        }
    }

    @Override
    public String getContentDesc() {
        return "";
    }

    @Override
    public String getSavePrefix() {
        return "var-";
    }

    @Override
    public ArrayList<StackEntry> getStacks() {
        return null;
    }

    @Override
    public <FT> FT getTank() {
        return null;
    }

    @Override
    public <ISH> ISH getStackHandler() {
        return null;
    }

    @Override
    public Object getCapability() {
        return this.value;
    }

    @Override
    public int getVarValue() {
        return this.value;
    }

    @Override
    public void setVarValue(int i) {
        this.value = i;
    }

    public int value() {
        return this.value;
    }

    public void value(int i) {
        this.value = i;
    }

    public void shrink(int by) {
        this.value -= by;
    }

    public void shrink() {
        --this.value;
    }

    public void grow(int by) {
        this.value += by;
    }

    public void grow() {
        ++this.value;
    }

    public int items() {
        return this.items;
    }

    public String content_id() {
        return this.conid;
    }

    public String container_cat() {
        return this.concat;
    }

    public StackWrapper stackAt(int index) {
        return (StackWrapper)this.stacks.get(index);
    }

    @Override
    public void update(Object otile, String key, boolean remote) {
        if (remote) {
            return;
        }
        if (this.in) {
            for (StackWrapper stack : this.stacks) {
                if (stack.empty() || stack.directTag().has("BlockFunction")) continue;
                BlockData data = FvtmResources.getBlockData(stack.directTag());
                stack.updateTag(tag -> data.write((TagCW)tag));
            }
        } else {
            for (StackWrapper stack : this.stacks) {
                if (!stack.empty()) continue;
            }
        }
    }
}

