/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.vehicle;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;

public class CatalogPreset {
    public final Map<String, String> parts = new LinkedHashMap<String, String>();
    public final Map<String, RGB> channels = new LinkedHashMap<String, RGB>();
    public final Map<String, Integer> recipe = new LinkedHashMap<String, Integer>();
    public final List<String> desc;
    public final Vehicle vehicle;
    public final String name;
    public final String id;
    public final float scale;

    public CatalogPreset(Vehicle root, String cid, JsonMap map) {
        this.vehicle = root;
        this.id = cid;
        this.name = map.getString("name", root.getName() + "(" + this.id + ")");
        this.desc = ContentConfigUtil.getStringList(map, "description");
        if (map.has("parts")) {
            map.getMap("parts").entries().forEach(entry -> this.parts.put((String)entry.getKey(), ((JsonValue)entry.getValue()).string_value()));
        }
        if (map.has("recipe") && map.get("recipe").isMap()) {
            for (Map.Entry entry2 : map.getMap("recipe").entries()) {
                int val = ((JsonValue)entry2.getValue()).integer_value();
                this.recipe.put((String)entry2.getKey(), val < 1 ? 1 : (val > 64 ? 64 : val));
            }
        }
        if (map.has("colors")) {
            map.getMap("colors").entries().forEach(entry -> this.channels.put((String)entry.getKey(), new RGB(((JsonValue)entry.getValue()).string_value())));
        }
        this.scale = map.getFloat("scale", 1.0f);
    }

    public String getDesc(int i) {
        if (this.desc.isEmpty()) {
            return i == 0 ? "ui.fvtm.vehicle_catalog.no_desc" : "";
        }
        if (i >= this.desc.size()) {
            return "";
        }
        return this.desc.get(i);
    }

    public VehicleData getVehicleData() {
        VehicleData data = new VehicleData(this.vehicle);
        for (Map.Entry<String, String> entry : this.parts.entrySet()) {
            try {
                Part part = FvtmRegistry.PARTS.get(entry.getValue());
                if (part == null) continue;
                data.installPart(FvtmLogger.NONE, new PartData(part), entry.getKey(), false);
            }
            catch (Exception e) {
                FvtmLogger.log(e, "catalog entry part install / " + entry);
            }
        }
        for (Map.Entry<String, String> entry : this.channels.entrySet()) {
            if (!data.channels.containsKey(entry.getKey())) continue;
            data.channels.get((Object)entry.getKey()).packed = ((RGB)entry.getValue()).packed;
        }
        return data;
    }
}

