/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.vehicle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.vehicle.DefaultSwivelPointMover;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPointMover;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.ZHydSwivelPointMover;
import net.fexcraft.mod.fvtm.packet.Packet_SPUpdate;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.fvtm.util.Pivot;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;

public class SwivelPoint {
    public static final String DEFAULT = "vehicle";
    public final String id;
    public final String rid;
    public String origin;
    public SwivelPoint parent;
    public V3D position;
    public V3D prevpos;
    private Pivot cpivot = new Pivot();
    private Pivot ppivot = new Pivot();
    public ArrayList<SwivelPoint> subs = new ArrayList();
    public boolean detached;
    private static final int ticker = 5;
    private int servticker;
    private V3D servpos;
    private V3D servrot;
    public ArrayList<SwivelPointMover> movers;

    public SwivelPoint(String id, JsonMap map) {
        this.id = id;
        this.position = map.has("pos") ? ContentConfigUtil.getVector(map.getArray("pos")) : new V3D();
        this.prevpos = this.position.copy();
        this.rid = map.getString("parent", DEFAULT);
        this.detached = map.getBoolean("detached", false);
        this.cpivot.set_rotation(map.getFloat("yaw", 0.0f), map.getFloat("pitch", 0.0f), map.getFloat("roll", 0.0f), true);
        if (map.has("movers")) {
            this.movers = new ArrayList();
            JsonValue movs = map.get("movers");
            if (movs.isMap()) {
                movs.asMap().entries().forEach(entry -> this.parseMover((String)entry.getKey(), (JsonValue)entry.getValue()));
            } else if (movs.isArray()) {
                ((List)movs.asArray().value).forEach(val -> this.parseMover(null, (JsonValue)val));
            }
        }
    }

    private void parseMover(String key, JsonValue json) {
        if (json.isMap()) {
            String type;
            JsonMap map = json.asMap();
            if (map.has("class")) {
                try {
                    Class<?> clazz = Class.forName(map.get("class").string_value().replace(".class", ""));
                    this.movers.add((SwivelPointMover)clazz.getConstructor(JsonValue.class).newInstance(map));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            switch (type = map.getString("type", "default")) {
                case "z_hyd": {
                    this.movers.add(new ZHydSwivelPointMover(map));
                    break;
                }
                default: {
                    this.movers.add(new DefaultSwivelPointMover(map));
                    break;
                }
            }
        } else if (!json.isArray()) {
            if (json.string_value().endsWith(".class")) {
                try {
                    Class<?> clazz = Class.forName(json.string_value().replace(".class", ""));
                    this.movers.add((SwivelPointMover)clazz.newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.movers.add(new DefaultSwivelPointMover(key == null ? "arrinit" : key, json.string_value()));
            }
        }
    }

    public SwivelPoint(String id, String rid) {
        this.id = id;
        this.rid = rid;
        this.position = new V3D();
        this.prevpos = new V3D();
    }

    public SwivelPoint(VehicleData data, String id, TagCW com) {
        this.id = id;
        this.rid = com.has("parent") ? com.getString("parent") : null;
        this.read(this, data, com);
    }

    public Pivot getPivot() {
        return this.cpivot;
    }

    public Pivot getPrevPivot() {
        return this.ppivot;
    }

    public void updatePrevAxe() {
        this.ppivot.copy(this.cpivot);
    }

    public void loadPivot(TagCW com) {
        this.cpivot = Pivot.load(com);
        this.updatePrevAxe();
    }

    public void savePivot(TagCW com) {
        this.cpivot.save(com);
    }

    public TagCW write(TagCW compound) {
        compound.set("parent", this.parent == null ? this.rid : this.parent.id);
        if (this.origin != null) {
            compound.set("origin", this.origin);
        }
        this.cpivot.save(compound);
        compound.set("pos_x", this.position.x);
        compound.set("pos_y", this.position.y);
        compound.set("pos_z", this.position.z);
        return compound;
    }

    public SwivelPoint read(SwivelPoint point, VehicleData data, TagCW com) {
        if (point == null) {
            point = new SwivelPoint(com.getString("id"), com.getString("parent"));
        }
        point.origin = com.has("origin") ? com.getString("origin") : null;
        point.position = new V3D(com.getDouble("pos_x"), com.getDouble("pos_y"), com.getDouble("pos_z"));
        point.prevpos = new V3D(point.position.x, point.position.y, point.position.z);
        point.cpivot = Pivot.load(com);
        point.ppivot.copy(this.cpivot);
        if (this.origin != null) {
            PartData part = data.getPart(this.origin.split("\\|")[0]);
            if (part != null) {
                this.cloneMovers(((Part)part.getType()).getDefaultSwivelPoints());
            }
        } else {
            this.cloneMovers(((Vehicle)data.getType()).getDefaultSwivelPoints());
        }
        return point;
    }

    private void cloneMovers(Map<String, SwivelPoint> points) {
        SwivelPoint orig = points.get(this.id);
        if (orig != null) {
            ArrayList arrayList = this.movers = orig.movers == null ? null : new ArrayList();
            if (this.movers != null) {
                orig.movers.forEach(mover -> this.movers.add(mover.clone()));
            }
        }
    }

    public void linkToParent(VehicleData data) {
        if (this.isVehicle()) {
            return;
        }
        this.parent = data.getRotationPoint(this.rid);
        if (this.parent.id.equals(this.id)) {
            this.parent = null;
        }
        if (this.detached) {
            if (!data.getRotationPoint((String)DEFAULT).subs.contains(this)) {
                data.getRotationPoint((String)DEFAULT).subs.add(this);
            }
        } else if (this.parent != null && !this.parent.subs.contains(this)) {
            this.parent.subs.add(this);
        }
    }

    public SwivelPoint clone(String string) {
        SwivelPoint point = new SwivelPoint(this.id, this.rid);
        point.position = new V3D(this.position.x, this.position.y, this.position.z);
        point.prevpos = new V3D(this.prevpos.x, this.prevpos.y, this.prevpos.z);
        point.detached = this.detached;
        point.origin = string;
        point.cpivot = this.cpivot.copy();
        point.ppivot = this.ppivot.copy();
        if (this.movers != null) {
            point.movers = new ArrayList();
            for (SwivelPointMover mover : this.movers) {
                point.movers.add(mover.clone());
            }
        }
        return point;
    }

    public V3D getPos() {
        return this.position;
    }

    public V3D getPrevPos() {
        return this.prevpos;
    }

    public void setPos(double posX, double posY, double posZ) {
        this.prevpos = new V3D(this.position.x, this.position.y, this.position.z);
        this.position = new V3D(posX, posY, posZ);
    }

    public void update(VehicleInstance vehicle) {
        if (this == vehicle.point) {
            return;
        }
        this.updatePrevAxe();
        this.prevpos = this.position;
        if (!vehicle.entity.isOnClient() && this.movers != null) {
            for (SwivelPointMover mover : this.movers) {
                mover.update(vehicle, this);
            }
        }
        if (this.servticker <= 0) {
            return;
        }
        double x = this.position.x + (this.servpos.x - this.position.x) / (double)this.servticker;
        double y = this.position.y + (this.servpos.y - this.position.y) / (double)this.servticker;
        double z = this.position.z + (this.servpos.z - this.position.z) / (double)this.servticker;
        this.setPos(x, y, z);
        double yaw = this.wrapdeg(this.servrot.x - (double)this.cpivot.deg_yaw());
        double pitch = this.wrapdeg(this.servrot.y - (double)this.cpivot.deg_pitch());
        double roll = this.wrapdeg(this.servrot.z - (double)this.cpivot.deg_roll());
        this.cpivot.set_rotation((double)this.cpivot.deg_yaw() + yaw / (double)this.servticker, (double)this.cpivot.deg_pitch() + pitch / (double)this.servticker, (double)this.cpivot.deg_roll() + roll / (double)this.servticker, true);
        --this.servticker;
    }

    private double wrapdeg(double deg) {
        while (deg > 180.0) {
            deg -= 360.0;
        }
        while (deg < -180.0) {
            deg += 360.0;
        }
        return deg;
    }

    public void processPacket(Packet_SPUpdate pkt, boolean side) {
        if (side) {
            this.servpos = new V3D(pkt.posX, pkt.posY, pkt.posZ);
            this.servrot = new V3D((double)pkt.yaw, (double)pkt.pitch, (double)pkt.roll);
            this.servticker = 5;
        } else {
            this.setPos(pkt.posX, pkt.posY, pkt.posZ);
            this.updatePrevAxe();
            this.cpivot.set_rotation(pkt.yaw, pkt.pitch, pkt.roll, true);
        }
    }

    public V3D getRelativeVector(double x, double y, double z) {
        V3D rel = this.cpivot.get_vector(x, y, z);
        if (this.parent != null) {
            return this.parent.getRelativeVector(this.position.x + rel.x, this.position.y + rel.y, this.position.z + rel.z);
        }
        return rel;
    }

    public V3D getRelativeVector(V3D vec) {
        return this.getRelativeVector(vec.x, vec.y, vec.z);
    }

    public V3D getPrevRelativeVector(double x, double y, double z) {
        V3D rel = this.ppivot.get_vector(x, y, z);
        if (this.parent != null) {
            return this.parent.getPrevRelativeVector(this.prevpos.add(rel));
        }
        return rel;
    }

    public V3D getPrevRelativeVector(V3D vec) {
        return this.getPrevRelativeVector(vec.x, vec.y, vec.z);
    }

    public final boolean isVehicle() {
        return this.id.equals(DEFAULT);
    }

    public void sendUpdatePacket(EntityW entity) {
        if (this.movers == null) {
            return;
        }
        boolean should = false;
        for (SwivelPointMover mover : this.movers) {
            if (!mover.shouldUpdate()) continue;
            should = true;
            break;
        }
        if (!should) {
            return;
        }
        Packets.sendToAllTrackingEnt(Packet_SPUpdate.class, entity, entity, this);
    }
}

