/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.vehicle;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPointMover;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;

public class ZHydSwivelPointMover
implements SwivelPointMover {
    private SwivelPoint opoint;
    private SwivelPoint point;
    private String opoint_id;
    private V3D loff;
    private V3D toff;
    private V3D here;
    private V3D ther;
    private float ang;

    public ZHydSwivelPointMover(JsonMap map) {
        this.opoint_id = map.getString("towards_point", null);
        this.loff = map.has("local_offset") ? ContentConfigUtil.getVector(map.getArray("local_offset")) : new V3D();
        this.toff = map.has("towards_offset") ? ContentConfigUtil.getVector(map.getArray("towards_offset")) : new V3D();
        this.ang = Static.toRadians((float)map.getFloat("add_angle", 0.0f));
    }

    public ZHydSwivelPointMover(String point, V3D lo, V3D to, float an) {
        this.opoint_id = point;
        this.loff = lo;
        this.toff = to;
        this.ang = an;
    }

    @Override
    public void update(VehicleInstance vehicle, SwivelPoint point) {
        this.point = point;
        if (this.opoint_id == null) {
            return;
        }
        this.opoint = vehicle.data.getRotationPoint(this.opoint_id);
        if (this.opoint == null || this.opoint == point) {
            return;
        }
        this.here = point.getRelativeVector(this.loff);
        this.ther = this.opoint.getRelativeVector(this.toff).sub(this.here);
        point.getPivot().set_rot(-Math.atan2(this.ther.x, this.ther.z), Math.atan2(-Math.sqrt(this.ther.x * this.ther.x + this.ther.z * this.ther.z), this.ther.y) + (double)this.ang, 0.0, false);
    }

    @Override
    public SwivelPointMover clone() {
        return new ZHydSwivelPointMover(this.opoint_id, this.loff, this.toff, this.ang);
    }

    @Override
    public boolean shouldUpdate() {
        return this.point.getPrevPivot().yaw() != this.point.getPivot().yaw() || this.point.getPrevPivot().pitch() != this.point.getPivot().pitch();
    }
}

