/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.event;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.lib.mc.utils.Static;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.block.ContainerEntity;
import net.fexcraft.mod.fvtm.block.DisplayEntity;
import net.fexcraft.mod.fvtm.block.generated.BlockTileEntity;
import net.fexcraft.mod.fvtm.block.generated.MultiblockTileEntity;
import net.fexcraft.mod.fvtm.data.TextureSupply;
import net.fexcraft.mod.fvtm.data.addon.Addon;
import net.fexcraft.mod.fvtm.data.addon.AddonLocation;
import net.fexcraft.mod.fvtm.data.container.ContainerHolder;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleEntity;
import net.fexcraft.mod.fvtm.entity.DecorationEntity;
import net.fexcraft.mod.fvtm.item.BlockItem;
import net.fexcraft.mod.fvtm.item.ContainerItem;
import net.fexcraft.mod.fvtm.item.PartItem;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.fvtm.sys.road.RoadPlacingCache;
import net.fexcraft.mod.fvtm.sys.road.RoadPlacingUtil;
import net.fexcraft.mod.fvtm.sys.uni.RootVehicle;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.caps.ContainerHolderUtil;
import net.fexcraft.mod.fvtm.util.caps.MultiBlockCacheSerializer;
import net.fexcraft.mod.fvtm.util.caps.RenderCacheHandler;
import net.fexcraft.mod.fvtm.util.caps.VAPDataCache;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.UniChunk;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EventHandler {
    private static Field flightdata;
    private static boolean flightdata_failed;
    private static Field i18n_locale;
    private static Method locale_load_is;
    private static Method locale_check_uni;

    @SubscribeEvent
    public void onAttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() instanceof VehicleItem || ((ItemStack)event.getObject()).func_77973_b() instanceof PartItem || ((ItemStack)event.getObject()).func_77973_b() instanceof ContainerItem || ((ItemStack)event.getObject()).func_77973_b() instanceof BlockItem) {
            event.addCapability(new ResourceLocation("fvtm:vapdatacache"), (ICapabilityProvider)new VAPDataCache((ItemStack)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onAttachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        WorldW world = WrapperHolder.getWorld((Object)event.getObject());
        SystemManager.initWorldSystems(world, world.type());
        event.addCapability(new ResourceLocation("fvtm:multiblocks"), (ICapabilityProvider)new MultiBlockCacheSerializer((World)event.getObject()));
    }

    @SubscribeEvent
    public void onAttachChunkCapabilities(AttachCapabilitiesEvent<Chunk> event) {
    }

    @SubscribeEvent
    public void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (((Entity)event.getObject()).field_70170_p == null) {
            return;
        }
        if (event.getObject() instanceof ContainerHolder.ContainerHolderWrapper) {
            event.addCapability(new ResourceLocation("fvtm:container"), (ICapabilityProvider)new ContainerHolderUtil((Entity)event.getObject()));
        }
        if (((Entity)event.getObject()).field_70170_p.field_72995_K && event.getObject() instanceof VehicleEntity) {
            event.addCapability(new ResourceLocation("fvtm:rendercache"), (ICapabilityProvider)new RenderCacheHandler());
        }
        if (((Entity)event.getObject()).field_70170_p.field_72995_K && event.getObject() instanceof RootVehicle) {
            event.addCapability(new ResourceLocation("fvtm:rendercache"), (ICapabilityProvider)new RenderCacheHandler());
        }
        if (event.getObject() instanceof EntityPlayer && ((Entity)event.getObject()).field_70170_p.field_72995_K) {
            event.addCapability(new ResourceLocation("fvtm:rendercache"), (ICapabilityProvider)new RenderCacheHandler());
        }
        if (((Entity)event.getObject()).field_70170_p.field_72995_K && event.getObject() instanceof DecorationEntity) {
            event.addCapability(new ResourceLocation("fvtm:rendercache"), (ICapabilityProvider)new RenderCacheHandler());
        }
    }

    @SubscribeEvent
    public void onAttachTileEntityCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        if (Static.side().isClient() && (event.getObject() instanceof DisplayEntity || event.getObject() instanceof BlockTileEntity || event.getObject() instanceof ContainerEntity)) {
            event.addCapability(new ResourceLocation("fvtm:rendercache"), (ICapabilityProvider)new RenderCacheHandler());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        SystemManager.onServerTick();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        SystemManager.onClientTick();
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        SystemManager.onChunkLoad(WrapperHolder.getWorld((Object)event.getWorld()), UniChunk.getChunkN((Object)event.getChunk()));
        event.getChunk().func_177434_r().values().forEach(tile -> {
            if (tile instanceof MultiblockTileEntity) {
                ((MultiblockTileEntity)tile).setup();
            }
        });
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        SystemManager.onChunkUnload(WrapperHolder.getWorld((Object)event.getWorld()), UniChunk.getChunk((Object)event.getChunk()));
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        SystemManager.onWorldLoad(WrapperHolder.getWorld((Object)event.getWorld()));
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        SystemManager.onWorldUnload(WrapperHolder.getWorld((Object)event.getWorld()));
        WrapperHolder.INSTANCE.reset();
    }

    @SubscribeEvent
    public void regSounds(RegistryEvent.Register<SoundEvent> event) {
        FvtmRegistry.VEHICLES.forEach(vehicle -> vehicle.getSounds().values().forEach(sound -> {
            if (event.getRegistry().containsKey((ResourceLocation)sound.soundid.local())) {
                sound.event = event.getRegistry().getValue((ResourceLocation)sound.soundid.local());
            } else {
                SoundEvent soundevent = (SoundEvent)new SoundEvent((ResourceLocation)sound.soundid.local()).setRegistryName(sound.soundid.colon());
                sound.event = soundevent;
                event.getRegistry().register((IForgeRegistryEntry)sound.event);
            }
        }));
        FvtmRegistry.PARTS.forEach(part -> part.getSounds().values().forEach(sound -> {
            if (event.getRegistry().containsKey((ResourceLocation)sound.soundid.local())) {
                sound.event = event.getRegistry().getValue((ResourceLocation)sound.soundid.local());
            } else {
                SoundEvent soundevent = (SoundEvent)new SoundEvent((ResourceLocation)sound.soundid.local()).setRegistryName(sound.soundid.colon());
                sound.event = soundevent;
                event.getRegistry().register((IForgeRegistryEntry)sound.event);
            }
        }));
    }

    @SubscribeEvent
    public void onPlayerIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityW ent = UniEntity.getEntity((Object)event.player);
        if (event.player.field_70170_p.field_72995_K) {
            RailPlacingUtil.CL_CURRENT = null;
            RoadPlacingUtil.CL_CURRENT = null;
        }
        if (event.player.field_70170_p != null && !event.player.field_70170_p.field_72995_K) {
            TagCW cfgsync = TagCW.create();
            cfgsync.set("sync_rate", (int)Config.VEHICLE_SYNC_RATE);
            Packets.sendTo(Packets.PKT_TAG, ent, "sync_conf", cfgsync);
        }
        if (!event.player.field_70170_p.field_72995_K) {
            RoadPlacingCache.onLogIn(event.player.func_146103_bH().getId());
        }
        SystemManager.syncPlayer(WrapperHolder.getWorld((Object)event.player.field_70170_p).type().side_key(), ent);
    }

    @SubscribeEvent
    public void onPlayerDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        SystemManager.syncPlayer(WrapperHolder.getWorld((Object)event.player.field_70170_p).type().side_key(), UniEntity.getEntity((Object)event.player));
    }

    @SubscribeEvent
    public void onPlayerOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            RailPlacingUtil.CURRENT.remove(event.player.func_146103_bH().getId());
            RoadPlacingCache.onLogOut(event.player.func_146103_bH().getId());
        }
        if (Config.DISMOUNT_ON_LOGOUT && event.player.func_184187_bx() instanceof RootVehicle) {
            event.player.func_184210_p();
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        if (event.getEntity().func_184218_aH() && event.getEntity().func_184187_bx() instanceof RootVehicle) {
            event.setCanceled(true);
        }
    }

    public static void linkTextureSuppliers() {
        for (Addon addon : FvtmRegistry.ADDONS) {
            if (addon.getTextureSuppliers().isEmpty()) continue;
            for (TextureSupply texsupp : addon.getTextureSuppliers().values()) {
                for (String tar : texsupp.targets()) {
                    String[] split = tar.split(";");
                    Textureable.TextureHolder holder = null;
                    switch (split[0]) {
                        case "vehicle": {
                            holder = FvtmRegistry.VEHICLES.get(split[1]);
                            break;
                        }
                        case "part": {
                            holder = FvtmRegistry.PARTS.get(split[1]);
                            break;
                        }
                        case "container": {
                            holder = FvtmRegistry.CONTAINERS.get(split[1]);
                        }
                    }
                    if (holder == null) continue;
                    for (IDL tex : texsupp.textures()) {
                        holder.getDefaultTextures().add((IDL)tex.local());
                    }
                }
            }
        }
    }

    public static void resetFlight(EntityPlayerMP passenger) {
        if (flightdata == null && !flightdata_failed) {
            try {
                flightdata = ObfuscationReflectionHelper.findField(NetHandlerPlayServer.class, (String)"field_147365_f");
            }
            catch (Exception e) {
                Print.log((Object)"Failed to get field. [FLIGHTDATA:ERR:0]");
            }
        }
        if (flightdata != null && !flightdata_failed) {
            try {
                flightdata.setInt(passenger.field_71135_a, 0);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                if (EnvInfo.DEV) {
                    e.printStackTrace();
                }
                flightdata_failed = true;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void loadLitePackLang() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, FileNotFoundException {
        ArrayList<Addon> lites = new ArrayList<Addon>();
        for (Addon addon : FvtmRegistry.ADDONS) {
            if (addon.getLocation() != AddonLocation.CONFIGPACK) continue;
            lites.add(addon);
        }
        if (lites.size() == 0) {
            return;
        }
        i18n_locale = ObfuscationReflectionHelper.findField(I18n.class, (String)"field_135054_a");
        i18n_locale.setAccessible(true);
        locale_load_is = ObfuscationReflectionHelper.findMethod(Locale.class, (String)"func_135021_a", Void.TYPE, (Class[])new Class[]{InputStream.class});
        locale_load_is.setAccessible(true);
        locale_check_uni = ObfuscationReflectionHelper.findMethod(Locale.class, (String)"func_135024_b", Void.TYPE, (Class[])new Class[0]);
        locale_check_uni.setAccessible(true);
        String code = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a().toLowerCase();
        boolean nonus = !code.equals("en_us");
        for (Addon addon : lites) {
            if (addon.getFile().isDirectory()) {
                if (!addon.getFile().isDirectory()) {
                    return;
                }
                File folder = new File(addon.getFile(), "assets/" + addon.getID().id() + "/lang/");
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                for (File file : folder.listFiles()) {
                    if (file.getName().toLowerCase().equals("en_us.lang")) {
                        locale_load_is.invoke(i18n_locale.get(null), new FileInputStream(file));
                        LanguageMap.inject((InputStream)new FileInputStream(file));
                        continue;
                    }
                    if (!nonus || !file.getName().toLowerCase().equals(code + ".lang")) continue;
                    locale_load_is.invoke(i18n_locale.get(null), new FileInputStream(file));
                    LanguageMap.inject((InputStream)new FileInputStream(file));
                }
                continue;
            }
            String path = "assets/" + addon.getID().id() + "/lang/";
            String extension = ".lang";
            try {
                ZipEntry entry;
                ZipFile zip = new ZipFile(addon.getFile());
                ZipInputStream stream = new ZipInputStream(new FileInputStream(addon.getFile()));
                while ((entry = stream.getNextEntry()) != null) {
                    if (entry.getName().equals(path + "en_us" + extension)) {
                        locale_load_is.invoke(i18n_locale.get(null), zip.getInputStream(entry));
                        LanguageMap.inject((InputStream)zip.getInputStream(entry));
                    }
                    if (!nonus || !entry.getName().equals(path + code + extension)) continue;
                    locale_load_is.invoke(i18n_locale.get(null), zip.getInputStream(entry));
                    LanguageMap.inject((InputStream)zip.getInputStream(entry));
                }
                zip.close();
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        locale_check_uni.invoke(i18n_locale.get(null), new Object[0]);
    }

    public static Object[] getInputStream(ResourceLocation resloc) {
        Object[] objectArray;
        InputStream stream;
        Closeable[] close;
        block8: {
            close = null;
            stream = FvtmResources.INSTANCE.getAssetInputStream(IDLManager.getIDL((String)resloc.toString()), false);
            if (stream != null) {
                return new Object[]{stream};
            }
            try {
                ZipEntry entry;
                Addon addon = FvtmRegistry.getAddon(resloc.func_110624_b());
                if (addon == null) break block8;
                if (addon.getFile().isDirectory()) {
                    File file = new File(addon.getFile(), "assets/" + resloc.func_110624_b() + "/" + resloc.func_110623_a());
                    if (file.exists()) {
                        stream = new FileInputStream(file);
                    }
                    break block8;
                }
                String filename = "assets/" + resloc.func_110624_b() + "/" + resloc.func_110623_a();
                ZipFile zip = new ZipFile(addon.getFile());
                ZipInputStream zipstream = new ZipInputStream(new FileInputStream(addon.getFile()));
                close = new Closeable[]{zip, zipstream};
                while ((entry = zipstream.getNextEntry()) != null) {
                    if (!entry.getName().equals(filename)) continue;
                    stream = zip.getInputStream(entry);
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (close == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = stream;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = stream;
            objectArray = objectArray3;
            objectArray3[1] = close;
        }
        return objectArray;
    }

    static {
        flightdata_failed = false;
    }
}

