/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.function.part;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.FJson;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.data.inv.FvtmInv;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WorldW;

public class InventoryFunction
extends PartFunction {
    private FvtmInv inventory;

    public InventoryFunction() {
    }

    public InventoryFunction(InventoryFunction root) {
        this.inventory = root.inventory.copy();
    }

    @Override
    public PartFunction init(Part part, FJson json) {
        JsonMap map = json.asMap();
        InvType type = InvType.parse(map.getString("type", "item"));
        this.inventory = type.newInv();
        this.inventory.init(map);
        return this;
    }

    @Override
    public PartFunction load(TagCW compound) {
        this.inventory.load(compound, "inventory");
        return this;
    }

    @Override
    public TagCW save(TagCW compound) {
        this.inventory.save(compound, "inventory");
        return compound;
    }

    @Override
    public String getId() {
        return "fvtm:inventory";
    }

    @Override
    public PartFunction copy(Part part) {
        return new InventoryFunction(this);
    }

    @Override
    public void addInformation(StackWrapper stack, WorldW world, PartData data, List<String> tooltip, boolean ext) {
        tooltip.add(Formatter.format((String)("&bInvType: &7" + (Object)((Object)this.inventory.type))));
    }

    public FvtmInv inventory() {
        return this.inventory;
    }

    public ArrayList<String> access() {
        return this.inventory.access;
    }
}

