/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.block;

import java.util.Map;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.mod.fvtm.FVTM;
import net.fexcraft.mod.fvtm.block.generated.MultiblockTileEntity;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.CraftBlockScript;
import net.fexcraft.mod.fvtm.data.block.MultiBlockData;
import net.fexcraft.mod.fvtm.data.inv.InvHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class GBlockCraftContainer
extends GenericContainer {
    protected GenericGui<GBlockCraftContainer> gui;
    protected MultiblockTileEntity tile;
    protected CraftBlockScript script;
    protected MultiBlockData data;
    protected EntityPlayerMP mpp;
    public int page;
    public int crafted;
    public int crafttime;
    public String current;
    public String ntstatus;
    public boolean tickable;
    protected static String success = "Recipe Crafted.";
    private byte passed = 0;
    private byte craft = 0;

    public GBlockCraftContainer(EntityPlayer player, World world, int x, int y, int z) {
        super(player);
        if (!player.field_70170_p.field_72995_K) {
            this.mpp = (EntityPlayerMP)player;
        }
        this.tile = (MultiblockTileEntity)world.func_175625_s(new BlockPos(x, y, z));
        this.tickable = ((Block)this.tile.getBlockData().getType()).isTickable();
        this.data = this.tile.getMultiBlockData();
    }

    protected void packet(Side side, NBTTagCompound packet, EntityPlayer player) {
        if (!packet.func_74764_b("cargo")) {
            return;
        }
        if (side.isServer()) {
            switch (packet.func_74779_i("cargo")) {
                case "page": {
                    this.page = packet.func_74764_b("page") ? packet.func_74762_e("page") : 0;
                    break;
                }
                case "reset_recipe": {
                    this.script.resetRecipe();
                    break;
                }
                case "open_chooser": {
                    player.openGui((Object)FVTM.getInstance(), 953, player.field_70170_p, this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p());
                    break;
                }
                case "craft_recipe": {
                    if (this.craft > 0) break;
                    NBTTagCompound compound = new NBTTagCompound();
                    if (this.script.getSelected() == null) {
                        compound.func_74778_a("status", "No recipe selected.");
                    } else if (this.script.getSelected().canCraft(this.script, this.tile.getMultiBlockData(), false)) {
                        this.script.getSelected().craft(this.script, this.tile.getMultiBlockData());
                        compound.func_74778_a("status", success);
                    } else {
                        compound.func_74778_a("status", "Recipe cannot be crafted.");
                    }
                    compound.func_74778_a("cargo", "craft_status");
                    this.send(Side.CLIENT, compound);
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            switch (packet.func_74779_i("cargo")) {
                case "init": {
                    this.page = packet.func_74764_b("page") ? packet.func_74762_e("page") : 0;
                    break;
                }
                case "consumables": {
                    if (!packet.func_74779_i("current").equals(this.current)) {
                        this.crafted = 0;
                    }
                    this.current = packet.func_74779_i("current");
                    this.script.setProcessed(packet.func_74762_e("processed"));
                    this.script.setCooldown(packet.func_74762_e("cooldown"));
                    for (Map.Entry<String, InvHandler> handler : this.data.getInventories().entrySet()) {
                        if (!packet.func_74764_b("c_" + handler.getKey())) continue;
                        handler.getValue().setVarValue(packet.func_74762_e("c_" + handler.getKey()));
                    }
                    this.crafttime = packet.func_74762_e("crafttime");
                    break;
                }
                case "craft_status": {
                    this.ntstatus = packet.func_74779_i("status");
                    if (!this.ntstatus.equals(success)) break;
                    ++this.crafted;
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.tile.func_70296_d();
    }

    public void func_75142_b() {
        if (this.craft > 0) {
            this.craft = (byte)(this.craft - 1);
        }
        this.passed = (byte)(this.passed + 1);
        if (this.passed < 10) {
            return;
        }
        this.passed = 0;
        NBTTagCompound compound = new NBTTagCompound();
        for (Map.Entry<String, InvHandler> entry : this.data.getInventories().entrySet()) {
            if (!entry.getValue().type.isVariable() && !entry.getValue().type.isFluid()) continue;
            compound.func_74768_a("c_" + entry.getKey(), entry.getValue().getVarValue());
        }
        compound.func_74778_a("current", this.script.getCurrentRecipe());
        compound.func_74768_a("cooldown", this.script.getCooldown());
        compound.func_74768_a("processed", this.script.getProcessed());
        compound.func_74768_a("crafttime", this.script.getProcessTime());
        compound.func_74778_a("cargo", "consumables");
        this.send(Side.CLIENT, compound);
    }
}

