/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.handler;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartInstallHandler;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.function.part.BogieFunction;
import net.fexcraft.mod.uni.world.MessageSender;

public class BogieInstallationHandler
extends PartInstallHandler {
    private static List<String> bogies = new ArrayList<String>();

    @Override
    public boolean validInstall(MessageSender sender, PartData part, String cat, VehicleData data, boolean swap) {
        if (!((Vehicle)data.getType()).getVehicleType().isRailVehicle()) {
            sender.send("handler.install.fvtm.bogie.not_rail_vehicle");
            return false;
        }
        if (data.getParts().containsKey(cat)) {
            sender.send("handler.install.fvtm.bogie.category_occupied");
            return false;
        }
        if (!data.getWheelSlots().containsKey(cat)) {
            sender.send("handler.install.fvtm.bogie.bogieslot_missing");
            return false;
        }
        sender.send("handler.install.fvtm.bogie.check_passed");
        return true;
    }

    @Override
    public boolean processInstall(MessageSender sender, PartData part, String cat, VehicleData data) {
        data.getParts().put(cat, part);
        part.setInstalled(null, data.getWheelSlots().get((Object)cat).position, null);
        BogieFunction func = (BogieFunction)part.getFunction("fvtm:bogie");
        if (func != null) {
            func.setBogie(cat);
        }
        BogieData idata = (BogieData)((Part)part.getType()).getInstallHandlerData();
        data.getWheelPositions().put(cat, part.getInstalledPos().add(0.0, (double)(-idata.height), 0.0));
        sender.send("handler.install.fvtm.bogie.success");
        return true;
    }

    @Override
    public boolean validUninstall(MessageSender sender, PartData part, String is_category, VehicleData from, boolean swap) {
        BogieData idata = (BogieData)((Part)part.getType()).getInstallHandlerData();
        if (idata != null && !idata.removable) {
            sender.send("handler.deinstall.fvtm.bogie.part_not_removable");
            return false;
        }
        sender.send("handler.deinstall.fvtm.bogie.check_passed");
        return true;
    }

    @Override
    public boolean processUninstall(MessageSender sender, PartData part, String cat, VehicleData data) {
        part.setInstalled(null, new V3D(0.0, 0.0, 0.0), null);
        data.getParts().remove(cat);
        data.getWheelPositions().remove(cat);
        sender.send("handler.deinstall.fvtm.bogie.success");
        return true;
    }

    @Override
    public List<String> getValidCategories(PartData part, VehicleData vehicle) {
        return bogies;
    }

    @Override
    public Object parseData(JsonMap map) {
        return new BogieData(map);
    }

    static {
        bogies.add("bogie_front");
        bogies.add("bogie_rear");
    }

    public static class BogieData {
        private boolean removable;
        private float height;

        public BogieData(JsonMap map) {
            this.removable = map.getBoolean("Removable", true);
            this.height = map.getFloat("Height", 8.0f);
        }
    }
}

