/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.Fuel;
import net.fexcraft.mod.fvtm.data.Material;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.Lockable;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MaterialItem
extends Item
implements ContentItem<Material>,
Lockable.LockableItem,
ItemTextureable.TextureableItem<Material> {
    private Material material;

    public MaterialItem(Material content) {
        this.material = content;
        this.func_77627_a(true);
        this.func_77625_d(this.material.isFuelContainer() ? 1 : this.material.getMaxStack());
        this.func_77656_e(this.material.getMaxHealth());
        this.setRegistryName(this.material.getID().colon());
        this.func_77655_b(this.material.getID().colon());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(this.material));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(Formatter.format((String)("&9Name: &7" + this.material.getName())));
        for (String s : this.material.getDescription()) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        if (this.material.getOreDictId() != null) {
            tooltip.add(Formatter.format((String)("&9OreDict: &7" + this.material.getOreDictId())));
        }
        if (this.material.isVehicleKey()) {
            tooltip.add(Formatter.format((String)("&9LockCode: &7" + this.getLockCode(UniStack.getStack((Object)stack)))));
        }
        if (this.material.isFuelContainer()) {
            StackWrapper wrapper = UniStack.getStack((Object)stack);
            tooltip.add(Formatter.format((String)("&9Container: &7" + (this.material.isUniversalFuelContainer() ? "universal" : (this.material.getFuelType() == null ? this.material.getFuelGroup() : this.material.getFuelType().getName())))));
            tooltip.add(Formatter.format((String)("&9Fuel Stored: &7" + Fuel.getStoredName(wrapper))));
            tooltip.add(Formatter.format((String)("&9Fuel Amount: &7" + Fuel.getStoredAmount(wrapper) + "mB")));
        }
        if (this.material.getImpactLevel() > -1) {
            tooltip.add(Formatter.format((String)("&9Impact Wrench Level: &7" + this.material.getImpactLevel())));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab != CreativeTabs.field_78027_g && tab != this.func_77640_w()) {
            return;
        }
        items.add(this.material.getNewStack().local());
        if (!this.material.isFuelContainer() || this.material.isUniversalFuelContainer()) {
            return;
        }
        for (Fuel fuel : FvtmRegistry.FUELS) {
            if (!this.material.isValidFuel(fuel)) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("StoredFuelType", fuel.getID().colon());
            compound.func_74768_a("StoredFuelAmount", this.material.getFuelCapacity());
            ItemStack stack = (ItemStack)this.material.getNewStack().local();
            stack.func_77982_d(compound);
            items.add((Object)stack);
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!EnvInfo.DEV) {
            return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        player.func_184586_b(hand).func_77973_b().setDamage(player.func_184586_b(hand), player.func_184586_b(hand).func_77952_i() - 1);
        return EnumActionResult.SUCCESS;
    }

    public int getItemBurnTime(ItemStack stack) {
        return this.material.getItemBurnTime() * stack.func_190916_E();
    }

    @Override
    public Material getContent() {
        return this.material;
    }

    @Override
    public ContentType getType() {
        return ContentType.MATERIAL;
    }

    @Override
    public String getLockCode(StackWrapper stack) {
        if (!this.material.isVehicleKey()) {
            return null;
        }
        if (!stack.directTag().has("LockCode")) {
            stack.updateTag(tag -> tag.set("LockCode", Lockable.newCode()));
        }
        return stack.directTag().getString("LockCode");
    }
}

