/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.block.generated.FvtmProperties;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.block.MultiBlock;
import net.fexcraft.mod.fvtm.data.block.MultiBlockData;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiBlockItem
extends Item
implements ContentItem.ContentDataItem<MultiBlock, MultiBlockData> {
    private MultiBlock mblock;

    public MultiBlockItem(MultiBlock block) {
        this.mblock = block;
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setRegistryName(this.mblock.getID().colon());
        this.func_77655_b(this.mblock.getID().colon());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(this.mblock));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(Formatter.format((String)("&9Name: &7" + this.mblock.getName())));
        for (String s : this.mblock.getDescription()) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
    }

    @Override
    public MultiBlockData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public MultiBlockData getData(TagCW compound) {
        return new MultiBlockData(this.mblock).read(compound);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == CreativeTabs.field_78027_g || tab == this.func_77640_w()) {
            items.add(this.mblock.getNewStack().local());
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ArrayList<V3I> poslist;
        if (world.field_72995_K || side != EnumFacing.UP) {
            return EnumActionResult.PASS;
        }
        BlockPos core = world.func_180495_p(pos = pos.func_177982_a(0, 1, 0)).func_177230_c().func_176200_f((IBlockAccess)world, pos) ? pos : pos.func_177982_a(0, 1, 0);
        if (MultiBlockItem.isValidPostitionForMultiBlock(world, player, core, poslist = this.mblock.getPositions(new V3I(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), WrapperHolder.getSide((Object)player.func_174811_aO())))) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74772_a("PlacedPos", core.func_177986_g());
            EnumFacing facing = player.func_174811_aO();
            for (int i = 0; i < poslist.size(); ++i) {
                Block block = (Block)Block.field_149771_c.func_82594_a(this.mblock.getBlocks().get(i).getKey().local());
                IBlockState state = block.func_176223_P().func_177226_a((IProperty)FvtmProperties.FACING, (Comparable)MultiBlock.rotate(this.mblock.getBlocks().get(i).getValue(), (Object)facing).local());
                BlockPos blkpos = new BlockPos(poslist.get((int)i).x, poslist.get((int)i).y, poslist.get((int)i).z);
                state.func_177230_c().func_180633_a(world, blkpos, state.func_177226_a((IProperty)FvtmProperties.FACING, (Comparable)facing), (EntityLivingBase)player, stack);
            }
            stack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static boolean isValidPostitionForMultiBlock(World world, EntityPlayer player, BlockPos pos, ArrayList<V3I> list) {
        BlockPos.MutableBlockPos obstacle = null;
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        IBlockState state = null;
        for (V3I blkpos : list) {
            state = world.func_180495_p((BlockPos)mut.func_181079_c(blkpos.x, blkpos.y, blkpos.z));
            if (state.func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)mut)) continue;
            obstacle = mut;
            break;
        }
        if (obstacle != null) {
            Print.bar((EntityPlayer)player, (String)String.format("Obstacle at position: %sx, %sy, %sz!", obstacle.func_177958_n(), obstacle.func_177956_o(), obstacle.func_177952_p()));
            return false;
        }
        return true;
    }

    @Override
    public MultiBlock getContent() {
        return this.mblock;
    }

    @Override
    public ContentType getType() {
        return ContentType.MULTIBLOCK;
    }
}

