/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.fvtm.util.VecUtil;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RailPresetItem
extends Item
implements ContentItem<RailGauge>,
JunctionGridItem {
    private RailGauge gauge;
    private RailGauge.Preset preset;
    private int rotations;

    public RailPresetItem(RailGauge type, RailGauge.Preset set) {
        this.gauge = type;
        this.preset = set;
        this.func_77627_a(true);
        this.setRegistryName(this.gauge.getID().colon());
        this.func_77655_b(this.gauge.getID().colon());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(this.gauge));
    }

    public RailPresetItem setSegmentation(int segments) {
        this.rotations = segments;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Formatter.format((String)("&9Name: &7" + this.gauge.getName())));
        for (String s : this.gauge.getDescription()) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        tooltip.add(Formatter.format((String)("&9Width: &7" + this.gauge.getWidth())));
        if (this.gauge.getCompatible().size() > 0) {
            tooltip.add(Formatter.format((String)"&9Compatible with:"));
            for (String str : this.gauge.getCompatible()) {
                tooltip.add(Formatter.format((String)("&7 - " + str)));
            }
        }
        tooltip.add(Formatter.format((String)"&9- - - - - - &7-"));
        tooltip.add(Formatter.format((String)("&9Preset: &7" + this.preset.name)));
        tooltip.add(Formatter.format((String)("&6Segmentation: &a" + 360.0f / (float)this.rotations + "\u00b0 &7/ &e" + this.rotations + "seg.")));
        tooltip.add(Formatter.format((String)"&b&oThis tool creates junctions where missing and places tracks, use with caution."));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || player.func_70093_af() || Config.DISABLE_RAILS) {
            return EnumActionResult.PASS;
        }
        RailSystem syscap = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)world));
        if (syscap == null) {
            Print.chat((ICommandSender)player, (String)"&cWorld Capability not found.");
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        QV3D vector = new QV3D((float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ);
        Junction start = syscap.getJunction(vector.pos);
        if (start != null && start.tracks.size() >= 4) {
            Print.chat((ICommandSender)player, (String)"&7Junction at Start point has reached max allowed connections.");
            return EnumActionResult.FAIL;
        }
        QV3D[] vecs = this.copyAndRotate(vector, this.preset.path, player.field_70177_z);
        Junction end = syscap.getJunction(vecs[vecs.length - 1].pos);
        if (end != null && end.tracks.size() >= 4) {
            Print.chat((ICommandSender)player, (String)"&7Junction at End point has reached max allowed connections.");
            return EnumActionResult.FAIL;
        }
        if (start == null) {
            syscap.addJunction(vector.copy());
            start = syscap.getJunction(vector.pos);
        }
        Track track = new Track(start, vecs, this.gauge).withPreset(this.gauge.getIDS() + "." + this.preset.name);
        if (end == null) {
            syscap.addJunction(vecs[vecs.length - 1]);
            end = syscap.getJunction(vecs[vecs.length - 1].pos);
        }
        start.addnew(track);
        end.addnew(track.createOppositeCopy());
        start.checkTrackSectionConsistency();
        end.checkTrackSectionConsistency();
        Print.bar((EntityPlayer)player, (String)("&7Track of type &e'" + this.preset.name + "' &7placed!"));
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    public QV3D[] copyAndRotate(QV3D pos, QV3D[] path, float yaw) {
        QV3D[] vecs = new QV3D[path.length];
        for (int i = 0; i < vecs.length; ++i) {
            vecs[i] = path[i];
        }
        int con = (int)(((float)((int)yaw) + 90.0f) * (float)this.rotations / 360.0f);
        float seg = 360.0f / (float)this.rotations;
        if ((float)con % seg > seg / 2.0f) {
            ++con;
        }
        for (int i = 0; i < vecs.length; ++i) {
            vecs[i] = i != 0 && i != vecs.length - 1 ? new QV3D(VecUtil.rotByRad(seg * (float)con * 0.0174533f, vecs[i].vec).add(pos.vec)) : new QV3D(VecUtil.rotByRad(seg * (float)con * 0.0174533f, vecs[i].vec).add(pos.vec));
        }
        return vecs;
    }

    @Override
    public RailGauge getContent() {
        return this.gauge;
    }

    @Override
    public ContentType getType() {
        return ContentType.RAILGAUGE;
    }
}

