/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.SignData;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SignItem
extends Item
implements ContentItem.ContentDataItem<Sign, SignData>,
ItemTextureable.TextureableItem<Sign>,
JunctionGridItem {
    private Sign sign;

    public SignItem(Sign type) {
        this.sign = type;
        this.func_77627_a(true);
        this.func_77625_d(64);
        this.setRegistryName(this.sign.getID().colon());
        this.func_77655_b(this.sign.getID().colon());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(this.sign));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Formatter.format((String)("&9Name: &7" + this.sign.getName())));
        for (String s : this.sign.getDescription()) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        UniStack uni = UniStack.get((Object)stack);
        if (uni == null) {
            return;
        }
        SignData data = this.getData(uni.stack);
        if (data != null) {
            tooltip.add(Formatter.format((String)("&9Texture: &7" + VehicleItem.getTexTitle(data))));
            if (this.sign.getModel() != null && this.sign.getModel().getCreators().size() > 0) {
                tooltip.add(Formatter.format((String)"&9Model by:"));
                for (String str : this.sign.getModel().getCreators()) {
                    tooltip.add(Formatter.format((String)("&7- " + str)));
                }
            }
        }
    }

    @Override
    public Sign getContent() {
        return this.sign;
    }

    @Override
    public ContentType getType() {
        return ContentType.SIGN;
    }

    @Override
    public SignData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public SignData getData(TagCW compound) {
        return new SignData(this.sign).read(compound);
    }
}

