/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.loaders;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.GLObject;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelLoader;

public class BEOModelLoader
implements ModelLoader {
    private static final int END = 0;
    private static final int NAME = 1;
    private static final int AUTHOR = 2;
    private static final int TEXSIZE = 3;
    private static final int GROUP = 4;
    private static final int OBJECT = 5;
    private static final int POSITION = 2;
    private static final int ROTATION = 3;
    private static final int VECTOR = 4;
    private static final int UV = 5;
    private static final int NORMAL = 6;
    private static final int FACE = 7;
    private static ArrayList<Vec3f> vecs = new ArrayList();
    private static ArrayList<float[]> uvs = new ArrayList();

    @Override
    public boolean accepts(String name, String suffix) {
        return suffix.equals("bob") || suffix.equals("beo");
    }

    @Override
    public Object[] load(String name, ModelData confdata, Supplier<Model> supplier) throws Exception {
        int r;
        Object[] streams = FvtmResources.getAssetInputStreamWithFallback(name);
        DefaultModel model = (DefaultModel)supplier.get();
        InputStream stream = (InputStream)streams[0];
        int f0 = stream.read();
        int f1 = stream.read();
        int f2 = stream.read();
        int format = stream.read();
        if (f0 != 6 || f1 != 2 || f2 != 15 || format < 0) {
            return new Object[]{model, confdata};
        }
        block6: while ((r = stream.read()) > -1) {
            switch (r) {
                case 1: {
                    model.name = BEOModelLoader.readString(stream);
                    continue block6;
                }
                case 2: {
                    model.addToCreators(BEOModelLoader.readString(stream));
                    continue block6;
                }
                case 3: {
                    int[] in = BEOModelLoader.readIntegers(stream, 2);
                    model.tex_width = in[0];
                    model.tex_height = in[1];
                    continue block6;
                }
                case 4: {
                    ModelGroup group = new ModelGroup(BEOModelLoader.readString(stream));
                    BEOModelLoader.readPolygons(stream, group, model.tex_width, model.tex_height);
                    model.groups.add(group);
                    continue block6;
                }
            }
        }
        if (streams.length > 1) {
            for (Closeable c : (Closeable[])streams[1]) {
                c.close();
            }
        }
        vecs.clear();
        uvs.clear();
        return new Object[]{model, confdata};
    }

    private static byte[] read(InputStream stream) throws IOException {
        int i;
        ArrayList<Byte> list = new ArrayList<Byte>();
        while ((i = stream.read()) != 0 && i != -1) {
            list.add((byte)i);
        }
        byte[] arr = new byte[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            arr[i2] = (Byte)list.get(i2);
        }
        return arr;
    }

    private static String readString(InputStream stream) throws IOException {
        return new String(BEOModelLoader.read(stream), StandardCharsets.UTF_8);
    }

    private static void readPolygons(InputStream stream, ModelGroup group, int tx, int ty) throws IOException {
        int r;
        block9: while ((r = stream.read()) != -1 && r == 5) {
            ModelRendererTurbo mrt = new ModelRendererTurbo((Object)group, 0, 0, tx, ty);
            block10: while ((r = stream.read()) != -1) {
                if (r == 0) {
                    group.add((Polyhedron<GLObject>)new Polyhedron().importMRT(mrt, false, 0.0625f));
                    continue block9;
                }
                switch (r) {
                    case 1: {
                        mrt.boxName = BEOModelLoader.readString(stream);
                        continue block10;
                    }
                    case 2: {
                        float[] fl = BEOModelLoader.readFloats(stream, 3);
                        mrt.setRotationPoint(fl[0], fl[1], fl[2]);
                        continue block10;
                    }
                    case 3: {
                        float[] fl = BEOModelLoader.readFloats(stream, 3);
                        mrt.setRotationAngle(fl[0], fl[1], fl[2]);
                        continue block10;
                    }
                    case 4: {
                        float[] fl = BEOModelLoader.readFloats(stream, 3);
                        vecs.add(new Vec3f(fl[0], fl[1], fl[2]));
                        continue block10;
                    }
                    case 5: {
                        uvs.add(BEOModelLoader.readFloats(stream, 2));
                        continue block10;
                    }
                    case 6: {
                        continue block10;
                    }
                    case 7: {
                        int len = BEOModelLoader.readIntegers(stream, 1)[0];
                        int[] ids = BEOModelLoader.readIntegers(stream, len + len);
                        TexturedVertex[] verts = new TexturedVertex[len];
                        for (int i = 0; i < len; ++i) {
                            Vec3f vec = vecs.get(ids[i]);
                            float[] uv = uvs.get(ids[i + len]);
                            verts[i] = new TexturedVertex(vec.x, vec.y, vec.z, uv[0], uv[1]);
                        }
                        TexturedPolygon poly = new TexturedPolygon(verts);
                        mrt.copyTo(new TexturedPolygon[]{poly});
                        continue block10;
                    }
                }
            }
        }
    }

    private static float[] readFloats(InputStream stream, int t) throws IOException {
        float[] arr = new float[t];
        for (int i = 0; i < t; ++i) {
            byte[] bit = new byte[4];
            int r = stream.read(bit);
            if (r < 0) {
                return arr;
            }
            arr[i] = ByteBuffer.wrap(bit).getFloat();
        }
        return arr;
    }

    private static int[] readIntegers(InputStream stream, int t) throws IOException {
        int[] arr = new int[t];
        for (int i = 0; i < t; ++i) {
            byte[] bit = new byte[4];
            int r = stream.read(bit);
            if (r < 0) {
                return arr;
            }
            arr[i] = ByteBuffer.wrap(bit).getInt();
        }
        return arr;
    }
}

