/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.loaders;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.tmt.BoxBuilder;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.GLObject;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelLoader;

public class SMPTBJavaModelLoader
implements ModelLoader {
    @Override
    public boolean accepts(String name, String suffix) {
        return suffix.equals("java") || suffix.equals("smptb");
    }

    @Override
    public Object[] load(String name, ModelData confdata, Supplier<Model> supplier) throws Exception {
        Object[] stream = FvtmResources.getAssetInputStreamWithFallback(name);
        DefaultModel model = (DefaultModel)supplier.get();
        String line = null;
        Scanner scanner = new Scanner((InputStream)stream[0]);
        Pattern creator = Pattern.compile("\\/\\/ Model Creator: (.*)");
        Pattern groupdef = Pattern.compile("(.*) = new ModelRendererTurbo\\[\\d+\\];");
        Pattern declaration = Pattern.compile("(.*)\\[(\\d+)\\] = new ModelRendererTurbo\\(this, (\\d+), (\\d+), .*, .*\\);(.*)");
        Pattern box = Pattern.compile("(.*)\\[(\\d+)\\]\\.add.*Box\\((.*)\\);.*");
        Pattern rotpoint = Pattern.compile("(.*)\\[(\\d+)\\]\\.setRotationPoint\\((.*)\\);");
        Pattern pospoint = Pattern.compile("(.*)\\[(\\d+)\\]\\.setPosition\\((.*)\\);");
        String component = "rotateAngle";
        Pattern rotangle = Pattern.compile("(.*)\\[(\\d+)\\]\\." + component + "(.) = (\\d)+F;");
        ArrayList<TemporaryPolygon> polis = new ArrayList<TemporaryPolygon>();
        int linenumber = 0;
        while (scanner.hasNext()) {
            try {
                String[] array;
                TemporaryPolygon poly;
                ++linenumber;
                line = scanner.nextLine().trim();
                if (line.length() < 2) continue;
                if (line.startsWith("public class")) {
                    model.name = line.split(" ")[2].substring(5);
                    continue;
                }
                if (line.startsWith("int textureX")) {
                    model.tex_width = SMPTBJavaModelLoader.parseI(line.split(" ")[3]);
                    continue;
                }
                if (line.startsWith("int textureY")) {
                    model.tex_height = SMPTBJavaModelLoader.parseI(line.split(" ")[3]);
                    continue;
                }
                Matcher matcher = groupdef.matcher(line);
                if (matcher.matches()) {
                    model.groups.add(new ModelGroup(matcher.group(1)));
                    continue;
                }
                matcher = creator.matcher(line);
                if (matcher.matches()) {
                    model.addToCreators(matcher.group(1));
                    continue;
                }
                matcher = declaration.matcher(line);
                if (matcher.matches()) {
                    poly = new TemporaryPolygon();
                    poly.group = matcher.group(1);
                    poly.index = SMPTBJavaModelLoader.parseI(matcher.group(2));
                    poly.mrt.texoffx = SMPTBJavaModelLoader.parseI(matcher.group(3));
                    poly.mrt.texoffy = SMPTBJavaModelLoader.parseI(matcher.group(4));
                    poly.mrt.boxName = matcher.group(5).replace(" // ", "");
                    poly.mrt.textureWidth = model.tex_width;
                    poly.mrt.textureHeight = model.tex_height;
                    polis.add(poly);
                    continue;
                }
                matcher = box.matcher(line);
                if (matcher.matches()) {
                    boolean shapebox = line.contains("ShapeBox");
                    TemporaryPolygon poly2 = SMPTBJavaModelLoader.get(matcher.group(1), matcher.group(2), polis);
                    String[] array2 = matcher.group(3).split(", ");
                    BoxBuilder builder = new BoxBuilder(poly2.mrt);
                    builder.setOffset(SMPTBJavaModelLoader.parseF(array2[0]), SMPTBJavaModelLoader.parseF(array2[1]), SMPTBJavaModelLoader.parseF(array2[2]));
                    builder.setSize(SMPTBJavaModelLoader.parseF(array2[3]), SMPTBJavaModelLoader.parseF(array2[4]), SMPTBJavaModelLoader.parseF(array2[5]));
                    if (shapebox) {
                        builder.setCorner(0, this.newVec3f(array2[7], array2[8], array2[9]));
                        builder.setCorner(1, this.newVec3f(array2[10], array2[11], array2[12]));
                        builder.setCorner(2, this.newVec3f(array2[13], array2[14], array2[15]));
                        builder.setCorner(3, this.newVec3f(array2[16], array2[17], array2[18]));
                        builder.setCorner(4, this.newVec3f(array2[19], array2[20], array2[21]));
                        builder.setCorner(5, this.newVec3f(array2[22], array2[23], array2[24]));
                        builder.setCorner(6, this.newVec3f(array2[25], array2[26], array2[27]));
                        builder.setCorner(7, this.newVec3f(array2[28], array2[29], array2[30]));
                    }
                    model.groups.get(poly2.group).add((Polyhedron<GLObject>)new Polyhedron().importMRT(builder.build(), false, 0.0625f));
                    continue;
                }
                matcher = rotpoint.matcher(line);
                if (matcher.matches()) {
                    poly = SMPTBJavaModelLoader.get(matcher.group(1), matcher.group(2), polis);
                    array = matcher.group(3).split(", ");
                    poly.mrt.rotationAngleX = SMPTBJavaModelLoader.parseF(array[0]);
                    poly.mrt.rotationAngleY = SMPTBJavaModelLoader.parseF(array[1]);
                    poly.mrt.rotationAngleZ = SMPTBJavaModelLoader.parseF(array[2]);
                    continue;
                }
                matcher = pospoint.matcher(line);
                if (matcher.matches()) {
                    poly = SMPTBJavaModelLoader.get(matcher.group(1), matcher.group(2), polis);
                    array = matcher.group(3).split(", ");
                    poly.mrt.rotationPointX = SMPTBJavaModelLoader.parseF(array[0]);
                    poly.mrt.rotationPointY = SMPTBJavaModelLoader.parseF(array[1]);
                    poly.mrt.rotationPointZ = SMPTBJavaModelLoader.parseF(array[2]);
                    continue;
                }
                matcher = rotangle.matcher(line);
                if (!matcher.matches()) continue;
                poly = SMPTBJavaModelLoader.get(matcher.group(1), matcher.group(2), polis);
                String axis = matcher.group(3).toLowerCase();
                float value = SMPTBJavaModelLoader.parseF(matcher.group(4));
                switch (axis) {
                    case "x": {
                        poly.mrt.rotationAngleX = (float)Math.toDegrees(value);
                        break;
                    }
                    case "y": {
                        poly.mrt.rotationAngleY = (float)Math.toDegrees(value);
                        break;
                    }
                    case "z": {
                        poly.mrt.rotationAngleZ = (float)Math.toDegrees(value);
                    }
                }
            }
            catch (Exception e) {
                FvtmLogger.log((Object)"Failed to load SMP TB Model.");
                FvtmLogger.log((Object)("Parsing error at line [" + linenumber + "]: " + line));
            }
        }
        scanner.close();
        if (stream.length > 1) {
            for (Closeable c : (Closeable[])stream[1]) {
                c.close();
            }
        }
        return new Object[]{model, confdata};
    }

    private Vec3f newVec3f(String string1, String string2, String string3) {
        return new Vec3f(SMPTBJavaModelLoader.parseF(string1), SMPTBJavaModelLoader.parseF(string2), SMPTBJavaModelLoader.parseF(string3));
    }

    public static TemporaryPolygon get(String group, String index, ArrayList<TemporaryPolygon> polis) {
        int idx = SMPTBJavaModelLoader.parseI(index);
        for (TemporaryPolygon poly : polis) {
            if (!poly.group.equals(group) || poly.index != idx) continue;
            return poly;
        }
        return null;
    }

    public static int parseI(String string) {
        return Integer.parseInt(string.replace(";", ""));
    }

    public static float parseF(String s) {
        return Float.parseFloat(s.replace("F", ""));
    }

    private static final class TemporaryPolygon {
        public String group;
        public int index;
        public ModelRendererTurbo mrt = new ModelRendererTurbo(null);

        private TemporaryPolygon() {
        }
    }
}

